<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Devize extends CI_Controller {

	function __construct(){
        parent::__construct();
        $this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('Deviz');
    }

	//CRUD
	public function View(){
		$data['devizList'] = $this->Deviz->GetAll();
		$this->template->set('title', 'Lista Devize');
		$this->template->load('TemplateView','devize/DevizeList',$data);
	}

	public function Create(){
		$data['errorMessage']='';

		$this->SetValidationData();

    	if($this->form_validation->run() == false){
    		if(validation_errors()) {
				$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | Dezive Create');
			$this->template->load('TemplateView','devize/DevizeCreate',$data);

    	}
    	else{
    		$this->CreateRecord($this->input->post());
    		redirect('/Devize/View', 'refresh');
		}
	}


	public function Update($Id){

		if(!isset($Id))	{
			redirect('/Devize/View', 'refresh');
			return;
		}

		//set data for view
		$data['errorMessage']='';
		$data['client'] = $this->Deviz->GetById($Id);

		//enable validation
		$this->SetValidationData();

    	if($this->form_validation->run() == false){

    		if(validation_errors()){
    			$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | Client Create');
			$this->template->load('TemplateView','devize/DevizeUpdate',$data);
    	}
    	else{
    		$this->UpdateRecord($this->input->post());
    		redirect('/Devize/View', 'refresh');
		}
	}

	public function Delete($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Devize/View', 'refresh');
			return;
		}

		$this->Client->Delete($Id);
		redirect('/Devize/View', 'refresh');
	}

	//Utils
	private function SetValidationData(){
		$this->form_validation->set_rules('Name','Name','required');
	}

	//Data access
	private function CreateRecord($postData){
		$user = new stdClass();
		$user->Id = -1;
		$user->Name = $postData['Name'];
		$this->Deviz->Create($user);
	}

	private function UpdateRecord($postData){
		$user = new stdClass();
		$user->Id = $postData['Id'];
		$user->Name = $postData['Name'];
		$this->Deviz->Update($user);
	}

	//error tags
	private function GetErrorMessageTag($message){
		return
		'<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">�</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			'.$message.'
		</div>';
	}
}
?>
