<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Projects extends CI_Controller
{
    private $JsModule = "ProjectModule";

    function __construct()
    {
        parent::__construct();
        $this->template->set('jsmodule', $this->JsModule);
        $this->load->model('Project');
        $this->load->model('Projectmodel');
        $this->load->library('smarty_acl');
        $this->load->library('SimpleXLSXGen');
        $this->load->library('form_validation');
        $this->load->model('ProjectArea');
        $this->load->model('User');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

    public function index()
    {

        redirect(site_url('Projects/View'));
    }

    public function View()
    {
        $userId = null;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $userId = $this->smarty_acl->get_admin()['Id'];
        } else {
            if ($this->smarty_acl->get_admin()['group_name'] == 'NTT PM' || $this->smarty_acl->get_admin()['group_name'] == 'NTT Verificator') {
                $userId = [];
                $projectManagerData = $this->User->GetCompanyProjectManager($this->smarty_acl->get_admin()['CompanyId']);
                if (count($projectManagerData) > 0) {
                    foreach ($projectManagerData as $projectManagerKey => $projectManagerVal) {
                        array_push($userId, $projectManagerVal['Id']);
                    }
                }
            }
        }

        $data['projectList'] = $this->Projectmodel->getProjects($userId);
        $this->template->set('title', 'Lista Proiecte');
        $this->template->load('TemplateView', 'projects/ProjectList', $data);

        //     $this->template->set('title', 'Lista Proiecte');
        // $this->template->load('TemplateView', 'projects/ProjectList');
    }

    public function Create()
    {

        $this->smarty_acl->authorized_action();
        $this->template->set('title', 'Adauga Proiect');
        $this->template->load('TemplateView', 'projects/ProjectCreate');
    }

    public function Edit($Id)
    {
        $isAuthorized = true;
        $entityData = $this->Projectmodel->GetEntityById($Id);
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $isAuthorized = false;
            if ($entityData->ProjectManager != null && $entityData->ProjectManager->Id == $this->smarty_acl->get_admin()['Id']) {
                $isAuthorized = true;
            }
        } elseif ($this->smarty_acl->get_admin()['group_name'] == 'NTT PM' || $this->smarty_acl->get_admin()['group_name'] == 'NTT Verificator') {
            if ($entityData->ProjectManager != null || $entityData->ProjectManager->Id != -1 || $entityData->ProjectManager->Id != null) {
                $projectManagerData = $this->User->GetCompanyProjectManager($this->smarty_acl->get_admin()['CompanyId']);
                $userId = [];
                if (count($projectManagerData) > 0) {
                    foreach ($projectManagerData as $projectManagerKey => $projectManagerVal) {
                        array_push($userId, $projectManagerVal['Id']);
                    }
                }
                if (in_array($entityData->ProjectManager->Id, $userId) === false) {
                    $isAuthorized = false;
                }
            }
        }
        if ($isAuthorized) {
            $data['projectId'] = $Id;
            $this->template->set('title', 'Editeaza Proiect');
            $this->template->load('TemplateView', 'projects/ProjectEdit', $data);
        } else {
            return redirect('home/unauthorized');
        }
    }

    public function Delete($Id)
    {
        $this->smarty_acl->authorized_action();

        //TODO: show error on failure
        if (!isset($Id)) {
            redirect('/Projects/View', 'refresh');
            return;
        }

        $this->Project->Delete($Id);
        redirect('/Projects/View', 'refresh');
    }

    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }

    public function AssignTask($id)
    {
        $this->smarty_acl->authorized_action();
        $data['errorMessage'] = '';
        $data['project'] = $this->Projectmodel->GetEntityById($id);
        $data['userList'] = $this->User->getFieldContractor($this->smarty_acl->get_admin()['Id']);
        $this->form_validation->set_rules('SiteManagerId', 'Site manger', 'required');
        if ($this->form_validation->run() == false) {
            if (validation_errors()) {
                $data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
            }
            $this->template->set('title', 'NTT | Assign Task ');
            $this->template->load('TemplateView', 'projects/AssignTask', $data);
        } else {
            $this->Project->AssignTask($this->input->post());
            redirect('/Projects/View', 'refresh');
        }
    }

    //error tags
    private function GetErrorMessageTag($message)
    {
        return
            '<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">�</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			' . $message . '
		</div>';
    }


    public function viewInputEstimation($id)
    {
        $this->smarty_acl->authorized_action();
        $projectData = $this->Project->GetById($id);
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            if ($projectData->ProjectManagerId != null && $projectData->ProjectManagerId->Id != $this->smarty_acl->get_admin()['Id']) {
                return redirect('home/unauthorized');
            }
        }
        if ($projectData->ClientId != null && $projectData->WorkTypeId != null
            && $projectData->ProjectTypeId != null && $projectData->SiteManagerId != null
            && $projectData->Code != null && $projectData->ProjectManagerId != null) {
            $data = [];
            $inputEstimateData = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId']);
            $data['materialTypeData'] = array_filter($inputEstimateData, function ($item) {
                if ($item['estimate_type'] == 1) {
                    return true;
                }
                return false;
            });

            $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));

            $data['serviceTypeData'] = array_filter($inputEstimateData, function ($item) {
                if ($item['estimate_type'] == 2) {
                    return true;
                }
                return false;
            });
            $data['serviceTypeSubTotal'] = array_sum(array_column($data['serviceTypeData'], 'total'));
            $data['grandTotal'] = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];
            if ($this->input->post('submit') == 'submit') {
                $qty = $_POST['qty'];
                $mid = $_POST['mid'];
                $rid = $_POST['rid'];
                $price = $_POST['price'];
                $newData = [];
                $updateData = [];
                $deleteIds = [];
                foreach ($rid as $key => $n) {
                    if ($n == '') {
                        if ($qty[$key] != '') {

                            $newData[] = [
                                'item_id' => $mid[$key],
                                'quantity' => $qty[$key],
                                'project_id' => $id,
                                'price' => $price[$key],
                                'total' => $qty[$key] * $price[$key]
                            ];
                        }
                    } else {
                        if ($qty[$key] != '') {
                            $index = array_search($n, array_column($inputEstimateData, 'rid'));

                            if ($inputEstimateData[$index]['quantity'] != $qty[$key]) {
                                $updateData[] = ['id' => $n, 'quantity' => $qty[$key], 'total' => $qty[$key] * $price[$key]];
                            }
                        } else {
                            array_push($deleteIds, $n);
                        }
                    }
                }
                $isChange = false;
                if (count($newData) > 0) {
                    $this->db->insert_batch('project_input_estimate_file_data', $newData);
                    $isChange = true;
                }
                if (count($updateData) > 0) {
                    $this->db->update_batch('project_input_estimate_file_data', $updateData, 'id');
                    $isChange = true;
                }

                if (count($deleteIds) > 0) {
                    $this->db->where_in('id', $deleteIds);
                    $this->db->delete('project_input_estimate_file_data');
                    $isChange = true;
                }
                if ($isChange === true) {
                    $client = $projectData->ClientId->Name;
                    $workType = $projectData->WorkTypeId->Name;
                    $projectType = $projectData->ProjectTypeId->Name;
                    $siteManager = $projectData->SiteManagerId->Name;
                    $code = $projectData->Code;
                    $projectManager = $projectData->ProjectManagerId->Name;
                    $path = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager . "/" . $code . "/";
                    $inputEstimateFile = $id . "_input_estimation.xlsx";
                    if (!file_exists($path . '/' . 'Pictures' . '/' . $inputEstimateFile)) {
                        mkdir($path . '/' . 'Pictures', 0777, true);
                    } else {
                        unlink($path . '/' . 'Pictures' . '/' . $inputEstimateFile);
                    }
                    $data = [];
                    $inputEstimateData = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId']);
                    $data['materialTypeData'] = array_filter($inputEstimateData, function ($item) {
                        if ($item['estimate_type'] == 1) {
                            return true;
                        }
                        return false;
                    });

                    $data['serviceTypeData'] = array_filter($inputEstimateData, function ($item) {
                        if ($item['estimate_type'] == 2) {
                            return true;
                        }
                        return false;
                    });

                    $data['serviceTypeSubTotal'] = array_sum(array_column($data['serviceTypeData'], 'total'));
                    $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));
                    $data['grandTotal'] = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];

                    $excelData = [['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']];
                    foreach ($data['materialTypeData'] as $key => $val) {
                        array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                    }
                    array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['materialTypeSubTotal']]);
                    array_push($excelData, []);

                    array_push($excelData, ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']);
                    foreach ($data['serviceTypeData'] as $key => $val) {
                        array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                    }
                    array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['serviceTypeSubTotal']]);
                    array_push($excelData, []);
                    array_push($excelData, ['', '', '', '', '', '<b>GrandTotal</b>', $data['grandTotal']]);

                    $xlsx = SimpleXLSXGen::fromArray($excelData);
                    $xlsx->setDefaultFont('Courier New');
                    $xlsx->saveAs($path . '/' . 'Pictures' . '/' . $inputEstimateFile);
                    $messge = array('message' => 'Input Estimation File created successfully', 'class' => 'alert alert-success fade in');
                    $this->session->set_flashdata('item', $messge);

                    $data = $this->db->select('*')->where('project_id', $id)->limit(1)->get('project_input_estimate_file')->row();
                    if ($data == null) {
                        $fileRecordData = ['project_id' => $id, 'url' => $path . '/' . 'Pictures' . '/' . $inputEstimateFile, 'created_at' => date('Y-m-d H:i:s')];
                        $this->db->insert('project_input_estimate_file', $fileRecordData);
                    } else {
                        $fileRecordData = ['url' => $path . '/' . 'Pictures' . '/' . $inputEstimateFile, 'update_at' => date('Y-m-d H:i:s')];
                        $this->db->where('id', $data->id);
                        $this->db->update('project_input_estimate_file', $fileRecordData);
                    }

                } else {
                    $messge = array('message' => 'Input Estimation File created successfully', 'class' => 'alert alert-success fade in');
                    $this->session->set_flashdata('item', $messge);
                }
                redirect('Projects/Edit/' . $id);

            } else {
                $this->template->set('title', 'NTT | Assign Task ');
                $this->template->load('TemplateView', 'projects/InputEstimation', $data);
            }

        } else {
            $messge = array('message' => 'There are some data missing to create folder structure', 'class' => 'alert alert-danger fade in');
            $this->session->set_flashdata('item', $messge);
            redirect('Projects/Edit/' . $id);
        }
    }
}
