<?php
require_once(APPPATH.'models/DbModel.php');

Class Area extends DbModel{

	public $Id;
	public $Name;
	public $Elements;

	function __construct(){
        parent::__construct();
		$this->load->model('Element');
    }

	protected function GetTableName() {
        return "area";
    }

    protected function GetObjectFromDbRow($row) {
		$entity = new Area();

		$entity->Id = $row->Id;
        $entity->TemplateId = $row->TemplateId;

		$entity->Name = $row->Name;
		$entity->Elements = $this->Element->GetByFilter('AreaId',$entity->Id,false);


		return $entity;
    }

    protected function GetObjectFromDbRowForJson($row) {
		$entity = new Area();

		$entity->Id = $row->Id;
        $entity->TemplateId = $row->TemplateId;
		$entity->Name = $row->Name;
		$entity->Elements = $this->Element->GetByFilterForJson('AreaId',$entity->Id);

		return $entity;
    }

    protected function GetDbData($entity) {
        $data = array(
			'Name' => $entity->Name,
            'TemplateId' => $entity->TemplateId
		);

		if($entity->Id != -1)
			$data['Id'] = $entity->Id;

		return $data;
    }

    public function CreateArea($area){
        $area->Id = -1;
        $insertedId = $this->Create($area);

        foreach ($area->Elements as $element){
            $element->Id = -1;
            $element->AreaId = $insertedId;
            $this->Element->Create($element);
        }
    }
}
?>
