<?php

abstract class BaseDatabaseModel extends CI_Model{
    function __construct(){
        parent::__construct(); 
    }
    
    abstract protected function GetTableName();
    abstract protected function GetObjectFromDbRow($row,$inluceRelatedData);
	abstract protected function GetDbData($entity);
    
    /*SINGLE ENTITY**********************************************************/
    public function GetEntityById($entityId, $inluceRelatedData = true){
        if($entityId == -1)
            return null;
            
		$this->db->where('Id', $entityId);
		$query = $this->db->get($this->GetTableName());
        
        if ($query->num_rows() <= 0)
            return null;
            
		return $this->GetObjectFromDbRow($query->row(),$inluceRelatedData);
    }
    
    public function GetEntityByFilter($filterKey , $filterValue, $inluceRelatedData = true){
        $this->db->where($filterKey, $filterValue);
		$query = $this->db->get($this->GetTableName());
        
        if($query->num_rows() <= 0)
            return null;
            
		return $this->GetObjectFromDbRow($query->row(),$inluceRelatedData);
    }
    /*SINGLE ENTITY**********************************************************/
    
    /*ENTITY LIST**********************************************************/
    public function GetEntityListByFilter($filterKey , $filterValue, $inluceRelatedData = true, $useIdAsIndex = true){
        $query = $this->db->get_where($this->GetTableName(), array($filterKey => $filterValue));		
		$entityList = array();
		$data = $query->result();		
		
		foreach($data as $row){
            if($useIdAsIndex)
                $entityList[$row->Id] = $this->GetObjectFromDbRow($row,$inluceRelatedData);
            else
                array_push($entityList, $this->GetObjectFromDbRow($row,$inluceRelatedData));
		}
		return $entityList;
    }
    
    public function GetEntityList($inluceRelatedData = true,$useIdAsIndex = true){
        $query = $this->db->get($this->GetTableName());		
		$data = $query->result();
		$entityList = array();
		
		foreach($data as $row){
            if($useIdAsIndex)
			    $entityList[$row->Id] = $this->GetObjectFromDbRow($row,$inluceRelatedData);
            else
                array_push($entityList, $this->GetObjectFromDbRow($row,$inluceRelatedData));
		}
		return $entityList;
    }
    /*ENTITY LIST**********************************************************/
    
    /*ENTITY LIST BY OFSET**********************************************************/
    public function GetEntityListByFilterAndOfset($filterKey, $filterValue, $take, $skip, $inluceRelatedData = true, $useIdAsIndex = true){
        $query = $this->db->get_where($this->GetTableName(), array($filterKey => $filterValue), $skip, $take);		
		$entityList = array();
		$data = $query->result();
        
		foreach($data as $row){
            if($useIdAsIndex)
                $entityList[$row->Id] = $this->GetObjectFromDbRow($row,$inluceRelatedData);
            else
                array_push($entityList, $this->GetObjectFromDbRow($row,$inluceRelatedData));
		}
		return $entityList;     
    }
    
    public function GetAllByOfset($take,$skip, $inluceRelatedData = true){
        $query = $this->db->get($this->GetTableName(), $skip, $take);		
		$entityList = array();
		$data = $query->result();		
		
		foreach($data as $row){
            if($useIdAsIndex)
                $entityList[$row->Id] = $this->GetObjectFromDbRow($row,$inluceRelatedData);
            else
                array_push($entityList, $this->GetObjectFromDbRow($row,$inluceRelatedData));
		}
		return $entityList;
    }
    /*ENTITY LIST BY FILTER AND OFSET**********************************************************/
    
    /*CRUD*************************************************************************************/
    public function Create($data){                   
		$data = $this->GetDbData($data);
		$this->db->insert($this->GetTableName(), $data);
        return $this->db->insert_id();
	}
	
	public function Update($data){
		$updateData = $this->GetDbData($data);	        
        $this->db->where('Id', $updateData['Id']);
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
	}
    
    public function UpdateByFilter($data,$key){
		$updateData = $this->GetDbData($data);	        
        $this->db->where($key, $updateData[$key]);
        
        $index = array_search('Id', $updateData);
        unset($updateData[$index]);
        
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
	}
	
	public function Delete($Id){
		$this->db->delete($this->GetTableName(), array('Id' => $Id));
        
	}
    /*CRUD*************************************************************************************/
}
