<?php
require_once(APPPATH.'models/DbModel.php');

Class Company extends DbModel{
	
	public $Id;	
	public $Name;
	
	protected function GetTableName() {
        return "company";
    }
    
    protected function GetObjectFromDbRow($row) {
		$company = new Company();

        $company->Id = $row->Id;
        $company->Name = $row->Name;
		
		return $company;
    }
    
    protected function GetDbData($entity) {
        $data = array(	
			'Name' => $entity->Name
		);
		
		if($entity->Id != -1)
			$data['Id'] = $entity->Id;
			
		return $data;
    }


    public function getCompanyItemPrice($id)
    {
        $this->db->select('im.estimate_type,im.id as mid,cip.id as rid,im.sr_no,im.detail,im.unit,im.no_build,im.b2b,cip.price');
        $this->db->from('item_master as im');
        $this->db->join('company_item_price as cip', 'im.id = cip.item_id AND cip.company_id =' . $id . '', 'left');

        return $this->db
            ->get()
            ->result_array();
    }
	
}
?>