<?php
require_once(APPPATH.'models/DbModel.php');

Class Entitate extends DbModel{

	public $Id;

	public $Name;
  public $Adress;

	public $County;
	public $Telephone;

	public $Role;

	function __construct(){
        parent::__construct();
		$this->load->model('Rolentitate');
    }

	protected function GetTableName() {
        return "entitate";
    }

    protected function GetObjectFromDbRow($row) {
		$entity = new Entitate();

		$entity->Id = $row->Id;
		$entity->Name = $row->Name;
		$entity->Adress = $row->Adress;
    $entity->County = $row->County;
		$entity->Telephone = $row->Telephone;
		$entity->Role = $this->Role->GetById($row->RoleId);

		return $entity;
    }

    protected function GetDbData($entity) {

        $data = array(
			'Name' => $entity->Name,
			'Adress' => $entity->Adress,
            'County' => $entity->County,
			'Telephone' => $entity->Telephone,
			'Role' => $entity->Role->Id
		);

		if($entity->Id != -1)
			$data['Id'] = $entity->Id;

		return $data;
    }



}
?>
