<?php
require_once(APPPATH.'models/BaseDatabaseModel.php');

Class UserModel extends BaseDatabaseModel{

	function __construct(){
        parent::__construct();  
		$this->load->model('RoleModel');
        $this->load->model('Company');
    }
	
	protected function GetTableName() {
        return "user";
    }
    
    protected function GetObjectFromDbRow($row,$inluceRelatedData) {
        $entity = new stdClass();
		$entity->Id = $row->Id;
		$entity->Name = $row->Name;
		$entity->Telephone = $row->Telephone;
        $entity->Email = $row->Email;
		$entity->UserName = $row->UserName;
		$entity->Password = $row->Password;
		$entity->Role = $this->RoleModel->GetEntityById($row->RoleId);
        $entity->Company = $this->Company->GetById($row->CompanyId);

		return $entity;
    }
    
    protected function GetDbData($entity) {
    	
        $data = array(
			'Name' => $entity->Name,
			'Telephone' => $entity->Telephone,
            'Email' => $entity->Email,
			'UserName' => $entity->UserName,
			'Password' => $entity->Password,
			'RoleId' => $entity->RoleRef->Id
		);
		
		if($entity->Id != -1)
			$data['Id'] = $entity->Id;
			
		return $data;
    }
    
    public function Login($userName , $password){
        $this->db->where('UserName', $userName);
        $this->db->where('Password', $password);
		$query = $this->db->get($this->GetTableName());
        $row = $query->row();
        if($row!=null)
		    return $this->GetObjectFromDbRow($row,false);  
        
        return null;
    }
}
?>