    <script>
  $(function() {
    $('#datepicker').datepicker({
      format: "yyyy/mm/dd"
    });
    $('#datepicker').on('changeDate', function(ev){
        $(this).datepicker('hide');
    });
  });
  </script>

<!-- Main content -->
<section class="content">
  <!-- Main row -->
  <div class="row" ng-app='project' ng-controller='CreateProjectController as project'>

  	<div class="col-md-6">
      <!-- general form elements -->
      <div class="box box-primary">
        <div class="box-header">
          <h3 class="box-title">Adauga proiect</h3>
        </div><!-- /.box-header -->
        <!-- form start -->

          <div class="box-body">

            <div class="form-group">
                <label>Alege Sablon Poze</label>
                <select class="form-control" ng-model="project.SelectedTemplateId" ng-change="project.templateChanged()">
                    <option ng-repeat="template in project.TemplateList" value="{{template.Id}}">{{template.Name}}</option>
                </select>
            </div>

            <!-- <div class="form-group">
                <label>Alege Sablon Deviz</label>
                <select class="form-control" ng-model="project.SelectedDevizeId" ng-change="project.devizeChanged()">
                    <option ng-repeat="template in project.DevizeList" value="{{template.Id}}">{{template.Name}}</option>
                </select>
            </div> -->

            <div class="form-group">
                <label>Request ID</label>
                <input type="text" class="form-control" placeholder="Request ID" ng-model="project.Code" text="{{project.Code}} ng-model-options="{ getterSetter: true }" required >
            </div>
            <div class="form-group">
              <label>Nume Companie</label>
              <input type="text" class="form-control" placeholder="Nume" ng-model="project.Name" text="{{project.Name}} ng-model-options="{ getterSetter: true }">
            </div>

            <div class="form-group">
              <label>Adresa</label>
              <input type="text" class="form-control" placeholder="Adresa" ng-model="project.Address" text="{{project.Address}} ng-model-options="{ getterSetter: true }">
            </div>

            <div class="form-group">
                <label>Data start</label>
                <div class="input-group">
                    <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                    <input type="text" id="datepicker" class="form-control" ng-model="project.StartDate" text="{{project.StartDate}} ng-model-options="{ getterSetter: true }">

                </div><!-- /.input group -->
            </div>

            <div class="form-group">
              <label>Judet</label>
              <select class="form-control" ng-model="project.DistrictId">
                    <option ng-repeat="district in project.DistrictList" value="{{district.Id}}">{{district.Name}}</option>
              </select>
			</div>

            <div class="form-group">
              <label>Access site</label>
              <input type="text" class="form-control" placeholder="Access site" ng-model="project.SiteAccess" text="{{project.SiteAccess}} ng-model-options="{ getterSetter: true }">
            </div>

            <div class="form-group">
              <label>Client</label>
              <select class="form-control" ng-model="project.ClientId">
                    <option ng-repeat="client in project.ClientList" value="{{client.Id}}">{{client.Name}}</option>
              </select>
			</div>

            <div class="form-group">
              <label>Tip lucrare</label>
              <select class="form-control" ng-model="project.WorkTypeId">
                    <option ng-repeat="workType in project.WorkTypeList" value="{{workType.Id}}">{{workType.Name}}</option>
              </select>
			</div>

            <div class="form-group">
              <label>Tip proiect</label>
              <select class="form-control" ng-model="project.ProjectTypeId">
                    <option ng-repeat="projectType in project.ProjectTypeList" value="{{projectType.Id}}">{{projectType.Name}}</option>
              </select>
			</div>


              <?php if ($this->smarty_acl->get_admin()['group_name'] != 'Admin' && $this->smarty_acl->get_admin()['group_name'] != 'NTT Verificator'): ?>
                  <?php $companyId =$this->smarty_acl->get_admin()['CompanyId'];?>
                  <?php if ($this->smarty_acl->get_admin()['group_name'] == 'NTT PM'): ?>

                      <div class="form-group">
                          <label>Project manager</label>
                          <select class="form-control" ng-model="project.ProjectManagerId">
                              <option ng-repeat="projectManager in project.ProjectManagerList"
                                      value="{{projectManager.Id}}" ng-if="projectManager.CompanyRef.Id == '<?php echo $companyId;?>'">{{projectManager.Name}}
                              </option>
                          </select>
                      </div>
                  <?php else: ?>
                      <div class="form-group">
                          <label>Inginer</label>
                          <select class="form-control" ng-model="project.SiteManagerId">
                              <option ng-repeat="siteManager in project.SiteManagerList" value="{{siteManager.Id}}" ng-if="siteManager.CompanyRef.Id == '<?php echo $companyId;?>'">
                                  {{siteManager.Name}}
                              </option>
                          </select>
                      </div>
                  <?php endif; ?>
              <?php endif; ?>

            <div class="form-group">
              <label>Responsabil site</label>
              <input type="text" class="form-control" placeholder="Responsabil Site" ng-model="project.Responsable" text="{{project.Responsable}} ng-model-options="{ getterSetter: true }">
            </div>

          </div><!-- /.box-body -->
          <div class="box-footer">
            <a href="#"><button ng-click="project.saveProject()" class="btn btn-primary">Salveaza</button></a>
          </div>

      </div><!-- /.box -->
    </div>

    <div class="col-md-6">
      <!-- general form elements -->
      <div class="box box-primary">
        <div class="box-header">
          <h3 class="box-title">Detalii sablon acceptanta - Poze</h3>

        </div><!-- /.box-header -->
       </div><!-- /.box -->
    </div>

    <div class="col-md-2">
      <div class="box box-solid">
        <div class="box-header with-border">
          <h3 class="box-title">Acceptanta</h3>
          <div class="box-tools">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
          </div>
        </div>
        <div class="box-body no-padding">
          <ul class="nav nav-pills nav-stacked">
            <li ng-repeat="area in project.Template.Areas">
                <a href="#" ng-click="project.selectArea($index)"><i class="fa fa-fw fa-circle"></i>{{area.Name}}</a>
            </li>
          </ul>
        </div><!-- /.box-body -->
      </div><!-- /. box -->
    </div>

    <div class="col-md-4">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Poze: {{project.selectedArea.Name}} </h3>
            </div><!-- /.box-header -->
            <div class="box-body no-padding">
                <div class="table-responsive mailbox-messages">
                <table class="table table-hover table-striped">
                    <tbody>

                    <tr ng-repeat="element in project.selectedArea.Elements">
                        <td><input type="checkbox"  ng-model="element.Selected" checked="{{element.Selected}}" style="position: absolute; opacity: 100;"></td>
                        <td valign="middle" class="mailbox-name">{{element.Name}}</td>
                        <td class="mailbox-subject"><b>Poze {{element.NrOfPhotos}}</td>
                    </tr>

                    </tbody>
                </table><!-- /.table -->
                </div><!-- /.mail-box-messages -->
            </div><!-- /.box-body -->
            <div class="box-footer no-padding">

            </div>
        </div><!-- /. box -->
    </div>

    <div class="col-md-6">
      <!-- general form elements -->
      <div class="box box-primary">
        <div class="box-header">
          <h3 class="box-title">Detalii Deviz</h3>

        </div><!-- /.box-header -->
       </div><!-- /.box -->
    </div>

    <div class="col-md-2">
      <div class="box box-solid">
        <div class="box-header with-border">
          <h3 class="box-title">Acceptanta</h3>
          <div class="box-tools">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
          </div>
        </div>
        <div class="box-body no-padding">
          <ul class="nav nav-pills nav-stacked">
            <li ng-repeat="area in project.Devize.Areas">
                <a href="#" ng-click="project.selectAreaDeviz($index)"><i class="fa fa-fw fa-circle"></i>{{area.Name}}</a>
            </li>
          </ul>
        </div><!-- /.box-body -->
      </div><!-- /. box -->
    </div>


    <div class="col-md-4">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Campuri: {{project.selectedAreaDevize.Name}} </h3>
            </div><!-- /.box-header -->
            <div class="box-body no-padding">
                <div class="table-responsive mailbox-messages">
                <table class="table table-hover table-striped">
                    <tbody>

                      <tr ng-repeat="element in project.selectedAreaDevize.DevizItems">
                          <td><input type="checkbox"  ng-model="element.Selected" checked="{{element.Selected}}" style="position: absolute; opacity: 100;"></td>
                          <td valign="middle" class="mailbox-name">{{element.Name}}</td>
                          <td class="mailbox-subject"><b>Camp {{element.Cant}}</td>
                      </tr>

                    </tbody>
                </table><!-- /.table -->
                </div><!-- /.mail-box-messages -->
            </div><!-- /.box-body -->
            <div class="box-footer no-padding">

            </div>
        </div><!-- /. box -->
    </div>

  </div><!-- /.row (main row) -->
</section><!-- /.content -->
