<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Companies extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->model('Company');
        $this->load->library('smarty_acl');
        $this->load->library('SimpleXLSXGen');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

    //CRUD
    public function View()
    {
        $data['companyList'] = $this->Company->GetAll();

        $this->template->set('title', 'Company List');
        $this->template->load('TemplateView', 'companies/CompanyList', $data);
    }

    public function Create()
    {
        $data['errorMessage'] = '';
        $this->form_validation->set_rules('Name', 'Name', 'required|trim|xss_clean|is_unique[company.Name]');
        if ($this->form_validation->run() == false) {
            if (validation_errors()) {
                $data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
            }
            $this->template->set('title', 'NTT | Company Create');
            $this->template->load('TemplateView', 'companies/CompanyCreate', $data);
        } else {
            $this->CreateRecord($this->input->post());
            redirect('/Companies/View', 'refresh');
        }
    }


    public function Update($Id)
    {
        if (!isset($Id)) {
            redirect('/Companies/View', 'refresh');
            return;
        }

        //set data for view
        $data['errorMessage'] = '';
        $data['company'] = $this->Company->GetById($Id);

        if ($this->input->post('Name') != $data['company']->Name) {
            $is_unique = '|is_unique[company.Name]';
        } else {
            $is_unique = '';
        }

        $this->form_validation->set_rules('Name', 'Name', 'required|trim|xss_clean' . $is_unique);
        if ($this->form_validation->run() == false) {
            if (validation_errors()) {
                $data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
            }
            $this->template->set('title', 'NTT | Company Update');
            $this->template->load('TemplateView', 'companies/CompanyUpdate', $data);
        } else {
            $this->UpdateRecord($this->input->post());
            redirect('/Companies/View', 'refresh');
        }
    }

    //Data access
    private function CreateRecord($postData)
    {
        $company = new stdClass();
        $company->Id = -1;
        $company->Name = $postData['Name'];
        $this->Company->Create($company);
    }

    private function UpdateRecord($postData)
    {
        $company = new stdClass();
        $company->Id = $postData['Id'];
        $company->Name = $postData['Name'];
        $this->Company->Update($company);
    }

    //error tags
    private function GetErrorMessageTag($message)
    {
        return
            '<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">�</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			' . $message . '
		</div>';
    }

    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            redirect('Login', 'refresh');
        }
    }

    public function ViewPriceList($id)
    {
        $inputPriceData = $this->Company->getCompanyItemPrice($id);

        $data['materialTypeData'] = array_filter($inputPriceData, function ($item) {
            if ($item['estimate_type'] == 1) {
                return true;
            }
            return false;
        });

        $data['serviceTypeData'] = array_filter($inputPriceData, function ($item) {
            if ($item['estimate_type'] == 2) {
                return true;
            }
            return false;
        });

        if ($this->input->post('submit') == 'submit') {
            $price = $_POST['price'];
            $mid = $_POST['mid'];
            $rid = $_POST['rid'];
            $newData = [];
            $updateData = [];
            $deleteIds = [];
            foreach ($rid as $key => $n) {
                if ($n == '') {
                    if ($price[$key] != '') {
                        $newData[] = [
                            'item_id' => $mid[$key],
                            'price' => $price[$key],
                            'company_id' => $id
                        ];
                    }
                } else {
                    if ($price[$key] != '') {
                        $index = array_search($n, array_column($inputPriceData, 'rid'));

                        if ($inputPriceData[$index]['price'] != $price[$key]) {
                            $updateData[] = ['id' => $n, 'price' => $price[$key]];
                        }
                    } else {
                        array_push($deleteIds, $n);
                    }
                }
            }

            if (count($newData) > 0) {
                $this->db->insert_batch('company_item_price', $newData);

            }
            if (count($updateData) > 0) {
                $this->db->update_batch('company_item_price', $updateData, 'id');

            }

            if (count($deleteIds) > 0) {
                $this->db->where_in('id', $deleteIds);
                $this->db->delete('company_item_price');

            }
            $messge = array('message' => 'Input Estimation File created successfully', 'class' => 'alert alert-success fade in');
            $this->session->set_flashdata('item', $messge);
            redirect('Companies/View');

        } else {
            $this->template->set('title', 'NTT | Assign Task ');
            $this->template->load('TemplateView', 'companies/PriceList', $data);
        }

    }

    public function DownloadPriceList($id)
    {
        $inputPriceData = $this->Company->getCompanyItemPrice($id);
        $data['materialTypeData'] = array_filter($inputPriceData, function ($item) {
            if ($item['estimate_type'] == 1) {
                return true;
            }
            return false;
        });

        $data['serviceTypeData'] = array_filter($inputPriceData, function ($item) {
            if ($item['estimate_type'] == 2) {
                return true;
            }
            return false;
        });

        $excelData = [['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>Price</b>']];
        foreach ($data['materialTypeData'] as $key => $val) {
            array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['price']]);
        }
        array_push($excelData, []);
        array_push($excelData, ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>Price</b>']);
        foreach ($data['serviceTypeData'] as $key => $val) {
            array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['price']]);
        }

        $xlsx = SimpleXLSXGen::fromArray($excelData);
        $xlsx->setDefaultFont('Courier New');
        $xlsx->downloadAs('pricelist.xlsx');


    }
}

?>
