<?php
/**
 * Created by PhpStorm.
 * User: ilogix
 * Date: 9/9/21
 * Time: 12:26 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class GlobalPrice extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('smarty_acl');
        $this->load->library('SimpleXLSXGen');
        $this->load->library('form_validation');
        $this->load->model('Globalprice_model');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

    public function index()
    {
        $data                     = [];
        $globalPriceListData      = $this->Globalprice_model->get();
        $data['materialTypeData'] = array_filter($globalPriceListData, function ($item) {
            if ($item['estimate_type'] == 1) {
                return true;
            }
            return false;
        });


        $data['serviceTypeData'] = array_filter($globalPriceListData, function ($item) {
            if ($item['estimate_type'] == 2) {
                return true;
            }
            return false;
        });

        if ($this->input->post('submit') == 'submit') {

            $price      = $_POST['price'];
            $mid        = $_POST['mid'];
            $rid        = $_POST['rid'];
            $newData    = [];
            $updateData = [];
            foreach ($rid as $key => $n) {
                if ($n == '') {
                    if ($price[$key] != '') {
                        $newData[] = [
                            'item_id' => $mid[$key],
                            'price'   => $price[$key],
                        ];
                    }
                } else {
                    if ($price[$key] != '') {
                        $index = array_search($n, array_column($globalPriceListData, 'rid'));

                        if ($globalPriceListData[$index]['price'] != $price[$key]) {
                            $updateData[] = ['id' => $n, 'price' => $price[$key]];
                        }
                    }
                }
            }

            if (count($newData) > 0) {
                $this->db->insert_batch('global_item_price', $newData);

            }
            if (count($updateData) > 0) {
                $this->db->update_batch('global_item_price', $updateData, 'id');

            }

            $messge = array('message' => 'GlobalPrice List Updated successfully', 'class' => 'alert alert-success fade in');
            $this->session->set_flashdata('item', $messge);
            $globalPriceListData      = $this->Globalprice_model->get();
            $data['materialTypeData'] = array_filter($globalPriceListData, function ($item) {
            if ($item['estimate_type'] == 1) {
                return true;
            }
            return false;
            });


            $data['serviceTypeData'] = array_filter($globalPriceListData, function ($item) {
            if ($item['estimate_type'] == 2) {
                return true;
            }
            return false;
            });

        }
        $this->template->set('title', 'NTT | Global Price ');
        $this->template->load('TemplateView', 'globalprice/GlobalPriceList', $data);


    }

    public function DownloadPriceList()
    {
        $globalPriceListData      = $this->Globalprice_model->get();
        $data['materialTypeData'] = array_filter($globalPriceListData, function ($item) {
            if ($item['estimate_type'] == 1) {
                return true;
            }
            return false;
        });

        $data['serviceTypeData'] = array_filter($globalPriceListData, function ($item) {
            if ($item['estimate_type'] == 2) {
                return true;
            }
            return false;
        });

        $excelData = [['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>Price</b>']];
        foreach ($data['materialTypeData'] as $key => $val) {
            array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['price']]);
        }
        array_push($excelData, []);
        array_push($excelData, ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>Price</b>']);
        foreach ($data['serviceTypeData'] as $key => $val) {
            array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['price']]);
        }
        $xlsx = SimpleXLSXGen::fromArray($excelData);
        $xlsx->setDefaultFont('Courier New');
        $xlsx->downloadAs('globalpricelist.xlsx');
    }

    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            redirect('Login', 'refresh');
        }
    }

}
