<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ProjectElements extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('smarty_acl');
        $this->logged_in();
        $this->load->model('Project');
        $this->load->model('ProjectArea');
        $this->load->model('File');
        $this->load->model('ProjectModel');
    }

    public function SaveElement()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $response          = new stdClass();
            $response->Success = false;
            $response->Message = "Sorry, there was an error uploading your file.";
            try {
                $this->load->helper('custom_helper');
                $path    = "Projects/" . $_POST['Client'] . "/" . $_POST['WorkType'] . "/" . $_POST['ProjectType'] . "/" . $_POST['ProjectManager'] . "/" . $_POST['SiteManager'] . "/" . $_POST['Code'] . "/Pictures/";
                $zipPath = "Projects/" . $_POST['Client'] . "/" . $_POST['WorkType'] . "/" . $_POST['ProjectType'] . "/" . $_POST['ProjectManager'] . "/" . $_POST['SiteManager'] . "/" . $_POST['Code'];
                CreateFolderStructure($path, str_replace('/', '_', $_POST['AreaName']));
                $this->db->select('*');
                $this->db->from('file');
                $this->db->where('ProjectElementId', $_POST['ElementId']);
                $this->db->limit(1);
                $fileData = $this->db->get()->row();

                $path_parts = pathinfo($_FILES["file"]["name"]);
                $extension  = $path_parts['extension'];
                $dbUrl      = $path . str_replace('/', '_', $_POST['AreaName']) . "/" . str_replace('/', '_', $_POST['ElementName']) . '.' . $extension;
                if ($fileData == null) {
                    $file                   = new stdClass();
                    $file->Name             = $_POST['ElementName'];
                    $file->Url              = $dbUrl;
                    $file->ElementId        = $_POST['ElementId'];
                    $file->ProjectElementId = $_POST['ElementId'];
                    $this->File->Create($file);
                    $uploadPath = $path . str_replace('/', '_', $_POST['AreaName']) . '/' . str_replace('/', '_', $_POST['ElementName']) . '.' . $extension;
                    if (move_uploaded_file($_FILES["file"]["tmp_name"], $uploadPath)) {
                        $response->Success = true;
                        $response->Message = "your file uploaded successfully.";
                    }
                } else {
                    // Remove old file if exists
                    if (file_exists($fileData->Url)) {
                        unlink($fileData->Url);
                    }
                    // uploade new file and update record
                    $uploadPath = $path . str_replace('/', '_', $_POST['AreaName']) . '/' . str_replace('/', '_', $_POST['ElementName']) . '.' . $extension;
                    if (move_uploaded_file($_FILES["file"]["tmp_name"], $uploadPath)) {
                        $response->Success = true;
                        $response->Message = "your file uploaded successfully.";
                    }
                    $updateFileRecordData = ['Url' => $dbUrl];
                    $this->db->where('Id', $fileData->Id);
                    $this->db->update('file', $updateFileRecordData);
                }
                CreateZip($zipPath, $_POST['Code']);
                $response->Success = true;
                $response->Message = "your file uploaded successfully.";

            } catch (Exception $e) {
                $response->Success = false;
                $response->Message = $e->getMessage();
            }

            $this->output->set_content_type('application/json')->set_output(json_encode($response));
        } else {
            redirect(site_url('Projects/View'));
        }

    }

    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }
}
