<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ProjectInstallation extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('smarty_acl');
        $this->logged_in();
    }

    public function view($id)
    {
        $isAuthorized = true;
        $this->db->select('p.Code code,p.Id pid,c.Name cname,w.Name wtname,pt.Name ptname,smu.Name suname,pmu.Name puname,p.Name pname,p.ProjectManagerId');
        $this->db->from('project p');
        $this->db->join('client c', 'p.ClientId = c.Id', 'left');
        $this->db->join('worktype w', 'p.WorkTypeId = w.Id', 'left');
        $this->db->join('projecttype pt', 'p.ProjectTypeId = pt.Id', 'left');
        $this->db->join('user smu', 'p.SiteManagerId = smu.Id', 'left');
        $this->db->join('user pmu', 'p.ProjectManagerId = pmu.Id', 'left');
        $this->db->where('p.Id', $id);
        $this->db->limit(1);
        $projectData = $this->db->get()->row();
        if ($projectData != null) {
            if (trim($projectData->code) !== null || trim($projectData->wtname) !== null || trim($projectData->ptname) !== null || trim($projectData->puname) !== null || trim($projectData->suname) !== null || trim($projectData->cname)) {
                if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
                    $isAuthorized = false;
                    if ($projectData->ProjectManagerId != null && $projectData->ProjectManagerId == $this->smarty_acl->get_admin()['Id']) {
                        $isAuthorized = true;
                    }
                }
                $data['id']     = null;
                $data['report'] = null;
                if ($isAuthorized) {
                    $this->db->select('*');
                    $this->db->from('project_installation_report_file');
                    $this->db->where('project_id', $id);
                    $this->db->limit(1);
                    $installationReportData = $this->db->get()->row();
                    if ($installationReportData) {
                        $data['id']     = $installationReportData->id;
                        $path           = $this->escapefile_url(base_url() . $installationReportData->url);
                        $data['report'] = file_get_contents($path);

                    }
                    $data['name'] = $projectData->pname;
                    if ($this->input->post('submit') == 'submit') {
                        $path = "Projects/" . $projectData->cname . "/" . $projectData->wtname . "/" . $projectData->ptname . "/" . $projectData->puname . "/" . $projectData->suname . "/" . $projectData->code;

                        $file = str_replace('', '_', $projectData->code . '_raport_de_instalare.txt');
                        $this->load->helper('custom_helper');
                        if (file_exists($path . '/' . 'Pictures')) {
                            if (file_exists($path . '/' . 'Pictures' . '/' . $file)) {
                                unlink($path . '/' . 'Pictures' . '/' . $file);
                            }
                        } else {
                            mkdir($path . '/' . 'Pictures', 0777, true);
                        }
                        file_put_contents($path . '/' . 'Pictures' . '/' . $file, $this->input->post('report'));

                        if ($installationReportData == null) {
                            $fileRecordData = ['project_id' => $id, 'url' => $path . '/' . 'Pictures' . '/' . $file, 'created_at' => date('Y-m-d H:i:s'), 'name' => $file];
                            $this->db->insert('project_installation_report_file', $fileRecordData);
                        } else {
                            $fileRecordData = ['url' => $path . '/' . 'Pictures' . '/' . $file, 'update_at' => date('Y-m-d H:i:s')];
                            $this->db->where('id', $installationReportData->id);
                            $this->db->update('project_installation_report_file', $fileRecordData);
                        }
                        $this->load->helper('custom_helper');
                        CreateZip($path, $projectData->code);
                        $message = array('message' => 'Installation Report generated successfully', 'class' => 'alert alert-success fade in');
                        $this->session->set_flashdata('InstallationReportItem', $message);
                        redirect('Projects/Edit/' . $id);
                    } else {
                        $this->template->set('title', 'NTT | Deviz Contractor');
                        $this->template->load('TemplateView', 'projects/InstallationReport', $data);
                    }
                }
            } else {
                $message = array('message' => 'There are some data is missing to create folder structure.', 'class' => 'alert alert-danger fade in');
                $this->session->set_flashdata('InstallationReportItem', $message);
                redirect('Projects/Edit/' . $id);
            }
        } else {
            redirect(site_url('Projects/View'));
        }
    }

    private function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }

    private function escapefile_url($url)
    {
        $parts      = parse_url($url);
        $path_parts = array_map('rawurldecode', explode('/', $parts['path']));

        return
            $parts['scheme'] . '://' .
            $parts['host'] .
            implode('/', array_map('rawurlencode', $path_parts));
    }
}
