<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Projects extends CI_Controller
{
    private $JsModule = "ProjectModule";

    function __construct()
    {
        parent::__construct();
        $this->template->set('jsmodule', $this->JsModule);
        $this->load->model('Project');
        $this->load->model('Projectmodel');
        $this->load->library('smarty_acl');
        $this->load->library('SimpleXLSXGen');
        $this->load->library('form_validation');
        $this->load->library('activityLog');
        $this->load->model('ProjectArea');
        $this->load->model('User');
        $this->logged_in();
        $this->smarty_acl->authorized();

        //echo 'constructor end<br>';
    }

    public function index()
    {

        redirect(site_url('Projects/View'));
    }

    public function View()
    {
        $userId = null;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $userId = $this->smarty_acl->get_admin()['Id'];
        }
        $data['projectList'] = $this->Projectmodel->trage($userId);

        //print_r($this->smarty_acl->get_admin());


        $this->db->select('Name, Id, RoleId');
        $this->db->from('user');
        $this->db->where('RoleId', 3);
        if ($userId != null) {
            $this->db->where('Id', $userId);
        }
        $data['contactorPms'] = $this->db->get()->result_array();
        $this->db->select('Id,Name');
        $this->db->from('status');
        $data['allstatus'] = $this->db->get()->result_array();

        $user                    = $this->smarty_acl->get_admin();
        $log_data['message']     = 'All Project list Viewed by ' . $user['UserName'];
        $log_data['activity_id'] = null;
        $log_data['module']      = 'Project';
        $log_data['user_id']     = $user['Id'];
        $log_data['action']      = 'View';
        $this->activitylog->add_log($log_data);

        $this->template->set('title', 'Lista Proiecte');
        $this->template->load('TemplateView', 'projects/ProjectList', $data);

        //     $this->template->set('title', 'Lista Proiecte');
        // $this->template->load('TemplateView', 'projects/ProjectList');
    }

    public function SaveTheFilters(){
        //Mysql for the table that will hold the data
        /**
         * 
           CREATE TABLE `user_selected_filters` (
                `id` INT NOT NULL AUTO_INCREMENT,
                `user_id` INT NOT NULL DEFAULT '0',
                `filters` TEXT NOT NULL,
                PRIMARY KEY (`id`)
            )
            COLLATE='utf8_general_ci'
            ;
         */
        
        /*$userId = 0;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $userId = $this->smarty_acl->get_admin()['Id'];
        }*/
        $filters_data = $this->db->query("SELECT * FROM user_selected_filters WHERE user_id='".$this->smarty_acl->get_admin()['Id']."' ")->result();

        if(count($filters_data)>1){
            exit('Same users have 2 saved filters rows, that is error, it must have just 1 saved filters row');
        }
        if(count($filters_data)==0){
            $this->db->insert('user_selected_filters', [
                'user_id'=>$this->smarty_acl->get_admin()['Id'],
                'filters'=>json_encode([$_POST['filter_id']=>$_POST['value']])
            ]);
        }
        else if(count($filters_data)==1){
            $filters = $filters_data[0]->filters;
            $filters = json_decode($filters, true);
            if(!is_array($filters)){
                $filters = [];
            }
            $filters[$_POST['filter_id']] = $_POST['value'];
            $this->db->update('user_selected_filters', ['filters'=>json_encode($filters)], ['user_id'=>$this->smarty_acl->get_admin()['Id']]);
        }

        exit(json_encode([
            'post'=>$_POST,
            'filters_data_count'=>count($filters_data),
            'last_sql'=>$this->db->last_query(),
            'logged_user'=>$this->smarty_acl->get_admin()
        ]));
    }
    public function SaveTheSortings(){
        $sorting_data = $this->db->query("SELECT * FROM user_selected_filters WHERE user_id='".$this->smarty_acl->get_admin()['Id']."' ")->result();

        if(count($sorting_data)>1){
            exit('Same users have 2 saved sorting/filters rows, that is error, it must have just 1 saved sorting/filters row');
        }
        if(count($sorting_data)==0){
            $this->db->insert('user_selected_filters', [
                'user_id'=>$this->smarty_acl->get_admin()['Id'],
                'sorting'=>json_encode([$_POST['id_table']=>$_POST['order']])
            ]);
        }
        else if(count($sorting_data)==1){
            $sortings = $sorting_data[0]->sorting;
            $sortings = json_decode($sortings, true);
            if(!is_array($sortings)){
                $sortings = [];
            }
            $sortings[$_POST['id_table']] = $_POST['order'];
            $this->db->update('user_selected_filters', ['sorting'=>json_encode($sortings)], ['user_id'=>$this->smarty_acl->get_admin()['Id']]);
        }

        exit(json_encode([
            'post'=>$_POST,
            'filters_data_count'=>count($sorting_data),
            'last_sql'=>$this->db->last_query(),
            'logged_user'=>$this->smarty_acl->get_admin()
        ]));
    }

    public function UploadProjectFileX5(){

        $this->load->helper('custom_helper');

        $project_data = $this->Project->GetById($_POST['project_id']);
        //$path    = "Projects/" . $_POST['Client'] . "/" . $_POST['WorkType'] . "/" . $_POST['ProjectType'] . "/" . $_POST['ProjectManager'] . "/" . $_POST['SiteManager'] . "/" . $_POST['Code'] . "/Pictures/";
        //print_r($project_data->ClientRef);
        $path = "Projects/" 
        . $project_data->ClientRef->Name /*$_POST['Client']*/ . "/"  
        . $project_data->WorkTypeRef->Name /*$_POST['WorkType']*/ . "/" 
        . $project_data->ProjectTypeRef->Name /*$_POST['ProjectType']*/ . "/" 
        . $project_data->ProjectManagerRef->Name /*$_POST['ProjectManager']*/ . "/" 
        . (isset($project_data->SiteManagerRef) && $project_data->SiteManagerRef!=null?$project_data->SiteManagerRef->Name:'SiteMenagerNotDefined') /*$_POST['SiteManager']*/ . "/" 
        . $project_data->Code /*$_POST['Code'] */
        //. "/X5_Files/"
        ;
        $file_folder = $path.'/X5_Files/';
        //exit($path);
        CreateFolderStructure($path, '/X5_Files/');
        
        //exit($file_folder);

        $is_saved = 'not-file-set';

        if(isset($_FILES['file']) && $_FILES['file']['size']>0){

            

            $file_details = [
                'project_id'=>$_POST['project_id'],
                'input_file_name'=>$_POST['file_reference'],
                'folder'=>$file_folder
            ];

            $this->db->select("*");
            $this->db->from('project_uploaded_files');
            $this->db->where($file_details);
            $this->db->limit(1);
            $this->db->order_by('id', 'desc');
            $file_db = $this->db->get()->row();

            if($file_db!=null){

                $file_path_relative_full = $file_db->folder.$file_db->file_name;
                if (file_exists($file_path_relative_full)) {
                    unlink($file_path_relative_full);
                }
            }



            //echo FCPATH.'delete.this.temporary';
            if(move_uploaded_file($_FILES['file']['tmp_name'], 
                    //FCPATH.'delete.this.temporary/'
                    //$path.'/X5_Files/'
                    $file_folder
                    .$_FILES['file']['name'])){
                $is_saved = 'Y';

                /**/
                //After each uploading file i will add one row in database
                if($file_db==null){
                    $this->db->insert('project_uploaded_files', array_merge(
                        [
                            'file_name'=>$_FILES['file']['name']
                        ],
                        $file_details
                    ));
                }
                else{
                    $this->db->update('project_uploaded_files', ['file_name'=>$_FILES['file']['name']], ['id'=>$file_db->id]);
                }

                $this->db->select("*");
                $this->db->from('project_uploaded_files');
                $this->db->where($file_details);
                $this->db->limit(1);
                $this->db->order_by('id', 'desc');
                $file_db = $this->db->get()->row();


                //exit($path.'{}'.$project_data->Code);
                CreateZip( $path.'/', $project_data->Code );


                //exit($this->db->last_query());
            }else{
                $is_saved = 'N';
            }
        }


        exit(json_encode([
            'files'=>$_FILES,
            'post'=>$_POST,
            'is_saved'=>$is_saved,
            'project_data'=>$project_data,
            'file_db'=>(isset($file_db)?$file_db:null),
            'last_file_uploaded'=>isset($_FILES['file'])?$_FILES['file']['name']:''
        ]));
    }

    public function CreateZipTest(){
        
        $this->load->helper('custom_helper');

        $folder = FCPATH.'Projects/Vodafone/test2/B2B FO Remedy/Adrian Paicu/SiteMenagerNotDefined/1389017';
        CreateZip( $folder, '1389017' );

    }


    public function Create()
    {

        $this->smarty_acl->authorized_action();
        $this->template->set('title', 'Adauga Proiect');
        $this->template->load('TemplateView', 'projects/ProjectCreate');
    }

    public function Edit($Id)
    {
        $isAuthorized = true;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $isAuthorized = false;
            $entityData   = $this->Projectmodel->GetEntityById($Id);
            if ($entityData->ProjectManager != null && $entityData->ProjectManager->Id == $this->smarty_acl->get_admin()['Id']) {
                $isAuthorized = true;
            }
        }
        if ($isAuthorized) {
            $data['projectId'] = $Id;

            $GLOBALS['project_data'] = $project_data            = $this->Projectmodel->GetEntityById($Id);
            $user                    = $this->smarty_acl->get_admin();
            $log_data['message']     = '"' . $project_data->Name . '": Project Viewed by ' . $user['UserName'];
            $log_data['activity_id'] = $Id;
            $log_data['module']      = 'Project';
            $log_data['user_id']     = $user['Id'];
            $log_data['action']      = 'View';
            $this->activitylog->add_log($log_data);

            $this->template->set('title', 'Editeaza Proiect');
            $this->template->load('TemplateView', 'projects/ProjectEdit', $data);
        } else {
            return redirect('home/unauthorized');
        }
    }

    public function Delete($Id)
    {
        $this->smarty_acl->authorized_action();

        //TODO: show error on failure
        if (!isset($Id)) {
            redirect('/Projects/View', 'refresh');
            return;
        }
        $projectData             = $this->Projectmodel->GetEntityById($Id);
        $user                    = $this->smarty_acl->get_admin();
        $log_data['message']     = '"' . $projectData->Name . '": Project Deleted by ' . $user['UserName'];
        $log_data['activity_id'] = null;
        $log_data['module']      = 'Project';
        $log_data['user_id']     = $user['Id'];
        $log_data['action']      = 'Delete';

        $this->Project->Delete($Id);
        $this->activitylog->add_log($log_data);
        redirect('/Projects/View', 'refresh');
    }

    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }

    public function AssignTask($id)
    {
        $this->smarty_acl->authorized_action();
        $data['errorMessage'] = '';
        $data['project']      = $projectData = $this->Projectmodel->GetEntityById($id);
        $siteManagerId        = '';

        $data['userList'] = $this->User->getFieldContractor($this->smarty_acl->get_admin()['Id']);
        $this->form_validation->set_rules('SiteManagerId', 'Site manger', 'required');
        if ($this->form_validation->run() == false) {
            if (validation_errors()) {
                $data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
            }
            $this->template->set('title', 'NTT | Assign Task ');
            $this->template->load('TemplateView', 'projects/AssignTask', $data);
        } else {
            if ($projectData->SiteManager) {
                $siteManagerId = $projectData->SiteManager->Id;
            }
            if ($siteManagerId != $this->input->post('SiteManagerId')) {
                $this->Project->AssignTask($this->input->post());
                $user       = $this->smarty_acl->get_admin();
                $pmUserData = $this->User->getUserById($this->input->post('SiteManagerId'));
                $pmUser     = '';
                if ($pmUserData != null) {
                    $pmUser = $pmUserData->UserName;
                }
                $log_data['message']     = '"' . $projectData->Name . '": Project assigned by ' . $user['UserName'] . " To Field Contractor user " . $pmUser;
                $log_data['activity_id'] = $id;
                $log_data['module']      = 'Project';
                $log_data['user_id']     = $user['Id'];
                $log_data['action']      = 'View';
                $this->activitylog->add_log($log_data);

            }
            redirect('/Projects/View', 'refresh');

        }
    }

    //error tags
    private function GetErrorMessageTag($message)
    {
        return
            '<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">�</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			' . $message . '
		</div>';
    }


    public function viewInputEstimation($id)
    {
        $this->smarty_acl->authorized_action();
        $projectData = $this->Project->GetById($id);

        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            if ($projectData->ProjectManagerId != null && $projectData->ProjectManagerId->Id != $this->smarty_acl->get_admin()['Id']) {
                return redirect('home/unauthorized');
            }
        }
        $this->db->select('*');
        $this->db->from('project_installation_report_file');
        $this->db->where('project_id', $id);
        $this->db->limit(1);
        $installationReportData = $this->db->get()->row();
        if ($installationReportData) {
            if ($projectData->ClientId != null && $projectData->WorkTypeId != null
                && $projectData->ProjectTypeId != null && $projectData->SiteManagerId != null
                && $projectData->Code != null && $projectData->ProjectManagerId != null) {

                $user = $this->smarty_acl->get_admin();

                $data                         = [];
                $inputEstimateData            = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId'], 0);
                $data['materialTypeData']     = array_filter($inputEstimateData, function ($item) {
                    if ($item['estimate_type'] == 1) {
                        return true;
                    }
                    return false;
                });
                $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));
                $data['serviceTypeData']      = array_filter($inputEstimateData, function ($item) {
                    if ($item['estimate_type'] == 2) {
                        return true;
                    }
                    return false;
                });
                $data['serviceTypeSubTotal']  = array_sum(array_column($data['serviceTypeData'], 'total'));
                $data['grandTotal']           = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];
                if ($this->input->post('submit') == 'submit') {
                    $isExistFile = true;
                    $fileId      = $this->Project->checkProjectFileExist($id, 0);

                    if ($fileId === null) {
                        $isExistFile    = false;
                        $fileRecordData = ['project_id' => $id, 'is_internal_type' => 0];
                        $this->db->insert('project_input_estimate_file', $fileRecordData);
                        $fileId = $this->db->insert_id();
                    }


                    $qty        = $_POST['qty'];
                    $mid        = $_POST['mid'];
                    $rid        = $_POST['rid'];
                    $price      = $_POST['price'];
                    $newData    = [];
                    $updateData = [];
                    foreach ($rid as $key => $n) {
                        if ($n == '') {
                            $newData[] = [
                                'item_id'    => $mid[$key],
                                'quantity'   => $qty[$key],
                                'project_id' => $id,
                                'price'      => $price[$key],
                                'total'      => $qty[$key] * $price[$key],
                                'file_Id'    => $fileId
                            ];
                        } else {
                            if ($qty[$key] != '') {
                                $index = array_search($n, array_column($inputEstimateData, 'rid'));

                                if ($inputEstimateData[$index]['quantity'] != $qty[$key]) {
                                    $updateData[] = ['id' => $n, 'quantity' => $qty[$key], 'total' => $qty[$key] * $price[$key]];
                                }
                            }
                        }
                    }
                    $isChange = false;
                    if (count($newData) > 0) {
                        $this->db->insert_batch('project_input_estimate_file_data', $newData);
                        $isChange = true;
                    }
                    if (count($updateData) > 0) {
                        $this->db->update_batch('project_input_estimate_file_data', $updateData, 'id');
                        $isChange = true;
                    }
                    if ($isChange === true) {
                        $client            = $projectData->ClientId->Name;
                        $workType          = $projectData->WorkTypeId->Name;
                        $projectType       = $projectData->ProjectTypeId->Name;
                        $siteManager       = $projectData->SiteManagerId->Name;
                        $code              = $projectData->Code;
                        $projectManager    = $projectData->ProjectManagerId->Name;
                        $path              = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager . "/" . $code;
                        $inputEstimateFile = str_replace('', '_', $projectData->Code . '_' . $projectData->Name . '_FO_deviz.xlsx');
                        $this->load->helper('custom_helper');
                        if (file_exists($path . '/' . 'Pictures')) {
                            if (file_exists($path . '/' . 'Pictures' . '/' . $inputEstimateFile)) {
                                unlink($path . '/' . 'Pictures' . '/' . $inputEstimateFile);
                            }
                        } else {
                            mkdir($path . '/' . 'Pictures', 0777, true);
                        }
                        $data                     = [];
                        $inputEstimateData        = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId'], 0);
                        $data['materialTypeData'] = array_filter($inputEstimateData, function ($item) {
                            if ($item['estimate_type'] == 1) {
                                return true;
                            }
                            return false;
                        });
                        $data['serviceTypeData']  = array_filter($inputEstimateData, function ($item) {
                            if ($item['estimate_type'] == 2) {
                                return true;
                            }
                            return false;
                        });

                        $data['serviceTypeSubTotal']  = array_sum(array_column($data['serviceTypeData'], 'total'));
                        $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));
                        $data['grandTotal']           = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];

                        $excelData = [['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']];
                        foreach ($data['materialTypeData'] as $key => $val) {
                            array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                        }
                        array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['materialTypeSubTotal']]);
                        array_push($excelData, []);

                        array_push($excelData, ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']);
                        foreach ($data['serviceTypeData'] as $key => $val) {
                            array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                        }
                        array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['serviceTypeSubTotal']]);
                        array_push($excelData, []);
                        array_push($excelData, ['', '', '', '', '', '<b>GrandTotal</b>', $data['grandTotal']]);

                        $xlsx = SimpleXLSXGen::fromArray($excelData);
                        $xlsx->setDefaultFont('Courier New');
                        $xlsx->saveAs($path . '/' . 'Pictures' . '/' . $inputEstimateFile);
                        $messge = array('message' => 'Deviz Contractor creat cu succes!', 'class' => 'alert alert-success fade in');
                        $this->session->set_flashdata('item', $messge);
                        if ($isExistFile === true) {
                            $updateFileRecordData = ['url' => $path . '/' . 'Pictures' . '/' . $inputEstimateFile, 'update_at' => date('Y-m-d H:i:s')];
                            //add log starts
                            $log_data['message']     = '"' . $projectData->Name . '": Project Input Estimation updated by ' . $user['UserName'];
                            $log_data['activity_id'] = $id;
                            $log_data['module']      = 'Project';
                            $log_data['user_id']     = $user['Id'];
                            $log_data['action']      = 'Update';
                            $this->activitylog->add_log($log_data);
                            //add log ends
                        } else {
                            $updateFileRecordData = ['url' => $path . '/' . 'Pictures' . '/' . $inputEstimateFile, 'created_at' => date('Y-m-d H:i:s'), 'name' => $inputEstimateFile];
                            //add log starts
                            $log_data['message']     = '"' . $projectData->Name . '": Project Input Estimation created by ' . $user['UserName'];
                            $log_data['activity_id'] = $id;
                            $log_data['module']      = 'Project';
                            $log_data['user_id']     = $user['Id'];
                            $log_data['action']      = 'Insert';
                            $this->activitylog->add_log($log_data);
                            //add log ends
                        }
                        $this->db->where('id', $fileId);
                        $this->db->update('project_input_estimate_file', $updateFileRecordData);
                        //CreateZip($path, $code);
                        $this->Project->UpdateStatus($id, 7);

                    } else {
                        $messge = array('message' => 'Deviz Contractor creat cu succes!', 'class' => 'alert alert-success fade in');
                        $this->Project->UpdateStatus($id, 7);
                        $this->session->set_flashdata('item', $messge);
                    }
                    redirect('Projects/Edit/' . $id);

                } else {
                    $this->template->set('title', 'NTT | Deviz Contractor');
                    $this->template->load('TemplateView', 'projects/InputEstimation', $data);
                }

            } else {
                $messge = array('message' => 'Lipsesc date pentru a crea structura folderelor.Asigurate ca lucrarea este alocata de catre contractor la echipa sa de teren.', 'class' => 'alert alert-danger fade in');
                $this->session->set_flashdata('item', $messge);
                redirect('Projects/Edit/' . $id);
            }
        } else {
            $messge = array('message' => 'Nu s-a detectat un raport de instalare. Devizul nu poate fi generat daca nu exista un raport de instalare.', 'class' => 'alert alert-danger fade in');
            $this->session->set_flashdata('item', $messge);
            redirect('Projects/Edit/' . $id);
        }

    }


    public function viewInternalInputEstimation($id)
    {
        $this->smarty_acl->authorized_action();
        $projectData = $this->Project->GetById($id);
        if ($projectData->ClientId != null && $projectData->WorkTypeId != null
            && $projectData->ProjectTypeId != null && $projectData->SiteManagerId != null
            && $projectData->Code != null && $projectData->ProjectManagerId != null) {

            $user = $this->smarty_acl->get_admin();

            $data                         = [];
            $inputEstimateData            = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId'], 1);
            $data['materialTypeData']     = array_filter($inputEstimateData, function ($item) {
                if ($item['estimate_type'] == 1) {
                    return true;
                }
                return false;
            });
            $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));
            $data['serviceTypeData']      = array_filter($inputEstimateData, function ($item) {
                if ($item['estimate_type'] == 2) {
                    return true;
                }
                return false;
            });
            $data['serviceTypeSubTotal']  = array_sum(array_column($data['serviceTypeData'], 'total'));
            $data['grandTotal']           = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];
            if ($this->input->post('submit') == 'submit') {
                $isExistFile = true;
                $fileId      = $this->Project->checkProjectFileExist($id, 1);

                if ($fileId === null) {
                    $isExistFile    = false;
                    $fileRecordData = ['project_id' => $id, 'is_internal_type' => 1];
                    $this->db->insert('project_input_estimate_file', $fileRecordData);
                    $fileId = $this->db->insert_id();
                }


                $qty        = $_POST['qty'];
                $mid        = $_POST['mid'];
                $rid        = $_POST['rid'];
                $price      = $_POST['price'];
                $newData    = [];
                $updateData = [];
                foreach ($rid as $key => $n) {
                    if ($n == '') {


                        $newData[] = [
                            'item_id'    => $mid[$key],
                            'quantity'   => $qty[$key],
                            'project_id' => $id,
                            'price'      => $price[$key],
                            'total'      => $qty[$key] * $price[$key],
                            'file_Id'    => $fileId
                        ];

                    } else {
                        if ($qty[$key] != '') {
                            $index = array_search($n, array_column($inputEstimateData, 'rid'));

                            if ($inputEstimateData[$index]['quantity'] != $qty[$key]) {
                                $updateData[] = ['id' => $n, 'quantity' => $qty[$key], 'total' => $qty[$key] * $price[$key]];
                            }
                        }
                    }
                }
                $isChange = false;
                if (count($newData) > 0) {
                    $this->db->insert_batch('project_input_estimate_file_data', $newData);
                    $isChange = true;
                }
                if (count($updateData) > 0) {
                    $this->db->update_batch('project_input_estimate_file_data', $updateData, 'id');
                    $isChange = true;
                }

                if ($isChange === true) {
                    $client            = $projectData->ClientId->Name;
                    $workType          = $projectData->WorkTypeId->Name;
                    $projectType       = $projectData->ProjectTypeId->Name;
                    $siteManager       = $projectData->SiteManagerId->Name;
                    $code              = $projectData->Code;
                    $projectManager    = $projectData->ProjectManagerId->Name;
                    $path              = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager;
                    $inputEstimateFile = str_replace('', '_', $projectData->Code . '_' . $projectData->Name . '_FO_deviz_NetTeam.xlsx');
                    $this->load->helper('custom_helper');
                    if (file_exists($path . '/' . $code)) {
                        if (file_exists($path . '/' . $code . '/' . $inputEstimateFile)) {
                            unlink($path . '/' . $code . '/' . $inputEstimateFile);
                        }
                    } else {
                        mkdir($path . '/' . $code, 0777, true);
                    }
                    $data                     = [];
                    $inputEstimateData        = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId'], 1);
                    $data['materialTypeData'] = array_filter($inputEstimateData, function ($item) {
                        if ($item['estimate_type'] == 1) {
                            return true;
                        }
                        return false;
                    });
                    $data['serviceTypeData']  = array_filter($inputEstimateData, function ($item) {
                        if ($item['estimate_type'] == 2) {
                            return true;
                        }
                        return false;
                    });

                    $data['serviceTypeSubTotal']  = array_sum(array_column($data['serviceTypeData'], 'total'));
                    $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));
                    $data['grandTotal']           = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];

                    $excelData = [['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']];
                    foreach ($data['materialTypeData'] as $key => $val) {
                        array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                    }
                    array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['materialTypeSubTotal']]);
                    array_push($excelData, []);

                    array_push($excelData, ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']);
                    foreach ($data['serviceTypeData'] as $key => $val) {
                        array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                    }
                    array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['serviceTypeSubTotal']]);
                    array_push($excelData, []);
                    array_push($excelData, ['', '', '', '', '', '<b>GrandTotal</b>', $data['grandTotal']]);

                    $xlsx = SimpleXLSXGen::fromArray($excelData);
                    $xlsx->setDefaultFont('Courier New');
                    $xlsx->saveAs($path . '/' . $code . '/' . $inputEstimateFile);
                    $messge = array('message' => 'Deviz intern creat cu succes!', 'class' => 'alert alert-success fade in');
                    $this->session->set_flashdata('internalItem', $messge);
                    if ($isExistFile === true) {
                        $updateFileRecordData = ['url' => $path . '/' . $code . '/' . $inputEstimateFile, 'update_at' => date('Y-m-d H:i:s')];
                        //add log starts
                        $log_data['message']     = '"' . $projectData->Name . '": Project Internal Input Estimation updated by ' . $user['UserName'];
                        $log_data['activity_id'] = $id;
                        $log_data['module']      = 'Project';
                        $log_data['user_id']     = $user['Id'];
                        $log_data['action']      = 'Update';
                        $this->activitylog->add_log($log_data);
                        //add log ends
                    } else {
                        $updateFileRecordData = ['url' => $path . '/' . $code . '/' . $inputEstimateFile, 'created_at' => date('Y-m-d H:i:s'), 'name' => $inputEstimateFile];

                        //add log starts
                        $log_data['message']     = '"' . $projectData->Name . '": Project Internal Input Estimation createds by ' . $user['UserName'];
                        $log_data['activity_id'] = $id;
                        $log_data['module']      = 'Project';
                        $log_data['user_id']     = $user['Id'];
                        $log_data['action']      = 'Insert';
                        $this->activitylog->add_log($log_data);
                        //add log ends
                    }
                    $this->db->where('id', $fileId);
                    $this->db->update('project_input_estimate_file', $updateFileRecordData);
                    $this->Project->UpdateStatus($id, 8);

                } else {
                    $messge = array('message' => 'Deviz intern creat cu succes!', 'class' => 'alert alert-success fade in');
                    $this->Project->UpdateStatus($id, 8);
                    $this->session->set_flashdata('internalItem', $messge);
                }
                redirect('Projects/Edit/' . $id);

            } else {
                $this->template->set('title', 'NTT | Deviz intern');
                $this->template->load('TemplateView', 'projects/InputEstimation', $data);
            }

        } else {
            $messge = array('message' => 'Lipsesc date pentru a crea structura folderelor.Asigurate ca lucrarea este alocata de catre contractor la echipa sa de teren.', 'class' => 'alert alert-danger fade in');
            $this->session->set_flashdata('internalItem', $messge);
            redirect('Projects/Edit/' . $id);
        }
    }

    public function getStatusWiseProjects()
    {

        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);

        $this->db->select('p.Id, p.Code, p.Name, p.DistrictId, p.ProjectManagerId, p.SiteManagerId, p.StatusId, p.StartDate, s.Name as status, p.DueDate, d.Name as distictName');
        $this->db->from('project as p');
        $this->db->join('status as s', 'p.StatusId = s.Id');
        $this->db->join('district as d', 'd.Id = p.DistrictId');
        $this->db->where('p.StatusId', $request->statusId);
        $data['projects'] = $this->db->get()->result_array();

        $html = "";
        if (!empty($data['projects'])) {
            foreach ($data['projects'] as $row) {
                $html .= "<tr>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Name'] . "</td>";
                if (!empty($row['distictName'])) {
                    $html .= "<td>" . $row['distictName'] . "</td>";
                } else {
                    $html .= "<td>Indisponibil</td>";
                }
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "<td>" . $row['Code'] . "</td>";
                $html .= "</tr>";
            }
        }
        $data['html'] = $html;
//        echo $this->db->last_query();
//        die;
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function updateBulkStatus()
    {
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);
        $data     = array("success" => false, "message" => "Project Status is not updated.");
        if (!empty($request->status) && !empty($request->projects)) {
            foreach ($request->projects as $project) {
                $this->db->select('StatusId,Name');
                $this->db->from('project');
                $this->db->where('Id', $project);
                $oldStatus = $this->db->get()->result_array();

                $this->db->where('Id', $project);
                $this->db->update('project', ['StatusId' => $request->status, 'oldStatusId' => $oldStatus[0]['StatusId']]);

                //add log starts
                $user                    = $this->smarty_acl->get_admin();
                $log_data['message']     = '"' . $oldStatus[0]['Name'] . '": Project status updated by ' . $user['UserName'];
                $log_data['activity_id'] = $project;
                $log_data['module']      = 'Project';
                $log_data['user_id']     = $user['Id'];
                $log_data['action']      = 'update';
                $this->activitylog->add_log($log_data);
                //add log ends
            }
            $data = array("success" => true, "message" => "Project Status Updated successfully.");
        }
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function exportProjects()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if ($this->input->post('ids')) {
                $ids = $this->input->post('ids');
                if (is_array($ids) && count($ids) > 0) {
                    $projectData = $this->Project->getExportProjectList($ids);
                    $excelData   = [['<b>RID</b>', '<b>Nume</b>', '<b>Judet</b>', '<b>Contractor</b>', '<b>PM Contractor</b>', '<b>Echipa de teren</b>', '<b>Proiect</b>', '<b>Status</b>', '<b>Data Start</b>', '<b>Data Finalizare</b>']];
                    if (count($projectData) > 0) {
                        foreach ($projectData as $value) {
                            $currentStatus = $clientName = $siteManagerName = $projectManagerName = $companyName = $districtName = 'Indisponibil';
                            if ($value['distName']) {
                                $districtName = $value['distName'];
                            }
                            if ($value['companyName']) {
                                $companyName = $value['companyName'];
                            }
                            if ($value['projectManagerName']) {
                                $projectManagerName = $value['projectManagerName'];
                            }
                            if ($value['siteManagerName']) {
                                $siteManagerName = $value['siteManagerName'];
                            }
                            if ($value['clientName']) {
                                $clientName = $value['clientName'];
                            }
                            if ($value['currentStatus']) {
                                $currentStatus = $value['currentStatus'];
                            }

                            array_push($excelData, [$value['Code'], $value['projectName'], $districtName, $companyName, $projectManagerName, $siteManagerName, $clientName, $currentStatus, $value['StartDate'], $value['DueDate']]);
                        }
                        $xlsx = SimpleXLSXGen::fromArray($excelData);
                        $xlsx->setDefaultFont('Courier New');
                        $xlsx->downloadAs('projectList.xlsx');

                        //add log starts
                        $user                    = $this->smarty_acl->get_admin();
                        $log_data['message']     = 'Projects exported by ' . $user['UserName'];
                        $log_data['activity_id'] = null;
                        $log_data['module']      = 'Project';
                        $log_data['user_id']     = $user['Id'];
                        $log_data['action']      = 'Export';
                        $this->activitylog->add_log($log_data);
                    }
                }
            }
        }
    }

    public function getProjectAdditionalInfo()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $postdata       = file_get_contents("php://input");
            $request        = json_decode($postdata);
            $id             = $request->id;
            $data           = [];
            $estimationData = [];
            $commentData    = [];
            $query          = $this->db->where('project_id', $id)->get('project_input_estimate_file');
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $key => $row) {
                    $estimationData[$key]['id']               = $row['id'];
                    $estimationData[$key]['name']             = $row['name'];
                    $estimationData[$key]['url']              = $row['url'];
                    $estimationData[$key]['created_at']       = $row['created_at'];
                    $estimationData[$key]['update_at']        = $row['update_at'];
                    $estimationData[$key]['is_internal_type'] = $row['is_internal_type'];

                }
            }
            $data['estimationData'] = $estimationData;

            $this->db->select('project_comment.id,comment,user_id,created_at,updated_at,userName');
            $this->db->from('project_comment');
            $this->db->join('user', 'project_comment.user_id = user.id');
            $this->db->where(['project_comment.project_id' => $id, 'project_comment.is_deleted' => 0]);
            $this->db->order_by('project_comment.id', 'DESC');
            $commentQuery = $this->db->get();

            if ($commentQuery->num_rows() > 0) {
                foreach ($commentQuery->result_array() as $key => $row) {
                    $commentData[$key]['id']         = $row['id'];
                    $commentData[$key]['comment']    = $row['comment'];
                    $commentData[$key]['created_at'] = $row['created_at'];
                    $commentData[$key]['updated_at'] = $row['updated_at'];
                    $commentData[$key]['userName']   = $row['userName'];
                    $commentData[$key]['user_id']    = $row['user_id'];

                }
            }
            $data['commentData'] = $commentData;

            $this->db->select('*');
            $this->db->from('project_installation_report_file');
            $this->db->where('project_id', $id);
            $this->db->limit(1);
            $data['installationReportData'] = $this->db->get()->result();

            $this->output->set_content_type('application/json')->set_output(json_encode($data));
        } else {
            redirect(site_url('Projects/View'));
        }
    }


}
