<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends CI_Controller
{
    private $JsModule = "ReportModule";

    function __construct()
    {
        parent::__construct();
        $this->template->set('jsmodule', $this->JsModule);
        $this->load->model('Project');
        $this->load->model('Projectmodel');
        $this->load->library('smarty_acl');
        $this->load->library('SimpleXLSXGen');
        $this->load->library('form_validation');
        $this->load->model('ProjectArea');
        $this->load->model('User');
        $this->load->model('Report_model');
        $this->load->library('activityLog');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

    public function View()
    {
        $this->session->unset_userdata('project_ids');
        $this->template->set('title', 'Lista lucrari');
        $this->db->select('Name, Id, RoleId');
        $this->db->from('user');
        $this->db->where('RoleId', 3);
        $data['contractorUserData'] = $this->db->get()->result_array();
        $this->db->select('Id,Name');
        $this->db->from('status');
        $data['statusData'] = $this->db->get()->result_array();
        $this->template->load('TemplateView', 'reports/Report', $data);

    }


    public function getData()
    {
        $search     = $_POST['search'];
        $start      = $_POST['start'];
        $length     = $_POST['length'];
        $order      = $_POST['order'];
        $pmUser     = $_POST['pmUser'];
        $statusId   = $_POST['status'];
        $isReset    = $_POST['isReset'];
        $projectIds = [];
        if ($isReset) {
            $this->session->unset_userdata('project_ids');
        } else {
            if ($this->session->has_userdata('project_ids')) {
                $projectIds = $this->session->userdata('project_ids');
            }
        }
        $data   = $this->Report_model->getData($search, $start, $length, $order, $projectIds, $pmUser, $statusId);
        $result = [
            'total'           => $data['recordsTotal'],
            'recordsTotal'    => $data['recordsTotal'],
            'recordsFiltered' => $data['recordsTotal'],
            'data'            => $data['data'],
        ];
        echo json_encode($result);
    }


    public function generateReport()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if ($this->session->has_userdata('project_ids')) {
                $companyId    = '';
                $reportType = $this->input->post('reportType');
                if ($reportType == 2) {
                    $pmUserData   = $this->User->getUserById($this->input->post('contractorPm'));
                    if ($pmUserData != null) {
                        $companyId = $pmUserData->CompanyId;
                    }
                }
                $projectIds               = $this->session->userdata('project_ids');
                $globalPriceListData      = $this->Report_model->getItemInfo($reportType, $companyId);
                $data['materialTypeData'] = array_filter($globalPriceListData, function ($item) {
                    if ($item['estimate_type'] == 1) {
                        return true;
                    }
                    return false;
                });
                $data['serviceTypeData']  = array_filter($globalPriceListData, function ($item) {
                    if ($item['estimate_type'] == 2) {
                        return true;
                    }
                    return false;
                });
                $fileData                 = $this->Report_model->getFileInfo($projectIds);
                $fileIds                  = [];
                $excelData                = [['', '', '', '']];
                $productHeaderData        = ['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>Price</b>'];
                $serviceHeaderData        = ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>Price</b>'];
                foreach ($fileData as $file) {
                    $fileIds[] = $file['id'];
                    $codes[]   = $file['Code'];
                    array_push($excelData[0], '<b>' . $file['Code'] . '</b>');
                    array_push($productHeaderData, '<b>Qty</b>');
                    array_push($serviceHeaderData, '<b>Qty</b>');
                }
                array_push($productHeaderData, '<b>Total</b>');
                array_push($serviceHeaderData, '<b>Total</b>');


                $qtyData     = $this->Report_model->getInternalEstimateQty($fileIds);
                $qtyFileData = [];
                foreach ($qtyData as $qtyDataKey => $qtyDataVal) {
                    $tempFileId                            = $qtyDataVal['file_id'];
                    $tempItemId                            = $qtyDataVal['item_id'];
                    $qtyFileData[$tempFileId][$tempItemId] = $qtyDataVal['quantity'];

                }

                array_push($excelData, $productHeaderData);

                $materialDataTotal = 0;
                foreach ($data['materialTypeData'] as $key => $val) {
                    $tempData     = [$val['sr_no'], $val['detail'], $val['unit'], $val['price']];
                    $tempTotalQty = 0;
                    foreach ($fileData as $file) {
                        $fileId = $file['id'];
                        $itemId = $val['id'];
                        $qty    = $qtyFileData[$fileId][$itemId];
                        array_push($tempData, $qty);
                        $tempTotalQty = $tempTotalQty + $qty;
                    }
                    $total             = $val['price'] * $tempTotalQty;
                    $materialDataTotal = $materialDataTotal + $total;
                    array_push($tempData, $total);
                    array_push($excelData, $tempData);
                }
                $productTotalRaw = array_fill(0, count($productHeaderData) - 2, '');
                array_push($productTotalRaw, '<b>SubTotal</b>', $materialDataTotal);
                array_push($excelData, $productTotalRaw);
                array_push($excelData, []);

                array_push($excelData, $serviceHeaderData);

                $serviceDataTotal = 0;
                foreach ($data['serviceTypeData'] as $key => $val) {
                    $tempData     = [$val['sr_no'], $val['detail'], $val['unit'], $val['price']];
                    $tempTotalQty = 0;
                    foreach ($fileData as $file) {
                        $fileId = $file['id'];
                        $itemId = $val['id'];
                        $qty    = $qtyFileData[$fileId][$itemId];
                        array_push($tempData, $qty);
                        $tempTotalQty = $tempTotalQty + $qty;
                    }
                    $total            = $val['price'] * $tempTotalQty;
                    $serviceDataTotal = $serviceDataTotal + $total;
                    array_push($tempData, $total);
                    array_push($excelData, $tempData);
                }
                $serviceTotalRaw = array_fill(0, count($serviceHeaderData) - 2, '');
                array_push($serviceTotalRaw, '<b>SubTotal</b>', $serviceDataTotal);
                array_push($excelData, $serviceTotalRaw);


                array_push($excelData, []);
                $grandTotalRaw = array_fill(0, count($serviceHeaderData) - 2, '');
                array_push($grandTotalRaw, '<b>GrandTotal</b>', $materialDataTotal + $serviceDataTotal);
                array_push($excelData, $grandTotalRaw);

                $xlsx = SimpleXLSXGen::fromArray($excelData);
                $xlsx->setDefaultFont('Courier New');
                $xlsx->downloadAs('EstiamteReport.xlsx');

                if ($reportType == 2) {
                    $closeProjectName = [];
                    foreach ($projectIds as $project) {
                        $this->db->select('StatusId,Name');
                        $this->db->from('project');
                        $this->db->where('Id', $project);
                        $oldStatus = $this->db->get()->result_array();
                        $this->db->where('Id', $project);
                        $this->db->update('project', ['StatusId' => 3, 'oldStatusId' => $oldStatus[0]['StatusId']]);
                        array_push($closeProjectName, $oldStatus[0]['Name']);
                    }
                    $closeProjectName = ["onr", "two"];
                    if (count($closeProjectName) > 0) {
                        $user                    = $this->smarty_acl->get_admin();
                        $log_data['message']     = '"' . implode(', ', $closeProjectName) . '"' . " Project status update to closed using report By " . $user['UserName'];
                        $log_data['activity_id'] = null;
                        $log_data['module']      = 'Reports';
                        $log_data['user_id']     = $user['Id'];
                        $log_data['action']      = 'Status update';
                        $this->activitylog->add_log($log_data);

                    }
                }
                $this->session->unset_userdata('project_ids');
                log_message("info", "end of dave");
            }
        } else {
            redirect(site_url('Projects/View'));
        }
    }

    public function setSessionId()
    {
        $flg = $_POST['flg'];
        $pid = $_POST['id'];
        if ($this->session->has_userdata('project_ids')) {
            if ($flg == 1) {
                $projectIds = $this->session->userdata('project_ids');
                array_push($projectIds, $pid);
                $newIds = array_unique($projectIds);
                $this->session->set_userdata('project_ids', $newIds);
            } else {
                $projectIds = $this->session->userdata('project_ids');
                $pos        = array_search($pid, $projectIds);
                if ($pos) {
                    unset($projectIds[$pos]);
                    $newIds = array_unique($projectIds);
                    $this->session->set_userdata('project_ids', $newIds);
                }

            }

        } else {
            if ($flg == 1) {
                $projectIds[] = $pid;
                $this->session->set_userdata('project_ids', $projectIds);
            }
        }
        $response          = new stdClass();
        $response->Success = true;
        $response->Message = "";
        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function checkSessionId()
    {
        $response = new stdClass();
        if ($this->session->has_userdata('project_ids')) {
            $response->Success = true;
        } else {
            $response->Success = false;
        }
        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }

}
