<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AProject extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('Project');
        $this->load->model('ProjectArea');
        $this->load->model('File');
        $this->load->library('smarty_acl');
        $this->load->library('SimpleXLSXGen');
        ini_set('memory_limit', '1024M');
    }

    public function GetAll()
    {
        log_message('info', 'AProject GetAll called');
        $data = $this->Project->GetAll();
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function GetById($Id)
    {
        log_message('info', 'AProject GetById called');
        $data = $this->Project->GetById($Id);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function Save()
    {
        log_message('info', 'AProject Save called');
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);

        $request->Id       = -1;
        $request->StatusId = 1;

        if ($request->SiteManagerId != null && $request->SiteManagerId > 0)
            $request->StatusId = 2;

        $insertedId = $this->Project->Create($request);

        foreach ($request->Template->Areas as $area) {
            $area->ProjectId = $insertedId;
            $this->ProjectArea->CreateArea($area);
        }
    }


    public function Pending()
    {
        log_message('info', 'AProject Pending called');
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);

        $request->StatusId = 4;


        $this->Project->UpdateProject($request);
    }

    public function Cancel()
    {
        log_message('info', 'AProject Cancel called');
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);

        $request->StatusId = 10;


        $this->Project->UpdateProject($request);
    }

    public function Update()
    {
        log_message('info', 'AProject Update called');
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);

//        $request->StatusId = 1;
//        if ($request->SiteManagerId != null && $request->SiteManagerId > 0)
//            $request->StatusId = 2;


        $this->Project->UpdateProject($request);
    }

    public function MobileUpdate()
    {
        log_message('info', 'AProject MobileUpdate called');
        $postdata          = file_get_contents("php://input");
        $response          = new stdClass();
        $response->Success = false;
        try {
            $request = json_decode($postdata);
            $path    = "Projects/" . $request->Client . "/" . $request->WorkType . "/" . $request->ProjectType . "/" . $request->ProjectManager . "/" . $request->SiteManager . "/" . $request->Code . "/Pictures/";
            $zipPath = "Projects/" . $request->Client . "/" . $request->WorkType . "/" . $request->ProjectType . "/" . $request->ProjectManager . "/" . $request->SiteManager . "/" . $request->Code;

            foreach ($request->Areas as $area) {
                $this->CreateFolderStructure($path, $area->Name);

                foreach ($area->Elements as $element) {

                    $element->File->Url = $path . "/" . $area->Name . "/" . $element->Name . '.png';
                    $file               = $this->File->GetByFilter("ProjectElementId", $element->File->ElementId);

                    if ($file == null)
                        $this->File->Create($element->File);
                    else
                        $this->File->UpdateByFilter($element->File, "ProjectElementId");

                    file_put_contents($element->File->Url, base64_decode($element->File->Data));
                    //AddWaterMark($element->File->Url);
                }
            }
            $this->CreateZip($zipPath, $request->Code);
            $this->Project->UpdateStatus($request->Id, 3);
            $response->Success = true;

            //$this->SendEmail($request->Code,)

        } catch (Exception $e) {
            $response->Success = true;
            $response->Message = $e->getMessage();
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    private function AddWaterMark($path)
    {
        // Load the stamp and the photo to apply the watermark to
        $im = imagecreatefromjpeg($path);

        // First we create our stamp image manually from GD
        $stamp = imagecreatefrompng('logo.png');

        $im = imagecreatefromjpeg($path);


        // Set the margins for the stamp and get the height/width of the stamp image
        $marge_right  = 10;
        $marge_bottom = 10;
        $sx           = imagesx($stamp);
        $sy           = imagesy($stamp);

        // Merge the stamp onto our photo with an opacity of 50%
        imagecopymerge($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp), 50);

        // Save the image to file and free memory
        imagejpeg($im, $path);
        imagedestroy($im);
    }

    private function CreateZip($path, $projectCode)
    {
        // Get real path for our folder
        $rootPath = realpath($path);

        // Initialize archive object
        $zip = new ZipArchive();
        $zip->open($path . "/" . $projectCode . '.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

        // Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file) {
            // Skip directories (they would be added automatically)
            if (!$file->isDir()) {
                // Get real and relative path for current file
                $filePath     = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }

        // Zip archive will be created only after closing object
        $zip->close();
    }


    private function CreateFolderStructure($path, $folder)
    {
        if (!file_exists($path . '/' . $folder)) {
            mkdir($path . '/' . $folder, 0777, true);
        }
    }

    public function GetProjectsByUserId()
    {
        log_message('info', 'AProject GetProjectsByUserId called');
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);

        $data = $this->Project->GetByFilterForJson('SiteManagerId', $request->UserId);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    private function SendEmail($siteName, $to)
    {
        // The message
        $message = "Buna ziua, \r\n Arhiva cu poze pentru site-ul " . $siteName . " a fost trimisa. \r\n Se poate descarca de aici";

        // In case any of our lines are larger than 70 characters, we should use wordwrap()
        $message = wordwrap($message, 70, "\r\n");

        // Send
        mail($to, 'Site-ul ' . $siteName . " a fost finalizat!", $message);
    }

    public function UploadXlsxFile()
    {
        $response = new stdClass();
        $data     = $this->Project->GetById($_POST['projectId']);

        if ($data->ClientId != null && $data->WorkTypeId != null && $data->ProjectTypeId != null && $data->SiteManagerId != null && $data->Code != null && $data->ProjectManagerId != null) {
            $client         = $data->ClientId->Name;
            $workType       = $data->WorkTypeId->Name;
            $projectType    = $data->ProjectTypeId->Name;
            $siteManager    = $data->SiteManagerId->Name;
            $code           = $data->Code;
            $projectManager = $data->ProjectManagerId->Name;
            $i              = 0;
            foreach ($data->Areas as $area) {
                if ($i == 0) {
                    $areaName = $area->Name;
                }
                $i++;
            }

            $path = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager . "/" . $code . "/Pictures/";
            $this->CreateFolderStructure($path, $areaName);
            $fullPath    = $path . $areaName . "/";
            $target_file = $fullPath . basename($_FILES["file"]["name"]);
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                $response->Success = true;
                $response->Message = "your file uploaded successfully.";
            } else {
                $response->Success = false;
                $response->Message = "Sorry, there was an error uploading your file.";
            }
        } else {
            $response->Success = false;
            $response->Message = "Sorry,Some data missing to create folder structure";
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function createBulkProject()
    {
        $response         = new stdClass();
        $data             = [];
        $distName         = [];
        $pmContractorName = [];
        $distData         = [];
        $pmData           = [];

        $fileName = $_FILES["file"]["tmp_name"];
        $row      = 0;
        try {
            if (($handle = fopen($fileName, "r")) !== FALSE) {
                while (($fileData = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $row++;
                    if ($row == 1) {
                        continue;
                    }
                    $tempData = [];
                    for ($c = 0; $c < 5; $c++) {
                        $val = '';
                        if (isset($fileData[$c])) {
                            $val = $fileData[$c];
                        }
                        array_push($tempData, trim($val));
                    }
                    if (count(array_filter($tempData)) > 0) {
                        if ($tempData[3] != '') {
                            array_push($distName, $tempData[3]);
                        }
                        if ($tempData[4] != '') {
                            array_push($pmContractorName, $tempData[4]);
                        }
                        $tempData = array_combine(['Code', 'Name', 'Address', 'DistrictId', 'ProjectManagerId'], $tempData);
                        array_push($data, $tempData);
                    }
                }
                fclose($handle);
            }
        } catch (Exception $e) {
            $response->Success = false;
            $response->Message = "Sorry, there was an error while reading your file.";
            goto End;

        }

        if (count($data) > 1000) {
            $response->Success = false;
            $response->Message = "Sorry, only 1000 record are allowed in bulk creation.";
            goto End;

        }

        $distName         = array_unique($distName);
        $pmContractorName = array_unique($pmContractorName);

        $distQuery = $this->db->where_in('Name', $distName)->get('district');
        if ($distQuery->num_rows() > 0) {
            foreach ($distQuery->result_array() as $key => $row) {
                $distData[$key]['id']   = $row['Id'];
                $distData[$key]['name'] = $row['Name'];
            }
        }
        $this->db->select('user.Id,user.UserName');
        $this->db->from('user');
        $this->db->join('roles', 'user.RoleId = roles.Id');
        $this->db->where('roles.Name', 'Contractor PM');
        $this->db->where_in('user.UserName', $pmContractorName);
        $pmContractorQuery = $this->db->get();
        if ($pmContractorQuery->num_rows() > 0) {
            foreach ($pmContractorQuery->result_array() as $key => $row) {
                $pmData[$key]['id']   = $row['Id'];
                $pmData[$key]['name'] = $row['UserName'];
            }
        }
        $newDistData  = [];
        $newDistCount = 0;
        foreach ($data as $dataKey => $dataVal) {
            $tempDistName = trim($dataVal['DistrictId']);
            if ($tempDistName != '') {
                if (
                    (array_search($tempDistName, array_column($distData, 'name')) === false) &&
                    (array_search($tempDistName, array_column($newDistData, 'name')) === false)
                ) {
                    $newDistData[$newDistCount]['name'] = $tempDistName;
                    $newDistCount++;
                }
            }
        }

        if (count($newDistData) > 0) {
            $distData = [];
            $this->db->insert_batch('district', $newDistData);
            $distQuery = $this->db->where_in('Name', $distName)->get('district');
            if ($distQuery->num_rows() > 0) {
                foreach ($distQuery->result_array() as $key => $row) {
                    $distData[$key]['id']   = $row['Id'];
                    $distData[$key]['name'] = $row['Name'];
                }
            }
        }
        $pmUserData = array_map('strtolower', array_column($pmData, 'name'));
        $startDt    = date('Y-m-d H:i:s');
        $dueDt      = date('Y-m-d H:i:s', strtotime("+2 week"));
        foreach ($data as $dataKey => $dataVal) {
            /* this field create problem in view so set them */
            $data[$dataKey]['WorkTypeId']    = 19;
            $data[$dataKey]['ProjectTypeId'] = 18;
            $data[$dataKey]['StatusId']      = 1;
            $data[$dataKey]['ClientId']      = 13;
            $data[$dataKey]['DueDate']       = $dueDt;
            $data[$dataKey]['StartDate']     = $startDt;
            $tempDistName                    = trim($dataVal['DistrictId']);
            if ($tempDistName != '') {
                $key = array_search($tempDistName, array_column($distData, 'name'));
                if ($key !== false) {
                    $data[$dataKey]['DistrictId'] = $distData[$key]['id'];
                } else {
                    $data[$dataKey]['DistrictId'] = null;
                }

            }

            if ($dataVal['ProjectManagerId'] != '') {
                $key = array_search(strtolower($dataVal['ProjectManagerId']), $pmUserData);
                if ($key !== false) {
                    $data[$dataKey]['ProjectManagerId'] = $pmData[$key]['id'];
                } else {
                    $data[$dataKey]['ProjectManagerId'] = null;
                }

            }
        }

        $projectElementData = [];
        try {
            if (count($data) > 0) {
                $defaultTemplateData = [];
                $areaQuery           = $this->db->select('Id,Name')->where('TemplateId', 347)->get('area');
                $areaData            = $areaQuery->result_array();

                foreach ($areaData as $areaKey => $areaVal) {
                    $defaultTemplateData[$areaKey]['id']          = $areaVal['Id'];
                    $defaultTemplateData[$areaKey]['name']        = $areaVal['Name'];
                    $elementQuery                                 = $this->db->select('Name')->where('AreaId', $areaVal['Id'])->get('element');
                    $defaultTemplateData[$areaKey]['elementData'] = $elementQuery->result_array();
                }

                $cnt = 0;
                foreach ($data as $dataKey => $dataVal) {
                    $this->db->insert('project', $dataVal);
                    $projectId = $this->db->insert_id();
                    foreach ($defaultTemplateData as $defaultTemplateKey => $defaultTemplateVal) {
                        $this->db->insert('projectarea', ['Name' => $defaultTemplateVal['name'], 'ProjectId' => $projectId]);
                        $projectAreaId = $this->db->insert_id();
                        foreach ($defaultTemplateVal['elementData'] as $elementKey => $elementVal) {
                            $projectElementData[$cnt]['ProjectAreaId'] = $projectAreaId;
                            $projectElementData[$cnt]['Name']          = $elementVal['Name'];
                            $cnt                                       = $cnt + 1;
                        }
                    }
                }
                if (count($projectElementData) > 0) {
                    $this->db->insert_batch('projectelement', $projectElementData);
                }
            }
            $response->Success = true;
            $response->Message = "Project created successfully.";
        } catch (Exception $e) {

            $response->Success = false;
            $response->Message = "Sorry, there was an error while inserting data.Try again.";
        }
        End:
        $this->output->set_content_type('application/json')->set_output(json_encode($response));

    }

    public function getInputEstimate($Id)
    {
        $data  = [];
        $query = $this->db->where('project_id', $Id)->get('project_input_estimate_file');
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $key => $row) {
                $data[$key]['id']               = $row['id'];
                $data[$key]['name']             = $row['name'];
                $data[$key]['url']              = $row['url'];
                $data[$key]['created_at']       = $row['created_at'];
                $data[$key]['update_at']        = $row['update_at'];
                $data[$key]['is_internal_type'] = $row['is_internal_type'];

            }
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function AutoCreateInternalInputEstimation()
    {
        $response    = new stdClass();
        $projectData = $this->Project->GetById($_POST['projectId']);
        $id          = $_POST['projectId'];
        if ($projectData->ClientId != null && $projectData->WorkTypeId != null
            && $projectData->ProjectTypeId != null && $projectData->SiteManagerId != null
            && $projectData->Code != null && $projectData->ProjectManagerId != null) {
            $projectFile = $this->db->select('*')->where(['project_id' => $_POST['projectId'], 'is_internal_type' => 0])->limit(1)->get('project_input_estimate_file')->row();
            if ($projectFile === null) {
                $response->Success = false;
                $response->Message = "Some problem while reading input estimate data";
            } else {
                $fileId = $projectFile->id;

                $inputEstimationQuery = $this->db->select('item_id,quantity')
                                                 ->where('file_id', $fileId)
                                                 ->get('project_input_estimate_file_data');

                $projectInternalFile = $this->db->select('*')->where(['project_id' => $_POST['projectId'], 'is_internal_type' => 1])->limit(1)->get('project_input_estimate_file')->row();

                $globalPriceListQuery = $this->db->get('global_item_price');
                if ($projectInternalFile === null) {
                    $fileRecordData = ['project_id' => $_POST['projectId'], 'is_internal_type' => 1, 'created_at' => date('Y-m-d H:i:s')];
                    $this->db->insert('project_input_estimate_file', $fileRecordData);
                    $internalFileId = $this->db->insert_id();

                    foreach ($globalPriceListQuery->result_array() as $row) {
                        $globalItem[$row['item_id']] = $row['price'];
                    }

                    foreach ($inputEstimationQuery->result_array() as $row) {
                        $itemId    = $row['item_id'];
                        $newData[] = ['item_id' => $itemId, 'quantity' => $row['quantity'], 'price' => $globalItem[$itemId], 'total' => $row['quantity'] * $globalItem[$itemId], 'project_id' => $_POST['projectId'], 'file_id' => $internalFileId];

                    }
                    $this->db->insert_batch('project_input_estimate_file_data', $newData);

                } else {
                    $internalFileId               = $projectInternalFile->id;
                    $internalInputEstimationQuery = $this->db->select('id,item_id')
                                                             ->where('file_id', $internalFileId)
                                                             ->get('project_input_estimate_file_data');

                    foreach ($internalInputEstimationQuery->result_array() as $row) {
                        $internalInputId[$row['item_id']] = $row['id'];
                    }
                    foreach ($globalPriceListQuery->result_array() as $row) {
                        $globalItem[$row['item_id']] = $row['price'];
                    }

                    foreach ($inputEstimationQuery->result_array() as $row) {
                        $itemId       = $row['item_id'];
                        $updateData[] = ['id' => $internalInputId[$itemId], 'quantity' => $row['quantity'], 'price' => $globalItem[$itemId], 'total' => $row['quantity'] * $globalItem[$itemId]];
                    }
                    $this->db->update_batch('project_input_estimate_file_data', $updateData, 'id');

                    $updateFileRecordData['update_at'] = date('Y-m-d H:i:s');

                }

                $client            = $projectData->ClientId->Name;
                $workType          = $projectData->WorkTypeId->Name;
                $projectType       = $projectData->ProjectTypeId->Name;
                $siteManager       = $projectData->SiteManagerId->Name;
                $code              = $projectData->Code;
                $projectManager    = $projectData->ProjectManagerId->Name;
                $path              = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager;
                $inputEstimateFile = str_replace('', '_', $projectData->Code . '_' . $projectData->Name . '_FO_deviz_internal.xlsx');
                $this->load->helper('custom_helper');
                if (file_exists($path . '/' . $code)) {
                    if (file_exists($path . '/' . $code . '/' . $inputEstimateFile)) {
                        unlink($path . '/' . $code . '/' . $inputEstimateFile);
                    }
                } else {
                    mkdir($path . '/' . $code, 0777, true);
                }
                $data                     = [];
                $inputEstimateData        = $this->Project->getProjectInputEstimateFileRecord($id, $this->smarty_acl->get_admin()['CompanyId'], 1);
                $data['materialTypeData'] = array_filter($inputEstimateData, function ($item) {
                    if ($item['estimate_type'] == 1) {
                        return true;
                    }
                    return false;
                });
                $data['serviceTypeData']  = array_filter($inputEstimateData, function ($item) {
                    if ($item['estimate_type'] == 2) {
                        return true;
                    }
                    return false;
                });

                $data['serviceTypeSubTotal']  = array_sum(array_column($data['serviceTypeData'], 'total'));
                $data['materialTypeSubTotal'] = array_sum(array_column($data['materialTypeData'], 'total'));
                $data['grandTotal']           = $data['serviceTypeSubTotal'] + $data['materialTypeSubTotal'];

                $excelData = [['<b>Sr No</b>', '<b>Product</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']];
                foreach ($data['materialTypeData'] as $key => $val) {
                    array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                }
                array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['materialTypeSubTotal']]);
                array_push($excelData, []);

                array_push($excelData, ['<b>Sr No</b>', '<b>Service</b>', '<b>Unit</b>', '<b>B2B</b>', '<b>Price</b>', '<b>Qty</b>', '<b>Total</b>']);
                foreach ($data['serviceTypeData'] as $key => $val) {
                    array_push($excelData, [$val['sr_no'], $val['detail'], $val['unit'], $val['b2b'], $val['price'], $val['quantity'], $val['total']]);
                }
                array_push($excelData, ['', '', '', '', '', '<b>SubTotal</b>', $data['serviceTypeSubTotal']]);
                array_push($excelData, []);
                array_push($excelData, ['', '', '', '', '', '<b>GrandTotal</b>', $data['grandTotal']]);

                $xlsx = SimpleXLSXGen::fromArray($excelData);
                $xlsx->setDefaultFont('Courier New');
                $xlsx->saveAs($path . '/' . $code . '/' . $inputEstimateFile);

                $updateFileRecordData['url']  = $path . '/' . $code . '/' . $inputEstimateFile;
                $updateFileRecordData['name'] = $inputEstimateFile;

                $this->db->where('id', $internalFileId);
                $this->db->update('project_input_estimate_file', $updateFileRecordData);

                $response->Success = true;
                $response->Message = "Auto estimation created successfully";

            }
        } else {
            $response->Success = true;
            $response->Message = "There are some data missing to create folder structure";

        }
        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function getProjectComment($Id)
    {
        $data = [];
        $this->db->select('project_comment.id,comment,user_id,created_at,updated_at,userName');
        $this->db->from('project_comment');
        $this->db->join('user', 'project_comment.user_id = user.id');
        $this->db->where(['project_comment.project_id' => $Id, 'project_comment.is_deleted' => 0]);
        $this->db->order_by('project_comment.id', 'DESC');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $key => $row) {
                $data[$key]['id']         = $row['id'];
                $data[$key]['comment']    = $row['comment'];
                $data[$key]['created_at'] = $row['created_at'];
                $data[$key]['updated_at'] = $row['updated_at'];
                $data[$key]['userName']   = $row['userName'];
                $data[$key]['user_id']    = $row['user_id'];

            }
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function saveComment()
    {
        $projectId = $_POST['projectId'];
        $id        = $_POST['id'];
        $comment   = $_POST['comment'];
        if ($id) {
            $updateData = ['comment' => $comment, 'updated_at' => date('Y-m-d H:i:s')];
            $this->db->where('id', $id);
            $this->db->update('project_comment', $updateData);
            $action = "updated";
        } else {
            $data = array(
                'project_id' => $projectId,
                'comment'    => $comment,
                'user_id'    => $this->smarty_acl->get_admin()['Id'],
                'created_at' => date('Y-m-d H:i:s')
            );
            $this->db->insert('project_comment', $data);
            $action = "added";
        }
        $response          = new stdClass();
        $response->Success = true;
        $response->Message = "Comment $action successfully.";
        $this->output->set_content_type('application/json')->set_output(json_encode($response));

    }

    public function deleteComment()
    {
        $response          = new stdClass();
        $response->Success = true;
        $response->Message = "Comment deleted successfully.";
        $id                = $_POST['id'];
        if ($id) {
            $updateData = ['is_deleted' => 1, 'updated_at' => date('Y-m-d H:i:s')];
            $this->db->where('id', $id);
            $this->db->update('project_comment', $updateData);
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));

    }

    public function updateTaskStatusPending()
    {
        log_message('info', 'AProject Pending called');
        $postdata = file_get_contents("php://input");
        $request  = json_decode($postdata);
        $id       = $request->id;
        $flg      = $request->flg; //1= pending request 0 = unfreeze
        $data     = $this->db->select('*')->from('project')->where(['Id' => $id])->get()->row();
        if ($flg == 1) {
            $status = $data->StatusId;
            if ($status != 4) {
                $this->Project->updateTaskStatusPending($id, $status, $flg);
            }
        } else {
            $status = $data->oldStatusId;
            $this->Project->updateTaskStatusPending($id, $status, $flg);
        }
        $response          = new stdClass();
        $response->Success = true;
        $response->Message = "Status changed successfully";

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

}


?>
