<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AProject extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('Project');
        $this->load->model('ProjectArea');
        $this->load->model('File');
        ini_set('memory_limit', '1024M');
        $this->load->library('smarty_acl');
    }

    public function GetAll()
    {
        log_message('info', 'AProject GetAll called');
        $data = $this->Project->GetAll();
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function GetById($Id)
    {
        log_message('info', 'AProject GetById called');
        $data = $this->Project->GetById($Id);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function Save()
    {
        log_message('info', 'AProject Save called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $request->Id = -1;
        $request->StatusId = 1;

        if ($request->SiteManagerId != null && $request->SiteManagerId > 0)
            $request->StatusId = 2;

        $insertedId = $this->Project->Create($request);

        foreach ($request->Template->Areas as $area) {
            $area->ProjectId = $insertedId;
            $this->ProjectArea->CreateArea($area);
        }
    }


    public function Pending()
    {
        log_message('info', 'AProject Pending called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $request->StatusId = 4;


        $this->Project->UpdateProject($request);
    }

    public function Cancel()
    {
        log_message('info', 'AProject Cancel called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $request->StatusId = 10;


        $this->Project->UpdateProject($request);
    }

    public function Update()
    {
        log_message('info', 'AProject Update called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $request->StatusId = 1;
        if ($request->SiteManagerId != null && $request->SiteManagerId > 0)
            $request->StatusId = 2;


        $this->Project->UpdateProject($request);
    }

    public function MobileUpdate()
    {
        log_message('info', 'AProject MobileUpdate called');
        $postdata = file_get_contents("php://input");
        $response = new stdClass();
        $response->Success = false;
        try {
            $request = json_decode($postdata);
            $path = "Projects/" . $request->Client . "/" . $request->WorkType . "/" . $request->ProjectType . "/" . $request->ProjectManager . "/" . $request->SiteManager . "/" . $request->Code . "/Pictures/";
            $zipPath = "Projects/" . $request->Client . "/" . $request->WorkType . "/" . $request->ProjectType . "/" . $request->ProjectManager . "/" . $request->SiteManager . "/" . $request->Code;

            foreach ($request->Areas as $area) {
                $this->CreateFolderStructure($path, $area->Name);

                foreach ($area->Elements as $element) {

                    $element->File->Url = $path . "/" . $area->Name . "/" . $element->Name . '.png';
                    $file = $this->File->GetByFilter("ProjectElementId", $element->File->ElementId);

                    if ($file == null)
                        $this->File->Create($element->File);
                    else
                        $this->File->UpdateByFilter($element->File, "ProjectElementId");

                    file_put_contents($element->File->Url, base64_decode($element->File->Data));
                    //AddWaterMark($element->File->Url);
                }
            }
            $this->CreateZip($zipPath, $request->Code);
            $this->Project->UpdateStatus($request->Id, 3);
            $response->Success = true;

            //$this->SendEmail($request->Code,)

        } catch (Exception $e) {
            $response->Success = true;
            $response->Message = $e->getMessage();
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    private function AddWaterMark($path)
    {
        // Load the stamp and the photo to apply the watermark to
        $im = imagecreatefromjpeg($path);

        // First we create our stamp image manually from GD
        $stamp = imagecreatefrompng('logo.png');

        $im = imagecreatefromjpeg($path);


        // Set the margins for the stamp and get the height/width of the stamp image
        $marge_right = 10;
        $marge_bottom = 10;
        $sx = imagesx($stamp);
        $sy = imagesy($stamp);

        // Merge the stamp onto our photo with an opacity of 50%
        imagecopymerge($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp), 50);

        // Save the image to file and free memory
        imagejpeg($im, $path);
        imagedestroy($im);
    }

    private function CreateZip($path, $projectCode)
    {
        // Get real path for our folder
        $rootPath = realpath($path);

        // Initialize archive object
        $zip = new ZipArchive();
        $zip->open($path . "/" . $projectCode . '.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

        // Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file) {
            // Skip directories (they would be added automatically)
            if (!$file->isDir()) {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }

        // Zip archive will be created only after closing object
        $zip->close();
    }


    private function CreateFolderStructure($path, $folder)
    {
        if (!file_exists($path . '/' . $folder)) {
            mkdir($path . '/' . $folder, 0777, true);
        }
    }

    public function GetProjectsByUserId()
    {
        log_message('info', 'AProject GetProjectsByUserId called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $data = $this->Project->GetByFilterForJson('SiteManagerId', $request->UserId);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    private function SendEmail($siteName, $to)
    {
        // The message
        $message = "Buna ziua, \r\n Arhiva cu poze pentru site-ul " . $siteName . " a fost trimisa. \r\n Se poate descarca de aici";

        // In case any of our lines are larger than 70 characters, we should use wordwrap()
        $message = wordwrap($message, 70, "\r\n");

        // Send
        mail($to, 'Site-ul ' . $siteName . " a fost finalizat!", $message);
    }

    public function UploadXlsxFile()
    {
        $response = new stdClass();
        $data = $this->Project->GetById($_POST['projectId']);

        if ($data->ClientId != null && $data->WorkTypeId != null && $data->ProjectTypeId != null && $data->SiteManagerId != null && $data->Code != null && $data->ProjectManagerId != null) {
            $client = $data->ClientId->Name;
            $workType = $data->WorkTypeId->Name;
            $projectType = $data->ProjectTypeId->Name;
            $siteManager = $data->SiteManagerId->Name;
            $code = $data->Code;
            $projectManager = $data->ProjectManagerId->Name;
            $i = 0;
            foreach ($data->Areas as $area) {
                if ($i == 0) {
                    $areaName = $area->Name;
                }
                $i++;
            }

            $path = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager . "/" . $code . "/Pictures/";
            $this->CreateFolderStructure($path, $areaName);
            $fullPath = $path . $areaName . "/";
            $target_file = $fullPath . basename($_FILES["file"]["name"]);
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                $response->Success = true;
                $response->Message = "your file uploaded successfully.";
            } else {
                $response->Success = false;
                $response->Message = "Sorry, there was an error uploading your file.";
            }
        } else {
            $response->Success = false;
            $response->Message = "Sorry,Some data missing to create folder structure";
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function createBulkProject()
    {
        $response = new stdClass();
        $data = [];
        $distName = [];
        $pmContractorName = [];
        $distData = [];
        $pmData = [];

        $fileName = $_FILES["file"]["tmp_name"];
        $row = 0;
        try {
            if (($handle = fopen($fileName, "r")) !== FALSE) {
                while (($fileData = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $row++;
                    if ($row == 1) {
                        continue;
                    }
                    $tempData = [];
                    for ($c = 0; $c < 6; $c++) {
                        $val = '';
                        if (isset($fileData[$c])) {
                            $val = $fileData[$c];
                        }
                        array_push($tempData, trim($val));
                    }
                    if (count(array_filter($tempData)) > 0) {
                        if ($tempData[3] != '') {
                            array_push($distName, $tempData[3]);
                        }
                        if ($tempData[5] != '') {
                            array_push($pmContractorName, $tempData[5]);
                        }
                        $tempData = array_combine(['Code', 'Name', 'Address', 'DistrictId', 'StartDate', 'ProjectManagerId'], $tempData);
                        array_push($data, $tempData);
                    }
                }
                fclose($handle);
            }
        } catch (Exception $e) {
            $response->Success = false;
            $response->Message = "Sorry, there was an error while reading your file.";
            goto End;

        }

        if (count($data) > 1000) {
            $response->Success = false;
            $response->Message = "Sorry, only 1000 record are allowed in bulk creation.";
            goto End;

        }

        $distName = array_unique($distName);
        $pmContractorName = array_unique($pmContractorName);

        $distQuery = $this->db->where_in('Name', $distName)->get('district');
        if ($distQuery->num_rows() > 0) {
            foreach ($distQuery->result_array() as $key => $row) {
                $distData[$key]['id'] = $row['Id'];
                $distData[$key]['name'] = $row['Name'];
            }
        }
        $this->db->select('user.Id,user.UserName');
        $this->db->from('user');
        $this->db->join('roles', 'user.RoleId = roles.Id');
        $this->db->where('roles.Name', 'Contractor PM');
        $this->db->where_in('user.UserName', $pmContractorName);
        $pmContractorQuery = $this->db->get();
        if ($pmContractorQuery->num_rows() > 0) {
            foreach ($pmContractorQuery->result_array() as $key => $row) {
                $pmData[$key]['id'] = $row['Id'];
                $pmData[$key]['name'] = $row['UserName'];
            }
        }
        $newDistData = [];
        $newDistCount = 0;
        foreach ($data as $dataKey => $dataVal) {
            $tempDistName = trim($dataVal['DistrictId']);
            if ($tempDistName != '') {
                if (
                    (array_search($tempDistName, array_column($distData, 'name')) === false) &&
                    (array_search($tempDistName, array_column($newDistData, 'name')) === false)
                ) {
                    $newDistData[$newDistCount]['name'] = $tempDistName;
                    $newDistCount++;
                }
            }
        }

        if (count($newDistData) > 0) {
            $distData = [];
            $this->db->insert_batch('district', $newDistData);
            $distQuery = $this->db->where_in('Name', $distName)->get('district');
            if ($distQuery->num_rows() > 0) {
                foreach ($distQuery->result_array() as $key => $row) {
                    $distData[$key]['id'] = $row['Id'];
                    $distData[$key]['name'] = $row['Name'];
                }
            }
        }

        foreach ($data as $dataKey => $dataVal) {
            /* this field create problem in view so set them */
            $data[$dataKey]['WorkTypeId'] = 19;
            $data[$dataKey]['ProjectTypeId'] = 18;
            $data[$dataKey]['StatusId'] = 1;
            $data[$dataKey]['ClientId'] = 13;
            $tempDistName = trim($dataVal['DistrictId']);
            if ($tempDistName != '') {
                $key = array_search($tempDistName, array_column($distData, 'name'));
                if ($key !== false) {
                    $data[$dataKey]['DistrictId'] = $distData[$key]['id'];
                } else {
                    $data[$dataKey]['DistrictId'] = null;
                }

            }

            if ($dataVal['ProjectManagerId'] != '') {
                $key = array_search($dataVal['ProjectManagerId'], array_column($pmData, 'name'));
                if ($key !== false) {
                    $data[$dataKey]['ProjectManagerId'] = $pmData[$key]['id'];
                } else {
                    $data[$dataKey]['ProjectManagerId'] = null;
                }

            }
        }

        $projectElementData = [];
        try {
            if (count($data) > 0) {
                $defaultTemplateData = [];
                $areaQuery = $this->db->select('Id,Name')->where('TemplateId', 347)->get('area');
                $areaData = $areaQuery->result_array();

                foreach ($areaData as $areaKey => $areaVal) {
                    $defaultTemplateData[$areaKey]['id'] = $areaVal['Id'];
                    $defaultTemplateData[$areaKey]['name'] = $areaVal['Name'];
                    $elementQuery = $this->db->select('Name')->where('AreaId', $areaVal['Id'])->get('element');
                    $defaultTemplateData[$areaKey]['elementData'] = $elementQuery->result_array();
                }

                $cnt = 0;
                foreach ($data as $dataKey => $dataVal) {
                    $this->db->insert('project', $dataVal);
                    $projectId = $this->db->insert_id();
                    foreach ($defaultTemplateData as $defaultTemplateKey => $defaultTemplateVal) {
                        $this->db->insert('projectarea', ['Name' => $defaultTemplateVal['name'], 'ProjectId' => $projectId]);
                        $projectAreaId = $this->db->insert_id();
                        foreach ($defaultTemplateVal['elementData'] as $elementKey => $elementVal) {
                            $projectElementData[$cnt]['ProjectAreaId'] = $projectAreaId;
                            $projectElementData[$cnt]['Name'] = $elementVal['Name'];
                            $cnt = $cnt + 1;
                        }
                    }
                }
                if (count($projectElementData) > 0) {
                    $this->db->insert_batch('projectelement', $projectElementData);
                }
            }
            $response->Success = true;
            $response->Message = "Project created successfully.";
        } catch (Exception $e) {

            $response->Success = false;
            $response->Message = "Sorry, there was an error while inserting data.Try again.";
        }
        End:
        $this->output->set_content_type('application/json')->set_output(json_encode($response));

    }

    public function getInputEstimate($Id)
    {
        $data =[];
        $query = $this->db->where('project_id', $Id)->get('project_input_estimate_file');
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $key => $row) {
                $data[$key]['id'] = $row['id'];
                $data[$key]['name'] = $row['name'];
                $data[$key]['url'] = $row['url'];
                $data[$key]['created_at'] = $row['created_at'];
                $data[$key]['update_at'] = $row['update_at'];
                $data[$key]['is_internal_type'] = $row['is_internal_type'];

            }
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

}

?>
