<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Created by PhpStorm.
 * User: ilogix
 * Date: 3/9/21
 * Time: 3:13 PM
 */

if ( ! function_exists('createZip'))
{
    function createZip($path , $projectCode)
    {
        //exit('CreateZip from helpers');
        log_message('info', 'ProjectService CreateZip called');
        // Get real path for our folder

        //old code
        //$rootPath = realpath($path."/Pictures");
        $rootPath = $path;

        // Initialize archive object
        $zip = new ZipArchive();
        $zip->open($path."/".$projectCode.'.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

        // Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file)
        {
            // Skip directories (they would be added automatically)
            if (!$file->isDir())
            {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }

        // Zip archive will be created only after closing object
        $zip->close();
    }
}

if ( ! function_exists('CreateFolderStructure'))
{
    function CreateFolderStructure($path, $folder)
    {
        if (!file_exists($path . '/' . $folder)) {
            mkdir($path . '/' . $folder, 0777, true);
        }
    }
}
