<?php
require_once(APPPATH.'models/DbModel.php');

Class Areadevize extends DbModel{

	public $Id;
	public $Name;
	public $DevizItems;

	function __construct(){
        parent::__construct();
		$this->load->model('DevizItem');
    }

	protected function GetTableName() {
        return "areadevize";
    }

    protected function GetObjectFromDbRow($row) {
		$entity = new Area();

		$entity->Id = $row->Id;
				$entity->DevizId = $row->DevizId;
		$entity->Name = $row->Name;
		$entity->DevizItems = $this->DevizItem->GetByFilter('AreaId',$entity->Id,false);

		return $entity;
    }

    protected function GetObjectFromDbRowForJson($row) {
		$entity = new Area();

		$entity->Id = $row->Id;
				$entity->DevizId = $row->DevizId;
		$entity->Name = $row->Name;
		$entity->DevizItems = $this->DevizItem->GetByFilterForJson('AreaId',$entity->Id);

		return $entity;
    }

    protected function GetDbData($entity) {
        $data = array(
			'Name' => $entity->Name,
						'DevizId' => $entity->DevizId
		);

		if($entity->Id != -1)
			$data['Id'] = $entity->Id;

		return $data;
    }

    public function CreateArea($area){
        $area->Id = -1;
        $insertedId = $this->Create($area);

				foreach ($area->DevizItems as $devizItem){
						$devizItem->Id = -1;
						$devizItem->AreaId = $insertedId;
						$this->$DevizItem->Create($devizItem);
				}
    }
}
?>
