<?php
abstract class DbModel extends CI_Model{
	
    function __construct(){
        parent::__construct(); 
    }

	abstract protected function GetTableName();
	
	public function GetById($Id){
        if($Id == -1)
            return null;
            
		$this->db->where('Id', $Id);
		$query = $this->db->get($this->GetTableName());
		return $this->GetObjectFromDbRow($query->row());
	}
	
	public function GetAll(){
		$query = $this->db->get($this->GetTableName());		
		$data = $query->result();
		$entityList = array();
		
		foreach($data as $row){
			$entityList[$row->Id] = $this->GetObjectFromDbRow($row);
		}
		return $entityList;
	}
	
	public function GetByFilter($filterKey , $filterValue, $useIdAsIndex = true){
		$query = $this->db->get_where($this->GetTableName(), array($filterKey => $filterValue));		
		$entityList = array();
		$data = $query->result();		
		
		foreach($data as $row){
            if($useIdAsIndex)
                $entityList[$row->Id] = $this->GetObjectFromDbRow($row);
            else
                array_push($entityList, $this->GetObjectFromDbRow($row));
		}
		return $entityList;
	}
    
    public function GetSingleEntityByFilter($filterKey , $filterValue){
		$this->db->where($filterKey, $filterValue);
		$query = $this->db->get($this->GetTableName());
        
        if($query->num_rows() <= 0)
            return null;
            
		return $this->GetObjectFromDbRow($query->row());
	}
    
    public function GetByFilterForJson($filterKey , $filterValue){
		$query = $this->db->get_where($this->GetTableName(), array($filterKey => $filterValue));		
		$entityList = array();
		$data = $query->result();		
		
		foreach($data as $row){
            array_push($entityList,$this->GetObjectFromDbRowForJson($row));
		}
		return $entityList;
	}
	
	public function Create($data){                   
		$data = $this->GetDbData($data);
		$this->db->insert($this->GetTableName(), $data);
        return $this->db->insert_id();
	}
	
	public function Update($data){
		$updateData = $this->GetDbData($data);	        
        $this->db->where('Id', $updateData['Id']);
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
	}
    
    public function UpdateByFilter($data,$key){
		$updateData = $this->GetDbData($data);	        
        $this->db->where($key, $updateData[$key]);
        
        $index = array_search('Id', $updateData);
        unset($updateData[$index]);
        
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
	}
	
	public function Delete($Id){
		$this->db->delete($this->GetTableName(), array('Id' => $Id));
	}
	
	abstract protected function GetObjectFromDbRow($row);
	abstract protected function GetDbData($entity);

    public function GetByMultiFilter($filter, $useIdAsIndex = true){
        $query = $this->db->get_where($this->GetTableName(), $filter);
        $entityList = array();
        $data = $query->result();

        foreach($data as $row){
            if($useIdAsIndex)
                $entityList[$row->Id] = $this->GetObjectFromDbRow($row);
            else
                array_push($entityList, $this->GetObjectFromDbRow($row));
        }

        return $entityList;
    }
}
?>