<?php
require_once(APPPATH.'models/DbModel.php');

Class Element extends DbModel{
	
	public $Id;	
	public $Name;
	public $NrOfPhotos;
	
	protected function GetTableName() {
        return "element";
    }
    
    protected function GetObjectFromDbRow($row) {
		$entity = new Element();
		
		$entity->Id = $row->Id;		
		$entity->Name = $row->Name;
        $entity->AreaId = $row->AreaId;
		$entity->NrOfPhotos = $row->NrOfPhotos;
        $entity->Selected = true;
		
		return $entity;
    }
    
    protected function GetDbData($entity) {
        $data = array(
        	'Name' => $entity->Name,
            'AreaId' => $entity->AreaId,
			'NrOfPhotos' => $entity->NrOfPhotos
		);
		
		if($entity->Id != -1)
			$data['Id'] = $entity->Id;
		
		return $data;
    }

}
?>