<?php
require_once(APPPATH.'models/BaseDatabaseModel.php');

Class EntitateModel extends BaseDatabaseModel{

	function __construct(){
        parent::__construct();
		$this->load->model('RolentitateModel');
    }

	protected function GetTableName() {
        return "entitate";
    }

    protected function GetObjectFromDbRow($row,$inluceRelatedData) {
        $entity = new stdClass();
		$entity->Id = $row->Id;
		$entity->Name = $row->Name;
		$entity->Adress = $row->Adress;
    $entity->County = $row->County;
		$entity->Role = $this->RolentitateModel->GetEntityById($row->RoleId);

		return $entity;
    }

    protected function GetDbData($entity) {

        $data = array(
			'Name' => $entity->Name,
			'Adress' => $entity->Adress,
      'County' => $entity->County,
			'RoleId' => $entity->Role->Id
		);

		if($entity->Id != -1)
			$data['Id'] = $entity->Id;

		return $data;
    }
}
?>
