<?php
require_once(APPPATH . 'models/DbModel.php');

Class Project extends DbModel
{

    public $Id;
    public $Code;
    public $Name;
    public $Address;
    public $DistrictRef;
    public $StartDate;
    public $EndDate;
    public $SiteAccess;
    public $ClientRef;
    public $WorkTypeRef;
    public $ProjectTypeRef;
    public $ProjectManagerRef;
    public $SiteManagerRef;
    public $ResponsableRef;
    public $CreatedOn;
    public $StatusRef;
    public $FolderPath;

    function __construct()
    {
        parent::__construct();
        $this->load->model('District');
        $this->load->model('Client');
        $this->load->model('User');
        //$this->load->model('Responsable');
        $this->load->model('Status');
        $this->load->model('Projectarea');
        $this->load->model('WorkType');
        $this->load->model('ProjectType');
    }

    protected function GetTableName()
    {
        return "project";
    }

    protected function GetObjectFromDbRow($row)
    {

        $entity              = new Project();
        $entity->Id          = $row->Id;
        $entity->Code        = $row->Code;
        $entity->Name        = $row->Name;
        $entity->Address     = $row->Address;
        $entity->DistrictRef = $this->District->GetById($row->DistrictId);
        $entity->StartDate   = $row->StartDate;
        $entity->EndDate     = $row->EndDate;
        $entity->SiteAccess  = $row->SiteAccess;
        $entity->DueDate     = $row->DueDate;
        $entity->ClientRef = $this->Client->GetById($row->ClientId);
        $entity->ClientId  = $this->Client->GetById($row->ClientId);

        $entity->WorkTypeRef = $this->WorkType->GetById($row->WorkTypeId);
        $entity->WorkTypeId  = $this->WorkType->GetById($row->WorkTypeId);

        $entity->ProjectTypeRef = $this->ProjectType->GetById($row->ProjectTypeId);
        $entity->ProjectTypeId  = $this->ProjectType->GetById($row->ProjectTypeId);
        if ($row->ProjectManagerId !== null) {
            $entity->ProjectManagerRef = $this->User->GetById($row->ProjectManagerId);
            $entity->ProjectManagerId  = $this->User->GetById($row->ProjectManagerId);
        } else {
            $entity->ProjectManagerRef = null;
            $entity->ProjectManagerId  = null;
        }

        if ($row->SiteManagerId != null) {
            $entity->SiteManagerRef = $this->User->GetById($row->SiteManagerId);
            $entity->SiteManagerId  = $this->User->GetById($row->SiteManagerId);
        } else {
            $entity->SiteManagerRef = null;
            $entity->SiteManagerId  = null;
        }


        $entity->EmailSent = $row->EmailStatusId == 1 ? true : false;

        //$entity->ResponsableRef = $this->Responsable->GetById($row->ResponsableId);
        //$entity->ResponsableId = $this->Responsable->GetById($row->ResponsableId);
        $entity->Responsable = $row->Responsable;

        $entity->CreatedOn = $row->CreatedOn;

        $entity->StatusRef = $this->Status->GetById($row->StatusId);
        $entity->StatusId  = $this->Status->GetById($row->StatusId);

        $entity->Areas = $this->ProjectArea->GetByFilter('ProjectId', $entity->Id);
        return $entity;
    }

    protected function GetObjectFromDbRowForJson($row)
    {

        $entity                 = new Project();
        $entity->Id             = $row->Id;
        $entity->Code           = $row->Code;
        $entity->Name           = $row->Name;
        $entity->Address        = $row->Address;
        $entity->District       = $this->District->GetById($row->DistrictId)->Name;
        $entity->StartDate      = $row->StartDate;
        $entity->EndDate        = $row->EndDate;
        $entity->SiteAccess     = $row->SiteAccess;
        $entity->Client         = $this->Client->GetById($row->ClientId)->Name;
        $entity->WorkType       = $this->WorkType->GetById($row->WorkTypeId)->Name;
        $entity->UserId         = $this->User->GetById($row->SiteManagerId)->Id;
        $entity->ProjectType    = $this->ProjectType->GetById($row->ProjectTypeId)->Name;
        $entity->ProjectManager = $this->User->GetById($row->ProjectManagerId)->Name;
        $entity->SiteManager    = $this->User->GetById($row->SiteManagerId)->Name;
        $entity->SiteManagerId  = $this->User->GetById($row->SiteManagerId)->Id;


        $entity->CreatedOn = $row->CreatedOn;
        $entity->StatusId  = $this->Status->GetById($row->StatusId)->Id;

        $entity->Areas = $this->ProjectArea->GetByFilterForJson('ProjectId', $entity->Id);
        return $entity;
    }

    protected function GetDbData($entity)
    {
        //$date = date('Y-m-d',strtotime($entity->StartDate));
        $data = array(
            'Name'             => $entity->Name,
            'Code'             => $entity->Code,
            'Name'             => $entity->Name,
            'Address'          => $entity->Address,
            'DistrictId'       => $entity->DistrictId,
            'StartDate'        => date('Y-m-d H:i:s'),
            'DueDate' => date('Y-m-d H:i:s', strtotime("+2 week")),
            //'StartDate' => $date,
            'SiteAccess'       => $entity->SiteAccess,
            'ClientId'         => $entity->ClientId,
            'WorkTypeId'       => $entity->WorkTypeId,
            'ProjectTypeId'    => $entity->ProjectTypeId,
            'ProjectManagerId' => $entity->ProjectManagerId,
            'SiteManagerId'    => $entity->SiteManagerId,
            'Responsable'      => $entity->Responsable,
            'StatusId'         => $entity->StatusId
        );

        if ($entity->Id != -1)
            $data['Id'] = $entity->Id;

        return $data;
    }

    public function UpdateProject($entity)
    {
        $updateData = array(
            'Id'               => $entity->Id,
            'ProjectManagerId' => $entity->ProjectManagerId,
            'SiteManagerId'    => $entity->SiteManagerId,
            'EndDate'          => date('Y-m-d H:i:s'),
            'StatusId'         => $entity->StatusId
        );
        $this->db->where('Id', $updateData['Id']);
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
    }

    public function UpdateStatus($projectId, $statusId)
    {
        $updateData = array(
            'Id'       => $projectId,
            'StatusId' => $statusId
        );
        $this->db->where('Id', $updateData['Id']);
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
    }

    public function UpdateEmailStatus($projectId)
    {
        $updateData = array(
            'Id'            => $projectId,
            'EmailStatusId' => 1
        );
        $this->db->where('Id', $updateData['Id']);
        $this->db->update($this->GetTableName(), $updateData);
        return $this->db->affected_rows();
    }

    private function GetProjectsByUser($userId)
    {
        $projectList = $this->Project->GetByFilter('ProjectId', $entity->Id);
    }

    public function AssignTask($postData)
    {
        $id            = $postData['Id'];
        $siteManagerId = $postData['SiteManagerId'];
        if ($siteManagerId != '') {
            $updateData = array(
                'Id'            => $id,
                'SiteManagerId' => $siteManagerId,
                'StatusId'      => 2
            );
            $this->db->where('Id', $id);
            $this->db->update($this->GetTableName(), $updateData);

            return $this->db->affected_rows();
        }

        return 1;
    }

//    public function getProjectInputEstimateFileRecord($projectId)
//    {
//
//        $this->db->select('piefd.quantity,pem.estimate_type,pem.id as mid,piefd.id as rid,pem.sr_no,pem.detail,pem.unit,pem.no_build,pem.b2b');
//        $this->db->from('project_estimate_master as pem');
//        $this->db->join('project_input_estimate_file_data as piefd', 'pem.id = piefd.pro_estimation_id AND piefd.project_id =' . $projectId . '', 'left');
//
//        return $this->db
//            ->get()
//            ->result_array();
//    }

    public function getProjectInputEstimateFileRecord($projectId, $companyId, $isInternalType)
    {

        $projectFile          = $this->db->select('*')->where(['project_id' => $projectId, 'is_internal_type' => $isInternalType])->limit(1)->get('project_input_estimate_file')->row();
        $data['fileRecordId'] = false;
        if ($projectFile != null) {
            $data['fileRecordId'] = $projectFile->id;
            if ($isInternalType == 0) {
                $this->db->select('piefd.quantity,im.estimate_type,im.id as mid,piefd.id as rid,im.sr_no,im.detail,im.unit,im.no_build,im.b2b,piefd.total,IF(piefd.id IS NOT NULL,piefd.price,cip.price) AS price', false);
                $this->db->from('item_master AS im');
                $this->db->join('company_item_price AS cip', 'im.id = cip.item_id AND cip.company_id =' . $companyId . '', 'left');
                $this->db->join('project_input_estimate_file_data AS piefd', 'im.id = piefd.item_id AND piefd.file_id =' . $projectFile->id . '', 'left');
                $this->db->order_by("im.sr_no", "asc");
            } else {
                $this->db->select('piefd.quantity,im.estimate_type,im.id as mid,piefd.id as rid,im.sr_no,im.detail,im.unit,im.no_build,im.b2b,piefd.total,IF(piefd.id IS NOT NULL,piefd.price,cip.price) AS price', false);
                $this->db->from('item_master AS im');
                $this->db->join('global_item_price AS cip', 'im.id = cip.item_id', 'left');
                $this->db->join('project_input_estimate_file_data AS piefd', 'im.id = piefd.item_id AND piefd.file_id =' . $projectFile->id . '', 'left');
                $this->db->order_by("im.sr_no", "asc");
            }


        } else {
            if ($isInternalType == 0) {
                $this->db->select('NULL as quantity,im.estimate_type,im.id as mid,NULL as rid,im.sr_no,im.detail,im.unit,im.no_build,im.b2b,NULL total,cip.price AS price', false);
                $this->db->from('item_master AS im');
                $this->db->join('company_item_price AS cip', 'im.id = cip.item_id AND cip.company_id =' . $companyId . '', 'left');
                $this->db->order_by("im.sr_no", "asc");
            } else {
                $this->db->select('NULL as quantity,im.estimate_type,im.id as mid,NULL as rid,im.sr_no,im.detail,im.unit,im.no_build,im.b2b,NULL total,cip.price AS price', false);
                $this->db->from('item_master AS im');
                $this->db->join('global_item_price AS cip', 'im.id = cip.item_id', 'left');
                $this->db->order_by("im.sr_no", "asc");
            }

        }
        return $this->db
            ->get()
            ->result_array();


    }

    public function checkProjectFileExist($projectId, $isInternalType)
    {
        $projectFile = $this->db->select('*')->where(['project_id' => $projectId, 'is_internal_type' => $isInternalType])->limit(1)->get('project_input_estimate_file')->row();
        if ($projectFile != null) {
            return $projectFile->id;
        }
        return null;

    }


}

?>
