<?php
require_once(APPPATH.'models/DbModel.php');

Class ProjectTemplate extends DbModel{
	
    function __construct(){
        parent::__construct();  
		$this->load->model('Area');
    }
    
	protected function GetTableName() {
        return "template";
    }
    
    protected function GetObjectFromDbRow($row) {    
		$entity = new Template();
		
		$entity->Id = $row->Id;
		$entity->Name = $row->Name;
		$entity->Description = $row->Description;
		$entity->Areas = $this->Area->GetByFilter('TemplateId',$entity->Id,false);
		
		return $entity;
    }
    
    protected function GetDbData($entity) {
        $data = array(
			'Name' => $entity->Name,
            'Description' => $entity->Description
		);
		
		if($entity->Id != -1)
			$data['Id'] = $entity->Id;
		
		return $data;
    }

}
?>