<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

Class Report_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    public function getData($search, $start, $limit, $sortOrder, $projectIds, $pmUser, $statusId)
    {
//        $search['value'] = 'dave';
        $orderType = $sortOrder[0]['dir'];

        switch ($sortOrder[0]['column']) {
            case 1:
                $sort = 'p.Code';
                break;
            case 2:
                $sort = 'p.Name';
                break;
            case 3:
                $sort = 'd.Name';
                break;
            case 4:
                $sort = 'u.Name';
                break;
            case 5:
                $sort = 'u2.Name';
                break;
            case 6:
                $sort = 'c.Name';
                break;
            case 7:
                $sort = 's.Name';
                break;
            case 8:
                $sort = 'p.StartDate';
                break;
            default:
                $sort      = 'p.Name';
                $orderType = 'DESC';
                break;
        }
        $getDataQuery = $this->db->select('p.Id,p.Name as pname,p.Code,d.Name as dname,u.Name as pmname,u2.Name as sitemname,c.Name as cname,s.Name as sname,s.id as sid,p.StartDate,pief.id as pief_id')->from('project as p')->join('district as d', 'p.DistrictId = d.Id', 'left')->join('user as u', 'p.ProjectManagerId = u.Id', 'left')->join('user as u2', 'p.SiteManagerId= u2.Id', 'left')->join('client as c', 'p.ClientId= c.Id', 'left')->join('status as s', 'p.StatusId= s.Id', 'left')->join('project_input_estimate_file as pief', 'p.Id= pief.project_id AND pief.is_internal_type =1', 'left')->order_by($sort, $orderType)->limit($limit, $start);
        $keyword      = null;
        if ($search['value']) {
            $keyword = $search['value'];
            $getDataQuery->where("p.Code LIKE '$keyword%'");
        }
        if ($pmUser != '' || strlen($pmUser) > 0) {
            $pmUser = (int)$pmUser;
            $getDataQuery->where("u.Id", $pmUser);
        }
        if ($statusId != '' || strlen($statusId) > 0) {
            $statusId = (int)$statusId;
            $getDataQuery->where("s.Id", $statusId);
        }
        $taskData = $getDataQuery
            ->get()
            ->result_array();

        log_message("info", "dave query:::" . $this->db->last_query());
        $resultData['data'] = [];
        foreach ($taskData as $task) {
            if ($task['sid'] == 4) {
                $status = '<span class="label label-warning">' . $task['sname'] . '</span>';
            } elseif ($task['sid'] == 10) {
                $status = '<span class="label label-danger">' . $task['sname'] . '</span>';
            } else {
                $status = '<span class="label label-success">' . $task['sname'] . '</span>';
            }
            $checked = '';
            if (in_array($task['Id'], $projectIds)) {
                $checked = 'checked';
            }
            $resultData['data'][] = ['<input ' . $checked . ' type=\'checkbox\' name=\'projects[]\' value="' . $task['Id'] . '" data-status-id="' . $task['sid'] . '" data-pief-id="' . $task['pief_id'] . '" >', $task['Code'], $task['pname'], $task['dname'], $task['pmname'], $task['sitemname'], $task['cname'], $status, $task['StartDate'], '<a href=' . base_url() . 'index.php/Projects/Edit/' . $task['Id'] . '><button type="button" class="btn btn-success">Detalii</button></a>',];
        }
        $resultData['recordsTotal'] = $this->getTotalCount($keyword, $pmUser, $statusId);

        return $resultData;

    }

    private function getTotalCount($keyword = null, $pmUser, $statusId)
    {
        $query = $this->db;
        if ($keyword != null) {
            $query->where("p.Code LIKE '$keyword%'");
        }
        if ($pmUser != '' || strlen($pmUser) > 0) {
            $query->where("u.Id", $pmUser);
        }
        if ($statusId != '' || strlen($statusId) > 0) {
            $query->where("s.Id", $statusId);
        }
        return $query->from('project as p')->join('district as d', 'p.DistrictId = d.Id', 'left')->join('user as u', 'p.ProjectManagerId = u.Id', 'left')->join('user as u2', 'p.SiteManagerId= u2.Id', 'left')->join('client as c', 'p.ClientId= c.Id', 'left')->join('status as s', 'p.StatusId= s.Id', 'left')->join('project_input_estimate_file as pief', 'p.Id= pief.project_id AND pief.is_internal_type = 1', 'left')->count_all_results();
    }

    public function getItemInfo($reportType, $companyId)
    {
        $this->db->select('im.estimate_type,im.id,im.sr_no,im.detail,im.unit,im.no_build,im.b2b,gip.price');
        $this->db->from('item_master as im');
        if ($reportType == 1) {
            $this->db->join('global_item_price AS gip', 'im.id = gip.item_id', 'left');
        } else {
            $this->db->join('company_item_price AS gip', 'im.id = gip.item_id AND gip.company_id =' . $companyId . '', 'left');
        }

        return $this->db
            ->get()
            ->result_array();
    }

    public function getInternalEstimateQty($fileIds)
    {
        if ($fileIds) {
            $this->db->select('piefd.quantity,piefd.item_id,piefd.file_id');
            $this->db->where_in('piefd.file_id', $fileIds);
            $this->db->from('project_input_estimate_file_data as piefd');
            $this->db->order_by('piefd.item_id', "asc");

            return $this->db
                ->get()
                ->result_array();
        }

        return [];
    }

    public function getFileInfo($projectIds)
    {
        $this->db->select('pief.id,p.Code');
        $this->db->where('pief.is_internal_type', 1);
        $this->db->where_in('pief.project_id', $projectIds);
        $this->db->from('project_input_estimate_file as pief');
        $this->db->join('project AS p', 'pief.project_id =  p.Id');

        return $this->db
            ->get()
            ->result_array();
    }
}
