<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clients extends CI_Controller {

	function __construct(){
        parent::__construct();
        $this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('Client');
        $this->load->library('smarty_acl');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

	//CRUD
	public function View(){
		$data['clientList'] = $this->Client->GetAll();
		$this->template->set('title', 'Lista Clienti');
		$this->template->load('TemplateView','clients/ClientList',$data);
	}

	public function Create(){
		$data['errorMessage']='';

		$this->SetValidationData();

    	if($this->form_validation->run() == false){
    		if(validation_errors()) {
				$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | Client Create');
			$this->template->load('TemplateView','clients/ClientCreate',$data);

    	}
    	else{
    		$this->CreateRecord($this->input->post());
    		redirect('/Clients/View', 'refresh');
		}
	}


	public function Update($Id){

		if(!isset($Id))	{
			redirect('/Clients/View', 'refresh');
			return;
		}

		//set data for view
		$data['errorMessage']='';
		$data['client'] = $this->Client->GetById($Id);

		//enable validation
		$this->SetValidationData();

    	if($this->form_validation->run() == false){

    		if(validation_errors()){
    			$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | Client Create');
			$this->template->load('TemplateView','clients/ClientUpdate',$data);
    	}
    	else{
    		$this->UpdateRecord($this->input->post());
    		redirect('/Clients/View', 'refresh');
		}
	}

	public function Delete($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Clients/View', 'refresh');
			return;
		}

		$this->Client->Delete($Id);
		redirect('/Clients/View', 'refresh');
	}

	//Utils
	private function SetValidationData(){
		$this->form_validation->set_rules('Name','Name','required');
	}

	//Data access
	private function CreateRecord($postData){
		$user = new stdClass();
		$user->Id = -1;
		$user->Name = $postData['Name'];
		$this->Client->Create($user);
	}

	private function UpdateRecord($postData){
		$user = new stdClass();
		$user->Id = $postData['Id'];
		$user->Name = $postData['Name'];
		$this->Client->Update($user);
	}

	//error tags
	private function GetErrorMessageTag($message){
		return
		'<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">�</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			'.$message.'
		</div>';
	}
    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            redirect('Login', 'refresh');
        }
    }
}
?>
