<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Entitati extends CI_Controller {

	function __construct(){
        parent::__construct();
        $this->load->helper('form');
		$this->load->library('form_validation');

        $this->load->model('Entitate');
        $this->load->model('EntitateModel');

		$this->load->model('Rolentitate');
        $this->load->model('RolentitateModel');
    }

	//CRUD
	public function View(){
		$data['entitateList'] = $this->EntitateModel->GetEntityList(false,true);
		$this->template->set('title', 'Lista Entitati');
		$this->template->load('TemplateView','entitati/EntitateList',$data);
	}

	public function Create(){
		$data['errorMessage']='';
		$data['roleList'] = $this->Rolentitate->GetAll();

		$this->SetValidationData();

    	if($this->form_validation->run() == false){
    		if(validation_errors()) {
				$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | Entitate Create');
			$this->template->load('TemplateView','entitati/EntitateCreate',$data);

    	}
    	else{
    		$this->CreateEntitate($this->input->post());
    		redirect('/Entitati/View', 'refresh');
		}
	}


	public function Update($Id){

		if(!isset($Id))	{
			redirect('/Entitati/View', 'refresh');
			return;
		}

		//set data for view
		$data['errorMessage']='';
		$data['roleList'] = $this->Rolentitate->GetAll();
		$data['entitate'] = $this->Entitate->GetById($Id);

		//enable validation
		$this->SetValidationData();

    	if($this->form_validation->run() == false){

    		if(validation_errors()){
    			$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | Entitate Create');
			$this->template->load('TemplateView','entitati/EntitateUpdate',$data);
    	}
    	else{
    		$this->UpdateUser($this->input->post());
    		redirect('/Entitati/View', 'refresh');
		}
	}

	public function Delete($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Entitati/View', 'refresh');
			return;
		}

		$this->Entitate->Delete($Id);
		redirect('/Entitati/View', 'refresh');
	}

	//Utils
	private function SetValidationData(){
		$this->form_validation->set_rules('Name','Name','required');
    	$this->form_validation->set_rules('Telephone','Telephone','required');
		$this->form_validation->set_rules('County','County','required');

		//$this->form_validation->set_rules('UserName','UserName','required');
    	//$this->form_validation->set_rules('Password','Password','required');
    	$this->form_validation->set_rules('RoleId','RoleId','required');
	}

	//Data access
	private function CreateEntitate($postData){
		$user = new stdClass();
		$user->Id = -1;
		$user->Name = $postData['Name'];
		$user->Adress = $postData['Adress'];
        $user->County = $postData['County'];
		$user->Role =  $this->Rolentitate->GetById($postData['Role']);
		$this->Entitate->Create($user);
	}

	private function UpdateUser($postData){
		$user = new stdClass();
		$user->Id = $postData['Id'];
		$user->Name = $postData['Name'];
		$user->Adress = $postData['Adress'];
        $user->County = $postData['County'];
		$user->Role =  $this->Rolentitate->GetById($postData['Role']);
		$this->Entitate->Update($user);
	}

	//error tags
	private function GetErrorMessageTag($message){
		return
		'<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			'.$message.'
		</div>';
	}
}
