<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Projects extends CI_Controller {
    private $JsModule = "ProjectModule";

    function __construct(){
        parent::__construct();
        $this->template->set('jsmodule',$this->JsModule);
        $this->load->model('Project');
        $this->load->model('Projectmodel');
        $this->load->library('smarty_acl');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

    public function index(){

		redirect(site_url('Projects/View'));
	}

	public function View(){
        $userId = null;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $userId = $this->smarty_acl->get_admin()['Id'];
        }
        $data['projectList'] = $this->Projectmodel->trage($userId);
        $this->template->set('title', 'Lista Proiecte');
		$this->template->load('TemplateView','projects/ProjectList',$data);

    //     $this->template->set('title', 'Lista Proiecte');
		// $this->template->load('TemplateView', 'projects/ProjectList');
	}

	public function Create(){
        $this->smarty_acl->authorized_action();
        $this->template->set('title', 'Adauga Proiect');
		$this->template->load('TemplateView', 'projects/ProjectCreate');
	}

    public function Edit($Id){
        $isAuthorized = true;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $isAuthorized = false;
            $entityData = $this->Projectmodel->GetEntityById($Id);
            if ($entityData->ProjectManager != null && $entityData->ProjectManager->Id == $this->smarty_acl->get_admin()['Id']) {
                $isAuthorized = true;
            }
        }
        if ($isAuthorized) {
            $data['projectId'] = $Id;
            $this->template->set('title', 'Editeaza Proiect');
            $this->template->load('TemplateView', 'projects/ProjectEdit', $data);
        } else {
            return redirect('home/unauthorized');
        }
    }

    public function Delete($Id){
        $this->smarty_acl->authorized_action();

        //TODO: show error on failure
        if (!isset($Id)) {
            redirect('/Projects/View', 'refresh');
            return;
        }

        $this->Project->Delete($Id);
        redirect('/Projects/View', 'refresh');
	}
    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }

    public function AssignTask($id)
    {
        $this->smarty_acl->authorized_action();
        $data['errorMessage'] = '';
        $data['project'] = $this->Projectmodel->GetEntityById($id);
        $data['userList'] = $this->User->GetByFilter('RoleId', 4);

        if ($this->input->post('submit') == 'submit') {
                $this->Project->AssignTask($this->input->post());
                redirect('/Projects/View', 'refresh');
        } else {
            $this->template->set('title', 'NTT | Assign Task ');
            $this->template->load('TemplateView', 'projects/AssignTask', $data);
        }
    }

}
