<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Projects extends CI_Controller {
    private $JsModule = "ProjectModule";

    function __construct(){
        parent::__construct();
        $this->template->set('jsmodule',$this->JsModule);
        $this->load->model('Project');
        $this->load->model('Projectmodel');
        $this->load->library('smarty_acl');
        $this->load->library('form_validation');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

    public function index(){

		redirect(site_url('Projects/View'));
	}

	public function View(){
        $userId = null;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $userId = $this->smarty_acl->get_admin()['Id'];
        }
        $data['projectList'] = $this->Projectmodel->trage($userId);
        $this->template->set('title', 'Lista Proiecte');
		$this->template->load('TemplateView','projects/ProjectList',$data);

    //     $this->template->set('title', 'Lista Proiecte');
		// $this->template->load('TemplateView', 'projects/ProjectList');
	}

	public function Create(){
        $this->smarty_acl->authorized_action();
        $this->template->set('title', 'Adauga Proiect');
		$this->template->load('TemplateView', 'projects/ProjectCreate');
	}

    public function Edit($Id){
        $isAuthorized = true;
        if ($this->smarty_acl->get_admin()['group_name'] == 'Contractor PM') {
            $isAuthorized = false;
            $entityData = $this->Projectmodel->GetEntityById($Id);
            if ($entityData->ProjectManager != null && $entityData->ProjectManager->Id == $this->smarty_acl->get_admin()['Id']) {
                $isAuthorized = true;
            }
        }
        if ($isAuthorized) {
            $data['projectId'] = $Id;
            $this->template->set('title', 'Editeaza Proiect');
            $this->template->load('TemplateView', 'projects/ProjectEdit', $data);
        } else {
            return redirect('home/unauthorized');
        }
    }

    public function Delete($Id){
        $this->smarty_acl->authorized_action();

        //TODO: show error on failure
        if (!isset($Id)) {
            redirect('/Projects/View', 'refresh');
            return;
        }

        $this->Project->Delete($Id);
        redirect('/Projects/View', 'refresh');
	}
    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            return redirect('login', 'refresh');
        }
    }

    public function AssignTask($id)
    {
        $this->smarty_acl->authorized_action();
        $data['errorMessage'] = '';
        $data['project'] = $this->Projectmodel->GetEntityById($id);
        $data['userList'] = $this->User->getFieldContractor($this->smarty_acl->get_admin()['Id']);
        $this->form_validation->set_rules('SiteManagerId','Site manger','required');
        if($this->form_validation->run() == false){
            if(validation_errors()){
                $data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
            }
            $this->template->set('title', 'NTT | Assign Task ');
            $this->template->load('TemplateView', 'projects/AssignTask', $data);
        }
        else{
            $this->Project->AssignTask($this->input->post());
            redirect('/Projects/View', 'refresh');
        }
    }

    //error tags
    private function GetErrorMessageTag($message){
        return
            '<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">�</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			'.$message.'
		</div>';
    }

}
