<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Templates extends CI_Controller {
	
    private $JsModule = "TemplateModule";

	function __construct(){
        parent::__construct(); 
        $this->template->set('jsmodule',$this->JsModule);
		$this->load->model('ProjectTemplate');
        $this->load->model('Area');
        $this->load->library('smarty_acl');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }    
	
	public function View(){	
		$data['templateList'] = $this->ProjectTemplate->GetAll();
        $this->template->set('title', 'Lista Sabloane');
		$this->template->load('TemplateView','templates/TemplateList',$data);
	}
	
	public function Create(){
    $this->template->set('title', 'Adauga Sablon');
		$this->template->load('TemplateView','templates/TemplateCreate');
	}
    
    public function Edit($Id){
        $data['templateId'] = $Id;
        $this->template->set('title', 'Editeaza Sabloan');
		$this->template->load('TemplateView', 'templates/TemplateEdit',$data);
    }
	
	
	public function Duplicate($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Templates/View', 'refresh');
			return;
		}
		
        $data = $this->ProjectTemplate->GetById($Id);
        $data->Id = -1;
        $data->Name = "DUPLICAT_".$data->Name;
        $insertedId = $this->ProjectTemplate->Create($data);
        
        foreach ($data->Areas as $area){
            $area->TemplateId = $insertedId;
            $this->Area->CreateArea($area);
        }
		//$this->ProjectTemplate->Duplicate($Id);
		redirect('/Templates/View', 'refresh');		
	}

	public function Delete($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Templates/View', 'refresh');
			return;
		}
		
		$this->ProjectTemplate->Delete($Id);
		redirect('/Templates/View', 'refresh');		
	}
    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {
            redirect('Login', 'refresh');
        }
    }
}