<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TemplatesDevize extends CI_Controller {

    private $JsModule = "DevizeModule";

	function __construct(){
        parent::__construct();
        $this->template->set('jsmodule',$this->JsModule);
		    $this->load->model('ProjectTemplateDeviz');
        $this->load->model('Areadevize');
    }

	public function View(){
		$data['devizeList'] = $this->ProjectTemplateDeviz->GetAll();
        $this->template->set('title', 'Lista Devize');
		$this->template->load('TemplateView','devize/DevizeList',$data);
	}

	public function Create(){
    $this->template->set('title', 'Adauga Sablon Deviz');
		$this->template->load('TemplateView','devize/DevizeCreate');
	}

    public function Edit($Id){
        $data['templateId'] = $Id;
        $this->template->set('title', 'Editeaza Sablon Deviz');
		$this->template->load('TemplateView', 'devize/DevizeUpdate',$data);
    }


	public function Duplicate($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Templates/View', 'refresh');
			return;
		}

        $data = $this->ProjectTemplateDeviz->GetById($Id);
        $data->Id = -1;
        $data->Name = "DUPLICAT_".$data->Name;
        $insertedId = $this->ProjectTemplateDeviz->Create($data);

        foreach ($data->Areas as $area){
            $area->DevizId = $insertedId;
            $this->Area->CreateArea($area);
        }
		//$this->ProjectDevize->Duplicate($Id);
		redirect('/TemplatesDevize/View', 'refresh');
	}

	public function Delete($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/TemplatesDevize/View', 'refresh');
			return;
		}

		$this->ProjectTemplateDeviz->Delete($Id);
		redirect('/TemplatesDevize/View', 'refresh');
	}
}
