<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	function __construct(){
        parent::__construct();
        $this->load->helper('form');
		$this->load->library('form_validation');

        $this->load->model('User');
        $this->load->model('UserModel');

		$this->load->model('Role');
        $this->load->model('RoleModel');
        $this->load->library('smarty_acl');
        $this->logged_in();
        $this->smarty_acl->authorized();
    }

	//CRUD
	public function View(){
		$data['userList'] = $this->UserModel->GetEntityList(false,true);
		$this->template->set('title', 'Lista Utilizatori');
		$this->template->load('TemplateView','users/UserList',$data);
	}

	public function Create(){
		$data['errorMessage']='';
		$data['roleList'] = $this->Role->GetAll();
		$data['pmList'] = $this->User->GetByFilter('RoleId',3);

		$this->SetValidationData();

    	if($this->form_validation->run() == false){
    		if(validation_errors()) {
				$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | User Create');
			$this->template->load('TemplateView','users/UserCreate',$data);

    	}
    	else{
    		$this->CreateUser($this->input->post());
    		redirect('/Users/View', 'refresh');
		}
	}


	public function Update($Id){

		if(!isset($Id))	{
			redirect('/Users/View', 'refresh');
			return;
		}

		//set data for view
		$data['errorMessage']='';
		$data['roleList'] = $this->Role->GetAll();
		$data['user'] = $this->User->GetById($Id);
        $data['pmList'] = $this->User->GetByFilter('RoleId',3);

		//enable validation
		$this->SetValidationData();

    	if($this->form_validation->run() == false){

    		if(validation_errors()){
    			$data['errorMessage'] = $this->GetErrorMessageTag(validation_errors());
			}

	        $this->template->set('title', 'NTT | User Create');
			$this->template->load('TemplateView','users/UserUpdate',$data);
    	}
    	else{
    		$this->UpdateUser($this->input->post());
    		redirect('/Users/View', 'refresh');
		}
	}

	public function Delete($Id){
		//TODO: show error on failure
		if(!isset($Id))	{
			redirect('/Users/View', 'refresh');
			return;
		}

		$this->User->Delete($Id);
		redirect('/Users/View', 'refresh');
	}

	//Utils
	private function SetValidationData(){
		$this->form_validation->set_rules('Name','Name','required');
    	$this->form_validation->set_rules('Telephone','Telephone','required');
		$this->form_validation->set_rules('Email','Email','required');

		//$this->form_validation->set_rules('UserName','UserName','required');
    	//$this->form_validation->set_rules('Password','Password','required');
    	$this->form_validation->set_rules('RoleId','RoleId','required');
	}

	//Data access
	private function CreateUser($postData){
		$user = new stdClass();
		$user->Id = -1;
		$user->Name = $postData['Name'];
		$user->Telephone = $postData['Telephone'];
        $user->Email = $postData['Email'];
		$user->UserName = $postData['UserName'];
		$user->Password = $postData['Password'];
		$user->RoleRef =  $this->Role->GetById($postData['RoleId']);
        $user->BelongToRef =null;
        if ($postData['BelongToId'] != null && $postData['BelongToId'] != '' && $postData['BelongToId'] > 0) {

            $user->BelongToRef = $this->User->GetById($postData['BelongToId']);
        }
		$this->User->Create($user);
	}

	private function UpdateUser($postData){
		$user = new stdClass();
		$user->Id = $postData['Id'];
		$user->Name = $postData['Name'];
		$user->Telephone = $postData['Telephone'];
        $user->Email = $postData['Email'];
		$user->UserName = $postData['UserName'];
		$user->Password = $postData['Password'];
		$user->RoleRef = $this->Role->GetById($postData['RoleId']);
        $user->BelongToRef =null;
        if ($postData['BelongToId'] != null && $postData['BelongToId'] != '' && $postData['BelongToId'] > 0) {
            $user->BelongToRef = $this->User->GetById($postData['BelongToId']);
        }
		$this->User->Update($user);
	}

	//error tags
	private function GetErrorMessageTag($message){
		return
		'<div class="alert alert-danger alert-dismissable">
			<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
			<h4><i class="icon fa fa-ban"></i> Eroare la salvare!</h4>
			'.$message.'
		</div>';
	}
    protected function logged_in()
    {
        if (!$this->smarty_acl->logged_in()) {

            redirect('Login', 'refresh');
        }
    }
}
