<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class VerifyLogin extends CI_Controller {
	
    function __construct()
    {
        parent::__construct();
        $this->load->library('smarty_acl');
        $this->load->helper('security');
        $this->load->model('UserModel','',TRUE);
    }
 
    function index()
    {
        //This method will have the credentials validation
        $this->load->library('form_validation');

        $this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');

        if ($this->form_validation->run() === TRUE) {
            $login = $this->smarty_acl->login(
                $this->input->post('username', true),
                $this->input->post('password', true),
                false, true
            );

            if ($login) {
                $this->session->set_flashdata('success_msg', 'User logged in successfully!');
                redirect('Projects/View', 'refresh');
            }

            $this->session->set_flashdata('error_msg', $this->smarty_acl->errors());
            redirect('Login');
        }
        $this->load->view('LoginView');

    }
 
    function check_database($username, $password){  
        //query the database
        $result = $this->UserModel->login($username, $password);
        
        if($result != null)
        {
            $sess_array = array();            
            $sess_array = array(
                'Id' => $result->Id,
                'UserName' => $result->UserName
            );
            $this->session->set_userdata('logged_in', $sess_array);            
            return true;
        }
        else
        {
            $this->form_validation->set_message('check_database', 'Invalid username or password');
            return false;
        }
    }
}
?>