<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AProject extends CI_Controller {

	function __construct(){
        parent::__construct();
		$this->load->model('Project');
        $this->load->model('ProjectArea');
        $this->load->model('File');
        ini_set('memory_limit', '1024M');
    }

    public function GetAll(){
        $data = $this->Project->GetAll();
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function GetById($Id){
        $data = $this->Project->GetById($Id);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    public function Save(){
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $request->Id = -1;
        $request->StatusId = 1;

        if($request->SiteManagerId!= null && $request->SiteManagerId > 0)
            $request->StatusId = 2;

        $insertedId = $this->Project->Create($request);

        foreach ($request->Template->Areas as $area){
            $area->ProjectId = $insertedId;
            $this->ProjectArea->CreateArea($area);
        }
    }


		public function Pending(){
				$postdata = file_get_contents("php://input");
				$request = json_decode($postdata);

						$request->StatusId = 4;


				$this->Project->UpdateProject($request);
		}

		public function Cancel(){
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

            $request->StatusId = 10;


        $this->Project->UpdateProject($request);
    }

    public function Update(){
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $request->StatusId = 1;
        if($request->SiteManagerId!= null && $request->SiteManagerId > 0)
            $request->StatusId = 2;


        $this->Project->UpdateProject($request);
    }

    public function MobileUpdate(){
        log_message('info', 'MobileUpdate');
        $postdata = file_get_contents("php://input");
        $response = new stdClass();
        $response->Success = false;
        try {
            $request = json_decode($postdata);
            $path = "Projects/".$request->Client."/".$request->WorkType."/".$request->ProjectType."/".$request->ProjectManager."/".$request->SiteManager."/".$request->Code."/Pictures/";
            $zipPath = "Projects/".$request->Client."/".$request->WorkType."/".$request->ProjectType."/".$request->ProjectManager."/".$request->SiteManager."/".$request->Code;

            foreach($request->Areas as $area){
                $this->CreateFolderStructure($path,$area->Name);

                foreach($area->Elements as $element){

                    $element->File->Url = $path."/".$area->Name."/".$element->Name.'.png';
                    $file = $this->File->GetByFilter("ProjectElementId",$element->File->ElementId);

                    if($file== null)
                        $this->File->Create($element->File);
                    else
                        $this->File->UpdateByFilter($element->File,"ProjectElementId");

                    file_put_contents($element->File->Url, base64_decode($element->File->Data));
                    //AddWaterMark($element->File->Url);
                }
            }
            $this->CreateZip($zipPath,$request->Code);
            $this->Project->UpdateStatus($request->Id,3);
            $response->Success = true;

            //$this->SendEmail($request->Code,)

        } catch (Exception $e) {
            $response->Success = true;
            $response->Message = $e->getMessage();
        }

       $this->output->set_content_type('application/json')->set_output(json_encode($response));
   }

   private function AddWaterMark($path){
        // Load the stamp and the photo to apply the watermark to
        $im = imagecreatefromjpeg($path);

        // First we create our stamp image manually from GD
        $stamp = imagecreatefrompng('logo.png');

        $im = imagecreatefromjpeg($path);


        // Set the margins for the stamp and get the height/width of the stamp image
        $marge_right = 10;
        $marge_bottom = 10;
        $sx = imagesx($stamp);
        $sy = imagesy($stamp);

        // Merge the stamp onto our photo with an opacity of 50%
        imagecopymerge($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp), 50);

        // Save the image to file and free memory
        imagejpeg($im, $path);
        imagedestroy($im);
       }

    private function CreateZip($path , $projectCode){
        // Get real path for our folder
        $rootPath = realpath($path);

        // Initialize archive object
        $zip = new ZipArchive();
        $zip->open($path."/".$projectCode.'.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

        // Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file)
        {
            // Skip directories (they would be added automatically)
            if (!$file->isDir())
            {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }

        // Zip archive will be created only after closing object
        $zip->close();
    }


    private function CreateFolderStructure($path , $folder){
        if (!file_exists($path.'/'.$folder)) {
            mkdir($path.'/'.$folder, 0777, true);
        }
    }

    public function GetProjectsByUserId(){
        log_message('info', 'GetProjectsByUserId called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);

        $data = $this->Project->GetByFilterForJson('SiteManagerId',$request->UserId);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }

    private function SendEmail($siteName , $to){
        // The message
        $message = "Buna ziua, \r\n Arhiva cu poze pentru site-ul ".$siteName." a fost trimisa. \r\n Se poate descarca de aici";

        // In case any of our lines are larger than 70 characters, we should use wordwrap()
        $message = wordwrap($message, 70, "\r\n");

        // Send
        mail($to, 'Site-ul '.$siteName." a fost finalizat!", $message);
    }

    public function UploadXlsxFile()
    {
        $response = new stdClass();
        $data = $this->Project->GetById($_POST['projectId']);

        if ($data->ClientId != null && $data->WorkTypeId != null && $data->ProjectTypeId != null && $data->SiteManagerId != null && $data->Code != null && $data->ProjectManagerId != null) {
            $client = $data->ClientId->Name;
            $workType = $data->WorkTypeId->Name;
            $projectType = $data->ProjectTypeId->Name;
            $siteManager = $data->SiteManagerId->Name;
            $code = $data->Code;
            $projectManager = $data->ProjectManagerId->Name;
            $i = 0;
            foreach ($data->Areas as $area) {
                if ($i == 0) {
                    $areaName = $area->Name;
                }
                $i++;
            }

            $path = "Projects/" . $client . "/" . $workType . "/" . $projectType . "/" . $projectManager . "/" . $siteManager . "/" . $code . "/Pictures/";
            $this->CreateFolderStructure($path, $areaName);
            $fullPath = $path . $areaName . "/";
            $target_file = $fullPath . basename($_FILES["file"]["name"]);
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                $response->Success = true;
                $response->Message = "your file uploaded successfully.";
            } else {
                $response->Success = false;
                $response->Message = "Sorry, there was an error uploading your file.";
            }
        } else {
            $response->Success = false;
            $response->Message = "Sorry,Some data missing to create folder structure";
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }
}
?>
