<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AUser extends CI_Controller {
	
	function __construct(){
        parent::__construct();
		$this->load->model('User');     
    } 
    
    public function GetProjectManagerList(){
        $data = $this->User->GetByFilter('RoleId',3);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }
    
    public function GetSiteManagerList(){
        $data = $this->User->GetByFilter('RoleId',4);
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }
    
    public function Login(){
        log_message('info', 'Login called');
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);	 
        
        $loginResult = new stdClass();
        $user = $this->User->Login($request->UserName,$request->Password);
        
        if($user!=null){
            $loginResult->Success = true;
            $loginResult->Id = $user->Id;
            $loginResult->UserName = $user->UserName;
            $loginResult->Password = $user->Password;
        }else{
            $loginResult->Success = false;
            $loginResult->Message = 'Login falied!';   
        }
            
        $this->output->set_content_type('application/json')->set_output(json_encode($loginResult));
    }

    public function checkContractorPmUserAndCountry()
    {
        $postdata = file_get_contents("php://input");
        $request = json_decode($postdata);
        $response = new stdClass();
        $response->Success = true;
        if (count($request->pmUser) > 0 || count($request->country) > 0) {
            $coPmUserResult = [];
            $countryResult = [];
            if (count($request->pmUser) > 0) {
                $requestPmUser = array_map('trim', $request->pmUser);
                $this->db->select('group_concat(user.name) as pm');
                $this->db->from('user');
                $this->db->join('roles', 'user.RoleId = roles.Id');
                $this->db->where('roles.Name', 'Contractor PM');
                $this->db->where_in('user.Name', $request->pmUser);
                $pmContractorQuery = $this->db->get();
                $data = $pmContractorQuery->result_array()[0];
                $dbPmUser = explode(',', $data['pm']);
                $coPmUserResult = array_udiff($requestPmUser, $dbPmUser, 'strcasecmp');
            }
            if (count($request->country) > 0) {
                $requestCountry = array_map('trim', $request->country);
                $this->db->select('group_concat(Name) as name');
                $this->db->from('district');
                $this->db->where_in('district.Name', $request->country);
                $countryQuery = $this->db->get();
                $data = $countryQuery->result_array()[0];
                $dbCountry = explode(',', $data['name']);
                $countryResult = array_udiff($requestCountry, $dbCountry, 'strcasecmp');
            }
            if (count($coPmUserResult) > 0 || count($countryResult) > 0) {
                $response->Success = false;
                $responseMessage = '';
                if (count($coPmUserResult) > 0) {
                    $responseMessage = 'The following contractor user not exist "' . implode($coPmUserResult, ',') . '".';
                }
                if (count($countryResult) > 0) {
                    $responseMessage = $responseMessage . ' The following country not exist "' . implode($countryResult, ',') . '".';
                }
                $response->Message = $responseMessage;
            }
        }

        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }
}
?>