<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ProjectService extends CI_Controller {

    function __construct(){
        parent::__construct();
        $this->load->model('Project');
        $this->load->model('ProjectArea');
        $this->load->model('File');
        $this->load->model('ProjectModel');
        $this->load->model('EventLogModel');
    }

    /*Mobile Upload*********************************************************************/
    public function SaveFile(){
        log_message('info', 'SaveFile called');
        $postdata = file_get_contents("php://input");
        $response = new stdClass();
        $response->Success = false;
        try {
            $request = json_decode($postdata);
            $path = "Projects/".$request->Client."/".$request->WorkType."/".$request->ProjectType."/".$request->ProjectManager."/".$request->SiteManager."/".$request->Code."/Pictures/";
            $this->CreateFolderStructure($path,$request->AreaName);

            $element = $request->Element;
            $element->File->Url = $path."/".str_replace('/', '_', $request->AreaName)."/".str_replace('/', '_', $element->Name).'.png';
            $file = $this->File->GetByFilter("ProjectElementId",$element->File->ElementId);

            if($file== null)
                $this->File->Create($element->File);
            else
                $this->File->UpdateByFilter($element->File,"ProjectElementId");

            file_put_contents($element->File->Url, base64_decode($element->File->Data));
            $response->Success = true;

        } catch (Exception $e) {
            $this->EventLogModel->LogError("SaveFile",$e->getMessage());
            $response->Success = false;
            $response->Message = $e->getMessage();
        }

       $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function SaveElement(){
        log_message('info', 'SaveElement called');
        $postdata = file_get_contents("php://input");
        $response = new stdClass();
        $response->Success = false;
        try {
            log_message('info', $postdata);
            $request = json_decode($postdata);
            $path = "Projects/".$request->Client."/".$request->WorkType."/".$request->ProjectType."/".$request->ProjectManager."/".$request->SiteManager."/".$request->Code."/Pictures/";
            $this->CreateFolderStructure($path,str_replace('/', '_', $request->AreaName));

            $file = $this->File->GetByFilter("ProjectElementId",$request->ElementId);
            $fileExists = true;

            if($file == null)
                $fileExists = false;

            $file = new stdClass();
            $file->Name = $request->ElementName;
            $file->Url = $path."/".str_replace('/', '_', $request->AreaName)."/".str_replace('/', '_', $request->ElementName).'.png';
            $file->Data = $request->FileData;
            $file->ElementId = $request->ElementId;
            $file->ProjectElementId = $request->ElementId;
            $request->FileData = null;


            if(!$fileExists)
                $this->File->Create($file);
             //else
                //$this->File->UpdateByFilter($file,"ProjectElementId");

            file_put_contents($file->Url, base64_decode($file->Data));
            $response->Success = true;

        } catch (Exception $e) {
            $this->EventLogModel->LogError("SaveFile",$e->getMessage());
            $response->Success = false;
            $response->Message = $e->getMessage();
        }

       $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    // public function cancelProject() {
    //   $postdata = file_get_contents("php://input");
    //   $response = new stdClass();
    //   $response->Success = false;
    //
    //   try {
    //       $request = json_decode($postdata);
    //       $this->Project->UpdateStatus($request->Id,10);
    //       $this->SendMailForProject($request->Id);
    //       $response->Success = true;
    //
    //   } catch (Exception $e) {
    //       $this->EventLogModel->LogError("SaveProject",$e->getMessage());
    //       $response->Success = false;
    //       $response->Message = $e->getMessage();
    //   }
    //
    //  $this->output->set_content_type('application/json')->set_output(json_encode($response));
    //
    // }

    public function SaveProject(){
        log_message('info', 'SaveProject called');
        $postdata = file_get_contents("php://input");
        $response = new stdClass();
        $response->Success = false;
        try {
            $request = json_decode($postdata);
            $zipPath = "Projects/".$request->Client."/".$request->WorkType."/".$request->ProjectType."/".$request->ProjectManager."/".$request->SiteManager."/".$request->Code;


            $this->CreateZip($zipPath,$request->Code);
            $this->Project->UpdateStatus($request->Id,3);
            $this->SendMailForProject($request->Id);
            $response->Success = true;

        } catch (Exception $e) {
            $this->EventLogModel->LogError("SaveProject",$e->getMessage());
            $response->Success = false;
            $response->Message = $e->getMessage();
        }

       $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    private function SendMailForProject($projectId){
        $project = $this->Project->GetById($projectId);

        if($project->EmailSent)
            return;



		$config = Array(
         'protocol' => 'ssmtp',
         'smtp_host' => 'ssl://mail.sinica.ro',
         'smtp_port' => 465,
         'smtp_user' => 'acceptante@sinica.ro',
         'smtp_pass' => 'forFuture2020',
         'mailtype'  => 'html',
          'charset'   => 'iso-8859-1'
        );

        $this->load->library('email', $config);
        $this->email->set_newline("\r\n");
        $this->email->from('acceptante@sinica.ro', 'NTT ACCEPTANCE');
        $this->email->to('office@sinica.ro');

        $this->email->subject('NTT ACCEPTANCE: Finalizare proiect: "'.$project->Code." ".$project->Name.'"!');

        $this->email->message('O noua acceptanta FO a fost uplodata in aplicatie. </br> Referinta lucrare:<b>'.$project->Code.' '.$project->Name.'<b> </br> Pentru a vizualiza proiectul apasati: <a href='.base_url().'index.php/Projects/Edit/'.$project->Id.'> Aici!</a> </br>');


        $result = $this->email->send();
        if($this->email->send()){
   //Success email Sent
   echo $this->email->print_debugger();
}else{
   //Email Failed To Send
   echo $this->email->print_debugger();
}
      /*  $headers = "From: acceptance@razashop.ro\r\n";
        $headers .= "Reply-To: acceptance@razashop.ro\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

        $subject = " ACCEPTANCE: Finalizare proiect: ".$project->Code." ".$project->Name."!";
        $body = "<b>Proiectul ".$project->Code." ".$project->Name." a fost finalizat! </br>";
        $body = $body.'Pentru a vizualiza proiectul apasati: <a href="'.base_url().'index.php/Projects/Edit/'.$project->Id.'"> Aici!</a> <b></br>';
        //$body = $body.'Pentru a descarca proiectul apasati aici <a href="'.base_url().'index.php/Projects/'.$project->ClientRef->Name."/".$project->WorkTypeRef->Name."/".$project->ProjectTypeRef->Name."/".$project->ProjectManagerRef->Name."/".$project->SiteManagerRef->Name."/".$project->Code.'">'.$project->Name.'</a>';

        $message = '<html><body>';
        $message .= $body;
        $message .= '</body></html>';

        // send email
        mail("office@razashop.ro",$subject,$message,$headers);
        //mail("bordeibogdan@gmail.com",$subject,$message,$headers); */
        $this->Project->UpdateEmailStatus($projectId);
    }

    private function CreateZip($path , $projectCode){
        // Get real path for our folder
        $rootPath = realpath($path."/Pictures");

        // Initialize archive object
        $zip = new ZipArchive();
        $zip->open($path."/".$projectCode.'.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

        // Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file)
        {
            // Skip directories (they would be added automatically)
            if (!$file->isDir())
            {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }

        // Zip archive will be created only after closing object
        $zip->close();
    }


    private function CreateFolderStructure($path , $folder){
        if (!file_exists($path.'/'.$folder)) {
            mkdir($path.'/'.$folder, 0777, true);
        }
    }

    /*END Mobile Upload*****************************************************************/

    /*START Web Service*****************************************************************/
    public function GetProjectList(){
        $data = $this->ProjectModel->GetProjectList();
        $this->output->set_content_type('application/json')->set_output(json_encode($data));
    }
    /*END Web Service*****************************************************************/


    public function TestMail($Id){
        echo 'Send mail for project: '.$Id;

        $this->SendMailForProject($Id);
        //$this->SendMailNotification();
    }

    public function SendMailNotification(){
       $to = 'rasvan.dumitru@sinica.ro';

        $subject = 'Website Change Reqest';

        $headers = "From: acceptante@sinica.ro\r\n";
        $headers .= "Reply-To: acceptante@sinica.ro\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";


        $message = '<html><body>';
        $message .= '<h1>Hello, World!</h1>';
        $message .= '</body></html>';


        mail($to, $subject, $message, $headers);
    }
}
?>
