<?php
require_once(APPPATH.'models/DbModel.php');

Class ProjectArea extends DbModel{
	
	public $Id;	
	public $Name;
	public $Elements;
	
	function __construct(){
        parent::__construct();  
		$this->load->model('ProjectElement');
    }
	
	protected function GetTableName() {
        return "projectarea";
    }
    
    protected function GetObjectFromDbRow($row) {
		$entity = new ProjectArea();
		
		$entity->Id = $row->Id;	
        $entity->ProjectId = $row->ProjectId;
		$entity->Name = $row->Name;
		$entity->Elements = $this->ProjectElement->GetByFilter('ProjectAreaId',$entity->Id);
        
		return $entity;
    }
    
    protected function GetObjectFromDbRowForJson($row) {
		$entity = new ProjectArea();
		
		$entity->Id = $row->Id;	
        $entity->ProjectId = $row->ProjectId;
		$entity->Name = $row->Name;
		$entity->Elements = $this->ProjectElement->GetByFilterForJson('ProjectAreaId',$entity->Id);
        
		return $entity;
    }
    
    protected function GetDbData($entity) {
        $data = array(
			'Name' => $entity->Name,
            'ProjectId' => $entity->ProjectId
		);
		
		if($entity->Id != -1)
			$data['Id'] = $entity->Id;
		
		return $data;
    }
    
    public function CreateArea($area){
        $area->Id = -1;
        $insertedId = $this->Create($area);
        
        foreach ($area->Elements as $element){
            if(!$element->Selected)
                continue;
                
            $element->Id = -1;
            $element->ProjectAreaId = $insertedId;
            $elName = $element->Name;
            for ($i = 1; $i <= $element->NrOfPhotos ; $i++) {
                $el = $element;              
                
                $el->Name = $elName." ".$i;
                $this->ProjectElement->Create($el);
            }
            //$this->ProjectElement->Create($element);
            
        }
    }
}
?>