<?php
require_once(APPPATH.'models/DbModel.php');

Class ProjectElement extends DbModel{
	
	public $Id;	
	public $Name;
	//public $File;    
    private $Filename;
	
    function __construct(){
        parent::__construct();  
		$this->load->model('File');
    }
    
	protected function GetTableName() {
        return "projectelement";
    }
    
    protected function GetObjectFromDbRow($row) {
		$entity = new ProjectElement();
		
		$entity->Id = $row->Id;		
		$entity->Name = $row->Name;
        $entity->ProjectAreaId = $row->ProjectAreaId;
        $entity->File = $this->File->GetSingleEntityByFilter('ProjectElementId',$entity->Id);
		
		return $entity;
    }
    
    protected function GetObjectFromDbRowForJson($row) {
		$entity = new ProjectElement();
		
		$entity->Id = $row->Id;		
		$entity->Name = $row->Name;
        $entity->ProjectAreaId = $row->ProjectAreaId;
        $entity->AreaId = $row->ProjectAreaId;
        //$entity->File = $this->File->GetSingleEntityByFilter('ProjectElementId',$entity->Id);
		
		return $entity;
    }
    
    protected function GetDbData($entity) {
        $data = array(
        	'Name' => $entity->Name,
            'ProjectAreaId' => $entity->ProjectAreaId
		);
		
		if($entity->Id != -1)
			$data['Id'] = $entity->Id;
		
		return $data;
    }
    
    public function Create($data){
		$data = $this->GetDbData($data);
		$this->db->insert($this->GetTableName(), $data);
        $insertedId = $this->db->insert_id(); 
	}

}
?>