<?php
require_once(APPPATH.'models/DbModel.php');

Class User extends DbModel{
	
	public $Id;
	
	public $Name;
	public $Telephone;
    public $Email;
	
	public $UserName;
	public $Password;
	
	public $RoleRef;
    public $BelongToRef;

	function __construct(){
        parent::__construct();  
		$this->load->model('Role');
    }
	
	protected function GetTableName() {
        return "user";
    }
    
    protected function GetObjectFromDbRow($row) {
		$entity = new User();
		
		$entity->Id = $row->Id;
		$entity->Name = $row->Name;
		$entity->Telephone = $row->Telephone;
        $entity->Email = $row->Email;
		$entity->UserName = $row->UserName;
		$entity->Password = $row->Password;
		$entity->RoleRef = $this->Role->GetById($row->RoleId);
        $entity->BelongToRef = null;
        if ($row->BelongToId != null && $row->BelongToId > 0) {
            $entity->BelongToRef = $this->getBelongToUser($row->BelongToId);
        }

		return $entity;
    }
    
    protected function GetDbData($entity) {
        $data = array(
            'Name' => $entity->Name,
            'Telephone' => $entity->Telephone,
            'Email' => $entity->Email,
            'UserName' => $entity->UserName,
            'Password' => $entity->Password,
            'RoleId' => $entity->RoleRef->Id,
            'BelongToId' => null
        );

        if ($entity->BelongToRef != null) {
            $data['BelongToId'] = $entity->BelongToRef->Id;
        }

        if ($entity->Id != -1)
            $data['Id'] = $entity->Id;

        return $data;
    }
    
    public function Login($userName , $password){
        $this->db->where('UserName', $userName);
        $this->db->where('Password', $password);
		$query = $this->db->get($this->GetTableName());
        $row = $query->row();
        
        if($row!=null)
		    return $this->GetObjectFromDbRow($row);  
        
        return null;
    }

    public function getBelongToUser($belongToId)
    {
        $this->db->where('Id', $belongToId);
        $query = $this->db->get($this->GetTableName());
        $row = $query->row();

        $entity = new User();
        $entity->Id = $row->Id;
        $entity->Name = $row->Name;
        $entity->Telephone = $row->Telephone;
        $entity->Email = $row->Email;
        $entity->UserName = $row->UserName;
        $entity->Password = $row->Password;
        $entity->RoleRef = $this->Role->GetById($row->RoleId);

        return $entity;
    }

    public function getFieldContractor($belongToUserId)
    {
        $query = $this->db->get_where($this->GetTableName(), $where = ['RoleId' => 4, 'BelongToId' => $belongToUserId]);
        $entityList = array();
        $data = $query->result();

        foreach ($data as $row) {
            $entityList[$row->Id] = $this->GetObjectFromDbRow($row);
        }

        return $entityList;
    }
}
?>