angular.module('myApp', []);
angular.module('myApp').controller("CsvCtrl", function ($scope, $q, $http) {
    $scope.disableSubmit = true;
    $scope.allKeyPresent = false;
    $scope.loading = false;
    //$scope.defaultHeader = ['Request ID', 'Company name', 'Contractor Installation', 'County', 'Oras'];
    $scope.defaultHeader = ['Request ID', 'Company name', 'County', 'City', 'Contractor Installation'];
    $scope.csvData = [];
    $scope.isValidCsv = true;
    $scope.tempCsvCount = 0;
    $scope.contractorPm = [];
    $scope.country = [];
    $scope.rids = [];
    $scope.fileNameChanged = function () {

        $scope.$apply(function () {
            $scope.disableSubmit = true;
        });

    }
    $scope.addBulkProject = function () {
        var filename = document.getElementById("bulkDirectFile").files[0];
        var delimeter = document.getElementById("delimeter").value;
        var formData = new FormData();
        formData.append("file", filename);
        formData.append("delimeter", delimeter);
        $scope.loading = true;
        $http({
            method: 'POST',
            url: '../api/AProject/createBulkProject',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false},
        }).success(function (data) {
            setTimeout(function(){ $scope.loading = false; }, 3000);

            alert(data.Message);
            location.reload();
        });
    }
    var clearAlerts = function () {
        $scope.error = {}, $scope.warning = null
    };

    $scope.download = function () {
        var a = document.createElement("a");
        var json_pre = '[{"Request ID":"123456","Company name":"Arsis Trading","County":"Calarasi","City":"Calarasi","Contractor Installation":"ntt"},{"Request ID":"123457","Company name":"Plantmed SRL","County":"Calarasi","City":"Oltenita","Contractor Installation":"ntt"}]'

        var csv = Papa.unparse(json_pre);

        if (window.navigator.msSaveOrOpenBlob) {
            var blob = new Blob([decodeURIComponent(encodeURI(csv))], {
                type: "text/csv;charset=utf-8;"
            });
            navigator.msSaveBlob(blob, 'sample.csv');
        } else {

            a.href = 'data:attachment/csv;charset=utf-8,' + encodeURI(csv);
            a.target = '_blank';
            a.download = 'sample.csv';
            document.body.appendChild(a);

            a.click();
        }
    }

    // Upload and read CSV function
    $scope.submitForm = function (form) {
        $scope.disableSubmit = false;
        clearAlerts();
        var filename = document.getElementById("bulkDirectFile");
        if (filename.value.length < 1) {
            ($scope.warning = "Please upload a file");
        } else {
            var file = filename.files[0];
            var fileSize = Math.round((filename.files[0].size / 1024));
            if (fileSize >= 4096) {
                ($scope.warning = "Fisierul este prea mare! Selecteaza un fisier mai mic de 4MB");
                $scope.isValidCsv = false;
                return false;
            }
            //papa parse
            const contractorPm = [];
            const country = [];

            function completefn(results) {
                if ($scope.isValidCsv) {
                    if ($scope.contractorPm.length > 0 || $scope.country.length > 0) {
                        $http({
                            method: 'POST',
                            url: '../api/AUser/checkContractorPmUserAndCountry',
                            headers: {'Content-Type': 'application/json'},
                            data: {'pmUser': $scope.contractorPm, 'country': $scope.country},
                            async: true

                        }).success(function (response) {
                            if (response.Success === false) {
                                //$scope.$apply(function () {
                                    $scope.isValidCsv = false;
                                    $scope.warning = response.Message;
                                    $scope.disableSubmit = true;
                                //});
                            }
                        });
                    }

                    if($scope.rids.length > 0){
                        $http({
                            method: 'POST',
                            url: '../api/AProject/checkDuplicateRids',
                            headers: {'Content-Type': 'application/json'},
                            data: {'rids':$scope.rids},
                            async: true

                        }).success(function (response) {
                            if (response.Success === false) {
                                    $scope.isValid = false;
                                    $scope.warning = response.Message;
                                    $scope.disableSubmit = true;
                            }
                        });
                    }

                    var table = '<table id="dataTable" class="table table-bordered table-striped" style="width: 100%;"><tbody>';
                    table += "<tr>";
                    for (var j = 0; j < $scope.defaultHeader.length; j++) {
                        table += "<td style='border: 1px solid black'>" + $scope.defaultHeader[j] + "</td>";
                    }
                    table += "</tr>";
                    for (var i = 0; i < $scope.csvData.length; i++) {
                        table += "<tr>";
                        for (var j = 0; j < $scope.defaultHeader.length; j++) {
                            table += "<td style='border: 1px solid black'>" + $scope.csvData[i][j] + "</td>";
                        }
                        table += "</tr>";
                    }
                    table += "</tbody></table>";
                    $("#dvCSV").append(table);
                }
            }

            function stepfn(results, parser) {
                $('#delimeter').val(results.meta.delimiter);
                if ($scope.allKeyPresent === false) { //Only chek if flag is not set, i.e, for the first time
                    parser.pause(); // pause the parser
                    var headerData = results.meta.fields;
                    if ((JSON.stringify($scope.defaultHeader) == JSON.stringify(headerData))) {
                        parser.resume();
                        $scope.$apply(function () {
                            $scope.disableSubmit = false;
                            $scope.allKeyPresent = true;
                            $scope.title = "Confirm file";

                        });

                        var tempData = [];
                        for (var i = 0; i < $scope.defaultHeader.length; i++) {
                            tempData.push(results.data[$scope.defaultHeader[i]]);
                            if (i == 4 && $scope.contractorPm.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1) {
                                $scope.contractorPm.push(results.data[$scope.defaultHeader[i]]);
                            }
                            if (i == 2 && $scope.country.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1) {
                                $scope.country.push(results.data[$scope.defaultHeader[i]]);
                            }
                            if (i == 0 && $scope.rids.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1) {
                                $scope.rids.push(results.data[$scope.defaultHeader[i]]);
                            }
                        }

                        $scope.csvData.push(tempData);
                    } else {
                        $scope.$apply(function () {
                            $scope.isValidCsv = false;
                            $scope.warning = 'Capetele de table nu par a fi corecte. Te rugam, sa reverifici capetele de tabel din fisier si sa te asiguri ca respecta forma si ordinea de mai sus';
                        });

                        parser.abort();
                    }
                } else {

                    var tempData = [];
                    for (var i = 0; i < $scope.defaultHeader.length; i++) {

                        tempData.push(results.data[$scope.defaultHeader[i]]);
                        /*if (i == 4 && $scope.contractorPm.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1) {
                            $scope.contractorPm.push(results.data[$scope.defaultHeader[i]]);
                        }*/
                        /*if (i == 2 && $scope.country.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1) {
                            $scope.country.push(results.data[$scope.defaultHeader[i]]);
                        }*/
                        /*if (i == 0 && $scope.rids.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1) {
                            $scope.rids.push(results.data[$scope.defaultHeader[i]]);
                        }*/
                        if (i == 4 && results.data[$scope.defaultHeader[i]] != "" && results.data[$scope.defaultHeader[i]] != undefined) {
                            if($scope.contractorPm.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1){
                                $scope.contractorPm.push(results.data[$scope.defaultHeader[i]]);
                            }
                        }

                        if (i == 2 && results.data[$scope.defaultHeader[i]] != "" && results.data[$scope.defaultHeader[i]] != undefined) {
                            if($scope.country.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1){
                                $scope.country.push(results.data[$scope.defaultHeader[i]]);
                            }
                        }
                        if (i == 0 && results.data[$scope.defaultHeader[i]] != "" && results.data[$scope.defaultHeader[i]] != undefined) {
                            if($scope.rids.indexOf(results.data[$scope.defaultHeader[i]].trim()) === -1){
                                $scope.rids.push(results.data[$scope.defaultHeader[i]]);
                            }
                        }
                    }

                    if ($scope.tempCsvCount <= 1000) {
                        $scope.csvData.push(tempData);
                    } else {

                        $scope.$apply(function () {
                            $scope.isValidCsv = false;
                            $scope.warning = 'Importul este permis in limita a 1000 de lucrari. Te rugam sa micsorezi numarul de lucrari din fisier';
                            $scope.title = '';
                        });
                        parser.abort();
                    }
                    $scope.tempCsvCount = $scope.tempCsvCount + 1;
                }

            }

            function transformHeaderFn(h) {
                return h.trim();
            }

            var config = {
                delimiter: "",	// auto-detect
                newline: "",	// auto-detect
                quoteChar: '"',
                escapeChar: '"',
                header: true,
                transformHeader: transformHeaderFn,
                dynamicTyping: false,
                preview: 0,
                encoding: "",
                worker: false,
                comments: false,
                step: stepfn,
                complete: completefn,
                error: undefined,
                download: false,
                downloadRequestHeaders: undefined,
                downloadRequestBody: undefined,
                skipEmptyLines: true,
                chunk: undefined,
                chunkSize: undefined,
                fastMode: undefined,
                beforeFirstChunk: undefined,
                withCredentials: undefined,
                transform: undefined,
                delimitersToGuess: [',', '\t', '|', ';', Papa.RECORD_SEP, Papa.UNIT_SEP]
            }
            Papa.parse(file, config);
            //
            // if (filename.files[0]) {
            //     var reader = new FileReader();
            //     reader.onload = function (e) {
            //
            //         //$("#dvCSV").html('');
            //         // var table = $("<table id='dataTable' class='table table-bordered table-striped' />").css('width', '100%');
            //         // var rows = e.target.result.split("\n");
            //         // if (rows != '' && rows.length >= 2) {
            //         // $scope.$apply(function () {
            //         //     $scope.title = "Confirm file";
            //         // });
            //         // if ('Request ID,Company name,Contractor Installation,County,Oras' === rows[0].trim()) {
            //         // const contractorPm = [];
            //         // const country = [];
            //         var dateReg = /^\d{4}-\d{2}-\d{2}$/;
            //         var isValid = true;
            //         var errorMsg = '';
            //         // if (rows.length > 1001) {
            //         //     isValid = false;
            //         //     errorMsg = "Importul este permis in limita a 1000 de lucrari. Te rugam sa micsorezi numarul de lucrari din fisier."
            //         // }
            //         /*for (var i = 0; i < rows.length; i++) {
            //             if (rows[i] != '') {
            //                 var cells = rows[i].split(",");
            //                 var row = $("<tr  />");
            //                 for (var j = 0; j < cells.length; j++) {
            //                     if (i > 0 && cells[j] != '') {
            //                         if (j == 2 && contractorPm.indexOf(cells[j].trim()) === -1) {
            //                             //contractorPm.push(cells[j].trim());
            //                         }
            //                         if (j == 3 && country.indexOf(cells[j].trim()) === -1) {
            //                             //country.push(cells[j].trim());
            //                         }
            //                     }
            //                     var cell = $("<td />").css('border', '1px solid black');
            //                     cell.html(cells[j]);
            //                     row.append(cell);
            //                 }
            //                 table.append(row);
            //             }
            //         }*/
            //         //$("#dvCSV").append(table);
            //
            //         if ($scope.isValidCsv === true) {
            //             console.log("get valid");
            //             console.log($scope.contractorPm);
            //             // if ($scope.contractorPm.length > 0 || country.length > 0) {
            //             //     $http({
            //             //         method: 'POST',
            //             //         url: '../api/AUser/checkContractorPmUserAndCountry',
            //             //         headers: {'Content-Type': 'application/json'},
            //             //         data: {'pmUser': contractorPm, 'country': country},
            //             //         async: true
            //             //
            //             //     }).success(function (response) {
            //             //         if (response.Success === false) {
            //             //             $scope.isValidCsv = false;
            //             //             errorMsg = response.Message;
            //             //         }
            //             //     });
            //             // }
            //         }
            //         setTimeout(() => {
            //             if ($scope.isValidCsv === false) {
            //                 $scope.$apply(function () {
            //                     clearAlerts();
            //                     $scope.warning = errorMsg;
            //                     $scope.disableSubmit = true;
            //
            //                 });
            //             }
            //         }, 1000);
            //
            //         // } else {
            //         //     $scope.$apply(function () {
            //         //         clearAlerts();
            //         //         $scope.warning = "Capetele de tabel ar trebui sa fie Request ID,Company Name,Contractor Installation,County,Oras";
            //         //     });
            //         // }
            //         // } else {
            //         //     $scope.$apply(function () {
            //         //         clearAlerts();
            //         //         $scope.warning = "Nu exista date disponibile in fisier";
            //         //     });
            //         // }
            //     }
            //
            //     reader.readAsText(filename.files[0]);
            //
            // }
            return false;
        }
    }


    // function saveObjectToProject(elementsArray) {
    //   elementsArray.forEach(element => {
    //     var project = this;
    //     project.Id = -1;
    //     project.Code = element.RID;
    //     project.Name = element.Name;
    //     project.Address = element.Address;
    //     project.DistrictId = 9;
    //     project.DistrictList = [];
    //     project.StartDate = '';
    //     project.SiteAccess = '';
    //     project.ClientId = 13;
    //     project.ClientList = [];
    //     project.WorkTypeId = 19;
    //     project.WorkTypeList = [];
    //     project.ProjectTypeId = 18;
    //     project.ProjectTypeList = [];
    //     project.ProjectManagerId = 69;
    //     project.ProjectManagerList = [];
    //     project.SiteManagerId = -1;
    //     project.SiteManagerList = [];
    //     project.Responsable = '';
    //     project.ResponsableList = [];
    //     project.Areas = [];
    //
    //     //Template
    //     project.TemplateList = [];
    //     project.SelectedTemplateId = 347;
    //     project.Template = {};
    //
    //     project.SelectedAreaId = -1;
    //     project.selectedArea = {};
    //
    //     project.templateChanged = function () {
    //         project.Template = project.TemplateList[project.SelectedTemplateId];
    //         project.selectedArea = null;
    //     };
    //
    //     project.selectArea = function (areaId) {
    //         project.selectedArea = project.Template.Areas[areaId];
    //     };
    //
    //     project.DevizeList = [];
    //     project.SelectedDevizeId = 46;
    //     project.Devize = {};
    //
    //     project.SelectedAreaIdDivize = -1;
    //     project.selectedAreaDevize = {};
    //
    //     project.devizeChanged = function () {
    //         project.Devize = project.DevizeList[project.SelectedDevizeId];
    //         project.selectedArea = null;
    //     };
    //
    //     project.selectAreaDeviz = function (areaId) {
    //         project.selectedAreaDevize = project.Devize.Areas[areaId];
    //     };
    //
    //
    //
    //     saveProject = function () {
    //         //TODO: validate project data
    //         if (project.SelectedTemplateId == -1) {
    //             alert("Nu ati selectat un sablon!");
    //             return;
    //         }
    //
    //         // if (project.SelectedDevizeId == -1) {
    //         //     alert("Nu ati selectat un sablon!");
    //         //     return;
    //         // }
    //
    //         //alert(project.StartDate);
    //         $http({
    //             method: 'POST',
    //             url: '../api/AProject/Save',
    //             headers: { 'Content-Type': 'application/json' },
    //             data: JSON.stringify(project)
    //         }).success(function (data) {
    //             console.log(data);
    //             window.location.href = "View";
    //         });
    //     };
    //
    //
    //
    //     function GetDataFromServer(url, attributeName) {
    //         $http.get(url).success(
    //             function ($data) {
    //                 project[attributeName] = $data;
    //                 console.log($data);
    //             }
    //         );
    //     }
    //
    //     function InitData() {
    //         GetDataFromServer("../api/ADistrict/GetAll", "DistrictList");
    //         GetDataFromServer("../api/AClient/GetAll", "ClientList");
    //         GetDataFromServer("../api/AWorkType/GetAll", "WorkTypeList");
    //         GetDataFromServer("../api/AProjectType/GetAll", "ProjectTypeList");
    //         GetDataFromServer("../api/AUser/GetProjectManagerList", "ProjectManagerList");
    //         GetDataFromServer("../api/AUser/GetSiteManagerList", "SiteManagerList");
    //         GetDataFromServer("../api/ATemplate/GetAll", "TemplateList");
    //         GetDataFromServer("../api/ADevize/GetAll", "DevizeList");
    //         //GetDataFromServer("../api/AResponsable/GetAll", "ResponsableList");
    //     }
    //
    //     InitData();
    //
    //     saveProject();
    //
    //   })

    // }
    /*const dateFisier = new Promise((resolve, reject) => {
        //
        var Table = document.getElementById('Table');
        var file = document.getElementById("bulkDirectFile").files[0];
        $('.loading').show();
        var allResults = [];
        //
        Papa.parse(file, {
            download: true,
            header: true,
            delimiter: "",	// auto-detect
            newline: "",	// auto-detect
            quoteChar: '"',
            escapeChar: '"',
            dynamicTyping: false,
            preview: 0,
            encoding: "",
            worker: false,
            comments: false,
            step: undefined,
            complete: undefined,
            error: undefined,
            download: false,
            downloadRequestHeaders: undefined,
            downloadRequestBody: undefined,
            skipEmptyLines: false,
            chunk: undefined,
            chunkSize: undefined,
            fastMode: undefined,
            beforeFirstChunk: undefined,
            withCredentials: undefined,
            transform: undefined,
            delimitersToGuess: [',', '\t', '|', ';', Papa.RECORD_SEP, Papa.UNIT_SEP],
            error: function (err, file, inputElem, reason) {
            },
            complete: function (results) {
                allResults.push(results.data);
                console.log(results.data);
                return results;
            }
        });
    });*/

    const process = (result) => {
        const rid = "Request ID";
        const rname = "Company Name";
        const roras = "Oras";
        results.data.forEach(element => {
            var project = this;
            project.Id = -1;
            project.Code = element.rid;
            project.Name = element.rname;
            project.Address = element.roras;
            project.DistrictId = 9;
            project.DistrictList = [];
            project.StartDate = '';
            project.SiteAccess = '';
            project.ClientId = 14;
            project.ClientList = [];
            project.WorkTypeId = 19;
            project.WorkTypeList = [];
            project.ProjectTypeId = 18;
            project.ProjectTypeList = [];
            project.ProjectManagerId = 69;
            project.ProjectManagerList = [];
            project.SiteManagerId = 74;
            project.SiteManagerList = [];
            project.Responsable = '';
            project.ResponsableList = [];
            project.Areas = [];

            //Template
            project.TemplateList = [];
            project.SelectedTemplateId = 347;
            project.Template = {};

            project.SelectedAreaId = -1;
            project.selectedArea = {};

            project.templateChanged = function () {
                project.Template = project.TemplateList[project.SelectedTemplateId];
                project.selectedArea = null;
            };

            project.selectArea = function (areaId) {
                project.selectedArea = project.Template.Areas[areaId];
            };

            project.DevizeList = [];
            project.SelectedDevizeId = 46;
            project.Devize = {};

            project.SelectedAreaIdDivize = -1;
            project.selectedAreaDevize = {};

            project.devizeChanged = function () {
                project.Devize = project.DevizeList[project.SelectedDevizeId];
                project.selectedArea = null;
            };

            project.selectAreaDeviz = function (areaId) {
                project.selectedAreaDevize = project.Devize.Areas[areaId];
            };


            saveProject = function () {
                //TODO: validate project data
                if (project.SelectedTemplateId == -1) {
                    alert("Nu ati selectat un sablon!");
                    return;
                }

                $http({
                    method: 'POST',
                    url: '../api/AProject/Save',
                    headers: {'Content-Type': 'application/json'},
                    data: JSON.stringify(project)
                }).success(function (data) {
                    console.log(data);
                    window.location.href = "View";
                });
            };


            function GetDataFromServer(url, attributeName) {
                $http.get(url).success(
                    function ($data) {
                        project[attributeName] = $data;
                        console.log($data);
                    }
                );
            }

            function InitData() {
                GetDataFromServer("../api/ADistrict/GetAll", "DistrictList");
                GetDataFromServer("../api/AClient/GetAll", "ClientList");
                GetDataFromServer("../api/AWorkType/GetAll", "WorkTypeList");
                GetDataFromServer("../api/AProjectType/GetAll", "ProjectTypeList");
                GetDataFromServer("../api/AUser/GetProjectManagerList", "ProjectManagerList");
                GetDataFromServer("../api/AUser/GetSiteManagerList", "SiteManagerList");
                GetDataFromServer("../api/ATemplate/GetAll", "TemplateList");
                GetDataFromServer("../api/ADevize/GetAll", "DevizeList");
                //GetDataFromServer("../api/AResponsable/GetAll", "ResponsableList");
            }

            InitData();
            saveProject();
        })
    };


    //   Convert to JSON function
    $scope.add = function () {
        dateFisier.then(process).catch();
//     var Table = document.getElementById('Table');
//     var file = document.getElementById("bulkDirectFile").files[0];
//     $('.loading').show();
//     var allResults = [];
//
//     Papa.parse(file, {
//     download: true,
//     header: true,
//     delimiter: "",	// auto-detect
// 	newline: "",	// auto-detect
// 	quoteChar: '"',
// 	escapeChar: '"',
// 	dynamicTyping: false,
// 	preview: 0,
// 	encoding: "",
// 	worker: false,
// 	comments: false,
// 	step: undefined,
// 	complete: undefined,
// 	error: undefined,
// 	download: false,
// 	downloadRequestHeaders: undefined,
// 	downloadRequestBody: undefined,
// 	skipEmptyLines: false,
// 	chunk: undefined,
// 	chunkSize: undefined,
// 	fastMode: undefined,
// 	beforeFirstChunk: undefined,
// 	withCredentials: undefined,
// 	transform: undefined,
// 	delimitersToGuess: [',', '\t', '|', ';', Papa.RECORD_SEP, Papa.UNIT_SEP],
//     error: function(err, file, inputElem, reason) { },
//     complete: function(results) {
//         allResults.push(results.data);
//         console.log(results.data);
//       //  saveObjectToProject(results.data);
//
//         results.data.forEach(element => {
//           var project = this;
//           project.Id = -1;
//           project.Code = element.RID;
//           project.Name = element.Name;
//           project.Address = element.Address;
//           project.DistrictId = 9;
//           project.DistrictList = [];
//           project.StartDate = '';
//           project.SiteAccess = '';
//           project.ClientId = 14;
//           project.ClientList = [];
//           project.WorkTypeId = 19;
//           project.WorkTypeList = [];
//           project.ProjectTypeId = 18;
//           project.ProjectTypeList = [];
//           project.ProjectManagerId = 69;
//           project.ProjectManagerList = [];
//           project.SiteManagerId = 74;
//           project.SiteManagerList = [];
//           project.Responsable = '';
//           project.ResponsableList = [];
//           project.Areas = [];
//
//           //Template
//           project.TemplateList = [];
//           project.SelectedTemplateId = 347;
//           project.Template = {};
//
//           project.SelectedAreaId = -1;
//           project.selectedArea = {};
//
//           project.templateChanged = function () {
//               project.Template = project.TemplateList[project.SelectedTemplateId];
//               project.selectedArea = null;
//           };
//
//           project.selectArea = function (areaId) {
//               project.selectedArea = project.Template.Areas[areaId];
//           };
//
//           project.DevizeList = [];
//           project.SelectedDevizeId = 46;
//           project.Devize = {};
//
//           project.SelectedAreaIdDivize = -1;
//           project.selectedAreaDevize = {};
//
//           project.devizeChanged = function () {
//               project.Devize = project.DevizeList[project.SelectedDevizeId];
//               project.selectedArea = null;
//           };
//
//           project.selectAreaDeviz = function (areaId) {
//               project.selectedAreaDevize = project.Devize.Areas[areaId];
//           };
//
//
//
//           saveProject = function () {
//               //TODO: validate project data
//               if (project.SelectedTemplateId == -1) {
//                   alert("Nu ati selectat un sablon!");
//                   return;
//               }
//
//               // if (project.SelectedDevizeId == -1) {
//               //     alert("Nu ati selectat un sablon!");
//               //     return;
//               // }
//
//               //alert(project.StartDate);
//               $http({
//                   method: 'POST',
//                   url: '../api/AProject/Save',
//                   headers: { 'Content-Type': 'application/json' },
//                   data: JSON.stringify(project)
//               }).success(function (data) {
//                   console.log(data);
//                   window.location.href = "View";
//               });
//           };
//
//
//
//           function GetDataFromServer(url, attributeName) {
//               $http.get(url).success(
//                   function ($data) {
//                       project[attributeName] = $data;
//                       console.log($data);
//                   }
//               );
//           }
//
//           function InitData() {
//               GetDataFromServer("../api/ADistrict/GetAll", "DistrictList");
//               GetDataFromServer("../api/AClient/GetAll", "ClientList");
//               GetDataFromServer("../api/AWorkType/GetAll", "WorkTypeList");
//               GetDataFromServer("../api/AProjectType/GetAll", "ProjectTypeList");
//               GetDataFromServer("../api/AUser/GetProjectManagerList", "ProjectManagerList");
//               GetDataFromServer("../api/AUser/GetSiteManagerList", "SiteManagerList");
//               GetDataFromServer("../api/ATemplate/GetAll", "TemplateList");
//               GetDataFromServer("../api/ADevize/GetAll", "DevizeList");
//               //GetDataFromServer("../api/AResponsable/GetAll", "ResponsableList");
//           }
//
//           InitData();
//
//           saveProject();
//
//
//
//
//
//         });
//
//
//     }
//   });
    }


});
