angular.module('devize', ["xeditable"]);

angular.module('devize').controller("CreateDevizeController", function ($scope, $http) {
    var devize = this;
    devize.Id = 1;
    devize.Name = '';
    devize.Description = '';
    devize.SelectedAreaIndex = 0;
    devize.Areas = [];

    //Area
    devize.NewArea = {
        //Name: 'Sector nou',
        Name: '',
        DevizItems: []
    };

    devize.addArea = function () {
        devize.Areas.push(devize.NewArea);
        devize.NewArea = {
            //Name: 'Sector nou',
            Name: '',
            DevizItems: []
        };
    };

    devize.deleteArea = function (index) {
        devize.Areas.splice(index, 1);
    };

    devize.duplicateArea = function (index) {
        devize.NewArea.Name = devize.Areas[index].Name + "_Duplicat";

        for (var i = 0; i < devize.Areas[index].DevizItems.length; i++) {
            devize.NewDevizItem.Name = devize.Areas[index].DevizItems[i].Name;
            devize.NewDevizItem.Cant = devize.Areas[index].DevizItems[i].Cant;

            devize.NewArea.DevizItems.push(devize.NewDevizItem);
            devize.NewDevizItem = {
                Name: '',
                Cant: 1
            };
        }
        devize.Areas.push(devize.NewArea);
        devize.NewArea = {
            Name: '',
            DevizItems: []
        };
    };

    devize.selectArea = function (index) {
        devize.SelectedAreaIndex = index;
    };

    //elements
    devize.NewDevizItem = {
        //Name: 'Element nou',
        Name: '',
        Cant: 1
    }

    devize.addDevizItem = function () {
        devize.Areas[devize.SelectedAreaIndex].DevizItems.push(devize.NewDevizItem);
        devize.NewDevizItem = {
            //Name: 'Element nou',
            Name: '',
            Cant: 1
        };
    };

    devize.deleteDevizItem = function (index) {
        devize.Areas[devize.SelectedAreaIndex].DevizItems.splice(index, 1);
    };

    //Post data
    devize.saveDevize = function () {
        if (devize.Areas == undefined || devize.Areas == null || devize.Areas.length <= 0) {
            alert("Sablonul nu contine sectoare/elemente!");
            return;
        }
        if (devize.Name == null || devize.Name == undefined || devize.Name == "") {
            alert("Numele sablonului nu a fost completat!");
            return;
        }

        for (i = 0; i < devize.Areas.length; i++) {
            if (devize.Areas[i].Name == null || devize.Areas[i].Name == undefined || devize.Areas[i].Name == "") {
                alert("Sablonul contine sectoare fara nume!");
                return;
            }
        }

        $http({
            method: 'POST',
            url: '../api/ADevize/Save',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(devize)
        }).success(function (data) {
            //console.log(data);
            window.location.href = "View";
        });
    };
});

angular.module('devize').controller("EditDevize", function ($scope, $http) {
    var devize = this;
    devize.Id = 1;
    devize.Name = '';
    devize.Description = '';
    devize.SelectedAreaIndex = 0;
    devize.Areas = [];

    $scope.init = function (devizeId) {
        devize.Id = devizeId;
        //console.log(devize);
        GetDataFromServer("../../ws/DevizeService/GetById/" + devize.Id, 'Devize');
    }

    function GetDataFromServer(url, attributeName) {
        $http.get(url).success(
            function ($data) {
                //console.log($data);
                devize.Name = $data.Name;
                devize.Description = $data.Description;
                devize.Areas = $data.Areas;

            }
        );
    }

    //Area
    devize.NewArea = {
        //Name: 'Sector nou',
        Name: '',
        DevizItems: []
    };
    //ng-click="main.selectArea(area.Id)"
    devize.addArea = function () {
        devize.Areas.push(devize.NewArea);
        devize.NewArea = {
            //Name: 'Sector nou',
            Name: '',
            DevizItems: []
        };
    };

    devize.duplicateArea = function (index) {
        devize.NewArea.Name = devize.Areas[index].Name + "_Duplicat";

        for (var i = 0; i < devize.Areas[index].DevizItems.length; i++) {
            devize.NewDevizItem.Name = devize.Areas[index].DevizItems[i].Name;
            devize.NewDevizItem.Cant = devize.Areas[index].DevizItems[i].Cant;

            devize.NewArea.DevizItems.push(devize.NewDevizItem);
            devize.NewDevizItem = {
                Name: '',
                Cant: 1
            };
        }
        devize.Areas.push(devize.NewArea);
        devize.NewArea = {
            Name: '',
            DevizItems: []
        };
    };

    devize.deleteArea = function (index) {
        devize.Areas.splice(index, 1);
    };

    devize.selectArea = function (index) {
        devize.SelectedAreaIndex = index;
    };

    //elements
    devize.NewDevizItem = {
        //Name: 'Element nou',
        Name: '',
        Cant: 1
    }

    devize.addDevizItem = function () {
        devize.Areas[devize.SelectedAreaIndex].DevizItems.push(devize.NewDevizItem);
        devize.NewDevizItem = {
            //Name: 'Element nou',
            Name: '',
            Cant: 1
        };
    };

    devize.deleteDevizItem = function (index) {
        devize.Areas[devize.SelectedAreaIndex].DevizItems.splice(index, 1);
    };

    //Post data
    devize.updateDevize = function () {

        for (i = 0; i < devize.Areas.length; i++) {
            if (devize.Areas[i].Name == null || devize.Areas[i].Name == undefined || devize.Areas[i].Name == "") {
                alert("Sablonul contine sectoare fara nume!");
                return;
            }
        }

        $http({
            method: 'POST',
            url: '../../ws/DevizeService/Update',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(devize)
        }).success(function (data) {
            //console.log(data);
            window.location.href = "../View";
        });
    };
});
