﻿angular.module('project', ['infinite-scroll', 'xeditable']);
angular.module('project', []).controller("CreateProjectController", function ($scope, $http) {
    var project = this;
    project.Id = -1;
    project.Code = '';
    project.Name = '';
    project.Address = '';
    project.DistrictId = -1;
    project.DistrictList = [];
    project.StartDate = '';
    project.SiteAccess = '';
    project.ClientId = -1;
    project.ClientList = [];
    project.WorkTypeId = -1;
    project.WorkTypeList = [];
    project.ProjectTypeId = -1;
    project.ProjectTypeList = [];
    project.ProjectManagerId = -1;
    project.ProjectManagerList = [];
    project.SiteManagerId = -1;
    project.SiteManagerList = [];
    project.Responsable = '';
    project.ResponsableList = [];
    project.Areas = [];

    //Template
    project.TemplateList = [];
    project.SelectedTemplateId = -1;
    project.Template = {};

    project.SelectedAreaId = -1;
    project.selectedArea = {};

    project.templateChanged = function () {
        project.Template = project.TemplateList[project.SelectedTemplateId];
        project.selectedArea = null;
    };

    project.selectArea = function (areaId) {
        project.selectedArea = project.Template.Areas[areaId];
    };

    project.DevizeList = [];
    project.SelectedDevizeId = -1;
    project.Devize = {};
    project.DueDate = '';
    project.SelectedAreaIdDivize = -1;
    project.selectedAreaDevize = {};

    project.devizeChanged = function () {
        project.Devize = project.DevizeList[project.SelectedDevizeId];
        project.selectedArea = null;
    };

    project.selectAreaDeviz = function (areaId) {
        project.selectedAreaDevize = project.Devize.Areas[areaId];
    };


    project.saveProject = function () {
        //TODO: validate project data
        if (project.SelectedTemplateId == -1) {
            alert("Nu ati selectat un sablon!");
            return;
        }

        // if (project.SelectedDevizeId == -1) {
        //     alert("Nu ati selectat un sablon!");
        //     return;
        // }

        //alert(project.StartDate);
        $http({
            method: 'POST',
            url: '../api/AProject/Save',
            headers: {'Content-Type': 'application/json'},
            data: JSON.stringify(project)
        }).success(function (data) {
            console.log(data);
            window.location.href = "View";
        });
    };


    function GetDataFromServer(url, attributeName) {
        $http.get(url).success(
            function ($data) {
                project[attributeName] = $data;
                console.log($data);
            }
        );
    }

    function InitData() {
        GetDataFromServer("../api/ADistrict/GetAll", "DistrictList");
        GetDataFromServer("../api/AClient/GetAll", "ClientList");
        GetDataFromServer("../api/AWorkType/GetAll", "WorkTypeList");
        GetDataFromServer("../api/AProjectType/GetAll", "ProjectTypeList");
        GetDataFromServer("../api/AUser/GetProjectManagerList", "ProjectManagerList");
        GetDataFromServer("../api/AUser/GetSiteManagerList", "SiteManagerList");
        GetDataFromServer("../api/ATemplate/GetAll", "TemplateList");
        GetDataFromServer("../api/ADevize/GetAll", "DevizeList");
        //GetDataFromServer("../api/AResponsable/GetAll", "ResponsableList");
    }

    InitData();

});


//angular.module('project').controller("ProjectListController", function ($scope, $http) {
//    $scope.Projects = [];

//    function GetDataFromServer(url, attributeName) {
//        $http.get(url).success(
//            function ($data) {
//                $scope[attributeName] = $data;
//                //console.log(data);
//            }
//        );
//    }

//    function InitData() {
//        GetDataFromServer("../ws/ProjectService/GetProjectList", "Projects");

//    }

//    $scope.confirmAction = function (url,id) {
//        if (confirm("Sigur doriti sa stergeti inregistrarea?")){
//            url = url + id;
//            window.location.href = url;
//        }
//    }

//    $scope.sort = function (keyname) {
//        $scope.sortKey = keyname;   //set the sortKey to the param passed
//        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
//    }

//    InitData();

//});

angular.module('project').controller("ProjectEditController", function ($scope, $http) {
    var data = this;
    data.ProjectId = -1;
    data.Project = {};
    data.SelectedArea = {};
    data.SelectedAreaId = -1;

    data.SiteManagerId = -1;
    data.SMId = -1;
    data.SiteManagerList = [];

    data.ProjectManagerId = -1;
    data.PtMId = -1;
    data.ProjectManagerList = [];
    data.inputEstimationList = [];
    $scope.isInputEstiExist = false;
    $scope.isInternalInputEstiExist = false;
    data.internalInputEstimationList = [];
    data.commentList = [];
    data.StatusId = null;
    data.StatusList = [];

    $scope.init = function (projectId) {
        data.ProjectId = projectId;

        GetPMList(GetSMList);
        //GetDataFromServer("../../api/AUser/GetSiteManagerList", "SiteManagerList", nextList);
        //GetDataFromServer("../../api/AUser/GetProjectManagerList", "ProjectManagerList");
        //GetProjectFromServer("../../api/AProject/GetById/" + data.ProjectId, 'Project');
    }

    function GetPMList(callback) {
        $http.get("../../api/AUser/GetProjectManagerList").success(
            function ($data) {
                data.ProjectManagerList = $data;
                callback();
            }
        );
    }

    function GetSMList() {
        $http.get("../../api/AUser/GetSiteManagerList").success(
            function ($data) {
                data.SiteManagerList = $data;
                GetStatusList();
                GetProjectData();

            }
        );
    }

    function GetProjectData() {
        $http.get("../../api/AProject/GetById/" + data.ProjectId).success(
            function ($data) {
                data.Project = $data;
                if (data.Project.SiteManagerRef != null) {
                    data.SiteManagerId = data.Project.SiteManagerRef.Id;
                } else {
                    data.SiteManagerId = null;
                }
                if (data.Project.ProjectManagerRef != null) {
                    data.ProjectManagerId = data.Project.ProjectManagerRef.Id;
                } else {
                    data.ProjectManagerId = null;
                }
                data.StatusId = data.Project.StatusRef.Id;
                GetProjectInputEstimateFile();
                GetProjectComment();


                // GetProjectInternalInputEstimateFile();


            }
        );
    }

    function GetStatusList() {
        $http.get("../../api/AStatus/GetStatusList").success(
            function ($data) {
                data.StatusList = $data;
            }
        );
    }

    function GetProjectInputEstimateFile() {
        $http.get("../../api/AProject/getInputEstimate/" + data.ProjectId).success(
            function (response) {

                console.log(response);
                if (response != 'null') {

                    console.log(typeof response);
                    // console.log(res);

                    Object.keys(response).forEach(function (key) {

                        console.log(response[key]['is_internal_type']);
                        if (response[key]['is_internal_type'] == 0) {
                            data.inputEstimationList.name = response[key]['name'];
                            data.inputEstimationList.created_at = response[key]['created_at'];
                            data.inputEstimationList.update_at = response[key]['update_at'];
                            data.inputEstimationList.url = response[key]['url'];
                            $scope.isInputEstiExist = true;
                        } else {
                            data.internalInputEstimationList.name = response[key]['name'];
                            data.internalInputEstimationList.created_at = response[key]['created_at'];
                            data.internalInputEstimationList.update_at = response[key]['update_at'];
                            data.internalInputEstimationList.url = response[key]['url'];
                            $scope.isInternalInputEstiExist = true;
                        }


                    });
                    // data.inputEstimationList = response;
                }
            }
        );
    }

    function GetProjectComment() {
        $http.get("../../api/AProject/getProjectComment/" + data.ProjectId).success(
            function (response) {
                console.log("GetProjectComment");
                console.log(response);
                if (response != 'null') {

                    console.log(typeof response);

                    data.commentList = response;
                }
            }
        );
    }


    //function GetDataFromServer(url, attributeName,callback) {
    //    $http.get(url).success(
    //        function ($data) {
    //            data[attributeName] = $data;
    //            data.SiteManagerId = data.SMId;
    //            data.ProjectManagerId = data.PtMId;
    //        }
    //    );
    //}

    //function GetProjectFromServer(url, attributeName) {
    //    $http.get(url).success(
    //        function ($data) {
    //            data[attributeName] = $data;

    //            data.SiteManagerId = data.Project.SiteManagerRef.Id;
    //            data.SMId = data.Project.SiteManagerRef.Id;

    //            data.ProjectManagerId = data.Project.ProjectManagerRef.Id;
    //            data.PtMId = data.Project.ProjectManagerRef.Id;
    //        }
    //    );
    //}

    data.selectArea = function (areaId) {
        data.SelectedAreaId = areaId;
        data.SelectedArea = data.Project.Areas[areaId];
    };


    data.pendingProject = function () {
        if (confirm('Are you sure you want to request a pending status?')) {
            data.Project.SiteManagerId = data.SiteManagerId;
            data.Project.ProjectManagerId = data.ProjectManagerId;
            console.log(data.Project);
            $http({
                method: 'POST',
                url: '../../api/AProject/Pending',
                headers: {'Content-Type': 'application/json'},
                data: JSON.stringify(data.Project)

            }).success(function (data) {
                window.location.href = "../View";
            });
        } else {

        }
    };

    data.cancelProject = function () {
        if (confirm('Are you sure you want to cancel the task?')) {
            data.Project.SiteManagerId = data.SiteManagerId;
            data.Project.ProjectManagerId = data.ProjectManagerId;
            console.log(data.Project);
            $http({
                method: 'POST',
                url: '../../api/AProject/Cancel',
                headers: {'Content-Type': 'application/json'},
                data: JSON.stringify(data.Project)

            }).success(function (data) {
                window.location.href = "../View";
            });
        } else {
        }
    };


    data.updateProject = function () {
        data.Project.SiteManagerId = data.SiteManagerId;
        data.Project.ProjectManagerId = data.ProjectManagerId;
        $http({
            method: 'POST',
            url: '../../api/AProject/Update',
            headers: {'Content-Type': 'application/json'},
            data: JSON.stringify(data.Project)

        }).success(function (data) {
            window.location.href = "../View";
        });
    };

    data.uploadXlsxFile = function () {
        var fileInput =
            document.getElementById('xlsx-file');

        var filePath = fileInput.value;
        if (filePath == '') {
            alert('Select xlsx file to uplaod');
            fileInput.value = '';
            return false;
        }
        // Allowing file type

        var allowedExtensions = /(\.xlsx|\.xls)$/i;

        if (!allowedExtensions.exec(filePath)) {
            alert('Please upload file having extensions .xlsx/.xls only.');
            fileInput.value = '';
            return false;
        }
        var filename = document.getElementById("xlsx-file").files[0];

        var formData = new FormData();
        formData.append("file", filename);
        formData.append("projectId", data.Project.Id);

        $http({
            method: 'POST',
            url: '../../api/AProject/UploadXlsxFile',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}

        }).success(function (data) {
            alert(data.Message);
            // window.location.href = "../View";
        });
    };


    data.goBack = function () {
        window.history.back();
    };

    data.autoCreateInternalInputEstimation = function () {
        var formData = new FormData();
        formData.append("projectId", data.Project.Id);
        $http({
            method: 'POST',
            url: '../../api/AProject/AutoCreateInternalInputEstimation',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}
        }).success(function (response) {
            alert(response.Message);
            window.location.reload();
        });
    };
    data.postComment = function () {
        if ($('#commentstr').val() == '') {
            alert('Input can not be left blank');
            return false;
        }
        var formData = new FormData();
        formData.append("projectId", data.Project.Id);
        formData.append("comment", $('#commentstr').val());
        formData.append("id", $('#commentId').val());
        $http({
            method: 'POST',
            url: '../../api/AProject/saveComment',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}
        }).success(function (response) {
            alert(response.Message);
            $("#commentstr").val("");
            $("#commentId").val("");
            GetProjectComment();
        });

    };
    data.showComment = function (id, comment) {
        $("#commentstr").val(comment);
        $("#commentId").val(id);
    }
    data.deleteComment = function (id) {
        var result = confirm("Are you sure you want to delete this comment?");
        if (result) {
            var formData = new FormData();
            formData.append("id", id);
            $http({
                method: 'POST',
                url: '../../api/AProject/deleteComment',
                data: formData,
                transformRequest: angular.identity,
                headers: {'Content-Type': undefined, 'Process-Data': false}
            }).success(function (response) {
                alert(response.Message);
                GetProjectComment();
            });

        }


    }

});


angular.module('project').controller("ProjectListController", function ($scope, $http) {
    var project = this;
    project.ProjectId = -1;
    project.StatusId = '';


});
