﻿angular.module('project', ['infinite-scroll', 'xeditable']);
angular.module('project', []).controller("CreateProjectController", function ($scope, $http) {
    var project = this;
    project.Id = -1;
    project.Code = '';
    project.Name = '';
    project.Address = '';
    project.DistrictId = -1;
    project.DistrictList = [];
    project.StartDate = '';
    project.SiteAccess = '';
    project.ClientId = -1;
    project.ClientList = [];
    project.WorkTypeId = -1;
    project.WorkTypeList = [];
    project.ProjectTypeId = -1;
    project.ProjectTypeList = [];
    project.ProjectManagerId = -1;
    project.ProjectManagerList = [];
    project.SiteManagerId = -1;
    project.SiteManagerList = [];
    project.Responsable = '';
    project.ResponsableList = [];
    project.Areas = [];

    //Template
    project.TemplateList = [];
    project.SelectedTemplateId = -1;
    project.Template = {};

    project.SelectedAreaId = -1;
    project.selectedArea = {};

    project.templateChanged = function () {
        project.Template = project.TemplateList[project.SelectedTemplateId];
        project.selectedArea = null;
    };

    project.selectArea = function (areaId) {
        project.selectedArea = project.Template.Areas[areaId];
    };

    project.DevizeList = [];
    project.SelectedDevizeId = -1;
    project.Devize = {};
    project.DueDate = '';
    project.SelectedAreaIdDivize = -1;
    project.selectedAreaDevize = {};

    project.devizeChanged = function () {
        project.Devize = project.DevizeList[project.SelectedDevizeId];
        project.selectedArea = null;
    };

    project.selectAreaDeviz = function (areaId) {
        project.selectedAreaDevize = project.Devize.Areas[areaId];
    };


    project.saveProject = function () {
        //TODO: validate project data
        if (project.SelectedTemplateId == -1) {
            alert("Nu ati selectat un sablon!");
            return;
        }

        // if (project.SelectedDevizeId == -1) {
        //     alert("Nu ati selectat un sablon!");
        //     return;
        // }

        //alert(project.StartDate);
        $http({
            method: 'POST',
            url: '../api/AProject/Save',
            headers: {'Content-Type': 'application/json'},
            data: JSON.stringify(project)
        }).success(function (data) {
            window.location.href = "View";
        });
    };


    function GetDataFromServer(url, attributeName) {
        $http.get(url).success(
            function ($data) {
                project[attributeName] = $data;
            }
        );
    }

    function InitData() {
        GetDataFromServer("../api/ADistrict/GetAll", "DistrictList");
        GetDataFromServer("../api/AClient/GetAll", "ClientList");
        GetDataFromServer("../api/AWorkType/GetAll", "WorkTypeList");
        GetDataFromServer("../api/AProjectType/GetAll", "ProjectTypeList");
        GetDataFromServer("../api/AUser/GetProjectManagerList", "ProjectManagerList");
        GetDataFromServer("../api/AUser/GetSiteManagerList", "SiteManagerList");
        GetDataFromServer("../api/ATemplate/GetAll", "TemplateList");
        GetDataFromServer("../api/ADevize/GetAll", "DevizeList");
        //GetDataFromServer("../api/AResponsable/GetAll", "ResponsableList");
    }

    InitData();

});


//angular.module('project').controller("ProjectListController", function ($scope, $http) {
//    $scope.Projects = [];

//    function GetDataFromServer(url, attributeName) {
//        $http.get(url).success(
//            function ($data) {
//                $scope[attributeName] = $data;
//                //console.log(data);
//            }
//        );
//    }

//    function InitData() {
//        GetDataFromServer("../ws/ProjectService/GetProjectList", "Projects");

//    }

//    $scope.confirmAction = function (url,id) {
//        if (confirm("Sigur doriti sa stergeti inregistrarea?")){
//            url = url + id;
//            window.location.href = url;
//        }
//    }

//    $scope.sort = function (keyname) {
//        $scope.sortKey = keyname;   //set the sortKey to the param passed
//        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
//    }

//    InitData();

//});

angular.module('project').controller("ProjectEditController", function ($scope, $http) {
    $scope.isValidDataFolder = true;
    var data = this;
    data.ProjectId = -1;
    data.Project = {};
    data.SelectedArea = {};
    data.SelectedAreaId = -1;

    data.SiteManagerId = -1;
    data.SMId = -1;
    data.SiteManagerList = [];

    data.ProjectManagerId = -1;
    data.PtMId = -1;
    data.ProjectManagerList = [];
    data.inputEstimationList = [];
    $scope.isInputEstiExist = false;
    $scope.isInternalInputEstiExist = false;
    data.internalInputEstimationList = [];
    data.commentList = [];
    data.StatusId = null;
    data.StatusList = [];
    $scope.selectedElementId = null;
    $scope.selectedElementName = null;
    $scope.installationReportData = [];

    $scope.init = function (projectId) {
        data.ProjectId = projectId;

        GetPMList(GetSMList);
        //GetDataFromServer("../../api/AUser/GetSiteManagerList", "SiteManagerList", nextList);
        //GetDataFromServer("../../api/AUser/GetProjectManagerList", "ProjectManagerList");
        //GetProjectFromServer("../../api/AProject/GetById/" + data.ProjectId, 'Project');
    }

    function GetPMList(callback) {
        $http.get("../../api/AUser/GetProjectManagerList").success(
            function ($data) {
                data.ProjectManagerList = $data;
                callback();
            }
        );
    }

    function GetSMList() {
        $http.get("../../api/AUser/GetSiteManagerList").success(
            function ($data) {
                data.SiteManagerList = $data;
                GetStatusList();
                GetProjectData();

            }
        );
    }

    function GetProjectData() {
        $http.get("../../api/AProject/GetById/" + data.ProjectId).success(
            function ($data) {
                data.Project = $data;
                if (data.Project.SiteManagerRef != null) {
                    data.SiteManagerId = data.Project.SiteManagerRef.Id;
                } else {
                    data.SiteManagerId = null;
                }
                if (data.Project.ProjectManagerRef != null) {
                    data.ProjectManagerId = data.Project.ProjectManagerRef.Id;
                } else {
                    data.ProjectManagerId = null;
                }
                data.StatusId = data.Project.StatusRef.Id;
                getProjectAdditionalInfo();
                if (data.Project.Name === '' || data.Project.Name.length === 0) {
                    $scope.isValidDataFolder = false;
                }
                if (data.Project.Code === '' || data.Project.Code.length === 0) {
                    $scope.isValidDataFolder = false;
                }
                if (data.Project.Code === '' || data.Project.Code.length === 0) {
                    $scope.isValidDataFolder = false;
                }
                if (data.Project.ClientRef === null) {
                    $scope.isValidDataFolder = false;
                }
                if (data.Project.ProjectTypeRef === null) {
                    $scope.isValidDataFolder = false;
                }
                if (data.Project.WorkTypeRef === null) {
                    $scope.isValidDataFolder = false;
                }
                if (data.ProjectManagerId === null) {
                    $scope.isValidDataFolder = false;
                }
                if (data.SiteManagerId === null) {
                    $scope.isValidDataFolder = false;
                }
            }
        );
    }

    function GetStatusList() {
        $http.get("../../api/AStatus/GetStatusList").success(
            function ($data) {
                data.StatusList = $data;
            }
        );
    }

    function GetProjectComment() {
        $http.get("../../api/AProject/getProjectComment/" + data.ProjectId).success(
            function (response) {
                if (response != 'null') {
                    data.commentList = response;
                }
            }
        );
    }

    function getProjectAdditionalInfo() {

        $http({
            method: 'POST',
            url: base_url.concat('index.php/Projects/getProjectAdditionalInfo'),
            headers: {'Content-Type': 'application/json'},
            data: JSON.stringify({"id": data.Project.Id})

        }).success(function (response) {
            if (Object.keys(response['estimationData']).length > 0) {
                Object.keys(response['estimationData']).forEach(function (key) {
                    if (response['estimationData'][key]['is_internal_type'] == 0) {
                        data.inputEstimationList.name = response['estimationData'][key]['name'];
                        data.inputEstimationList.created_at = response['estimationData'][key]['created_at'];
                        data.inputEstimationList.update_at = response['estimationData'][key]['update_at'];
                        data.inputEstimationList.url = response['estimationData'][key]['url'];
                        $scope.isInputEstiExist = true;
                    } else {
                        data.internalInputEstimationList.name = response['estimationData'][key]['name'];
                        data.internalInputEstimationList.created_at = response['estimationData'][key]['created_at'];
                        data.internalInputEstimationList.update_at = response['estimationData'][key]['update_at'];
                        data.internalInputEstimationList.url = response['estimationData'][key]['url'];
                        $scope.isInternalInputEstiExist = true;
                    }
                });
            }
            if (Object.keys(response['commentData']).length > 0) {
                data.commentList = response['commentData'];
            }

            data.installationReportData = response['installationReportData'];
            // console.log($scope.main.installationReportData);


        });

    }

    //function GetDataFromServer(url, attributeName,callback) {
    //    $http.get(url).success(
    //        function ($data) {
    //            data[attributeName] = $data;
    //            data.SiteManagerId = data.SMId;
    //            data.ProjectManagerId = data.PtMId;
    //        }
    //    );
    //}

    //function GetProjectFromServer(url, attributeName) {
    //    $http.get(url).success(
    //        function ($data) {
    //            data[attributeName] = $data;

    //            data.SiteManagerId = data.Project.SiteManagerRef.Id;
    //            data.SMId = data.Project.SiteManagerRef.Id;

    //            data.ProjectManagerId = data.Project.ProjectManagerRef.Id;
    //            data.PtMId = data.Project.ProjectManagerRef.Id;
    //        }
    //    );
    //}

    data.selectArea = function (areaId) {
        data.SelectedAreaId = areaId;
        data.SelectedArea = data.Project.Areas[areaId];
    };


    data.pendingProject = function (flg) {
        if (flg == 1) {
            var msg = 'Esti sigur ca vrei sa ceri un status de pending request? Aceasta actiune poate fi deblocata doar de un PM NTT.';
        } else {
            var msg = 'Esti sigura ca vrei sa deblochezi acesta lucrare?';
        }
        if (confirm(msg)) {
            $http({
                method: 'POST',
                url: '../../api/AProject/updateTaskStatusPending',
                headers: {'Content-Type': 'application/json'},
                data: JSON.stringify({"id": data.Project.Id, "flg": flg})

            }).success(function (response) {
                alert(response.Message);
                window.location.href = "../View";
            });
        }
    };

    data.cancelProject = function () {
        if (confirm('Are you sure you want to cancel the task?')) {
            data.Project.SiteManagerId = data.SiteManagerId;
            data.Project.ProjectManagerId = data.ProjectManagerId;
            $http({
                method: 'POST',
                url: '../../api/AProject/Cancel',
                headers: {'Content-Type': 'application/json'},
                data: JSON.stringify(data.Project)

            }).success(function (data) {
                window.location.href = "../View";
            });
        } else {
        }
    };


    data.updateProject = function () {
        data.Project.SiteManagerId = data.SiteManagerId;
        data.Project.ProjectManagerId = data.ProjectManagerId;
        data.Project.StatusId = data.StatusId;
        $http({
            method: 'POST',
            url: '../../api/AProject/Update',
            headers: {'Content-Type': 'application/json'},
            data: JSON.stringify(data.Project)

        }).success(function (data) {
            window.location.href = "../View";
        });
    };

    data.uploadXlsxFile = function () {
        var fileInput =
            document.getElementById('xlsx-file');

        var filePath = fileInput.value;
        if (filePath == '') {
            alert('Select xlsx file to uplaod');
            fileInput.value = '';
            return false;
        }
        // Allowing file type

        var allowedExtensions = /(\.xlsx|\.xls)$/i;

        if (!allowedExtensions.exec(filePath)) {
            alert('Please upload file having extensions .xlsx/.xls only.');
            fileInput.value = '';
            return false;
        }
        var filename = document.getElementById("xlsx-file").files[0];

        var formData = new FormData();
        formData.append("file", filename);
        formData.append("projectId", data.Project.Id);

        $http({
            method: 'POST',
            url: '../../api/AProject/UploadXlsxFile',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}

        }).success(function (data) {
            alert(data.Message);
            // window.location.href = "../View";
        });
    };


    data.goBack = function () {
        window.history.back();
    };

    data.autoCreateInternalInputEstimation = function () {
        var formData = new FormData();
        formData.append("projectId", data.Project.Id);
        $http({
            method: 'POST',
            url: '../../api/AProject/AutoCreateInternalInputEstimation',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}
        }).success(function (response) {
            alert(response.Message);
            window.location.reload();
        });
    };
    data.postComment = function () {
        if ($('#commentstr').val() == '') {
            alert('Campul nu poate fi gol!');
            return false;
        }
        var formData = new FormData();
        formData.append("projectId", data.Project.Id);
        formData.append("comment", $('#commentstr').val());
        formData.append("id", $('#commentId').val());
        $http({
            method: 'POST',
            url: '../../api/AProject/saveComment',
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}
        }).success(function (response) {
            alert(response.Message);
            $("#commentstr").val("");
            $("#commentId").val("");
            GetProjectComment();
        });

    };
    data.showComment = function (id, comment) {
        $("#commentstr").val(comment);
        $("#commentId").val(id);
    }
    data.deleteComment = function (id) {
        var result = confirm("Esti sigur ca doresti sa stergi acest comentariu?");
        if (result) {
            var formData = new FormData();
            formData.append("id", id);
            $http({
                method: 'POST',
                url: '../../api/AProject/deleteComment',
                data: formData,
                transformRequest: angular.identity,
                headers: {'Content-Type': undefined, 'Process-Data': false}
            }).success(function (response) {
                alert(response.Message);
                GetProjectComment();
            });

        }


    }
    $scope.fileSelected = function (element) {
        var _validFileExtensions = [".jpg", ".jpeg", ".bmp", ".gif", ".png"];
        var file = element.files[0];
        var filename = file.name;
        var blnValid = false;
        for (var j = 0; j < _validFileExtensions.length; j++) {
            var sCurExtension = _validFileExtensions[j];
            if (filename.substr(filename.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                blnValid = true;
                break;
            }
        }
        if (!blnValid) {
            alert("Sorry, " + filename + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
            return false;
        }
        var fileSize = file.size / 1024 / 1024;
        if (fileSize > 8) {
            alert('File size exceeds 8 MiB');
            return false;
        }

        var formData = new FormData();
        formData.append("AreaId", data.SelectedArea.Id);
        formData.append("AreaName", data.SelectedArea.Name);
        formData.append("Client", data.Project.ClientRef.Name);
        formData.append("Code", data.Project.Code);
        formData.append("ElementId", $scope.selectedElementId);
        formData.append("ElementName", $scope.selectedElementName);
        formData.append("projectId", data.Project.Id);
        formData.append("ProjectManager", data.Project.ProjectManagerRef.Name);
        formData.append("ProjectName", data.Project.Name);
        formData.append("ProjectType", data.Project.ProjectTypeRef.Name);
        formData.append("SiteManager", data.Project.SiteManagerRef.Name);
        formData.append("WorkType", data.Project.WorkTypeRef.Name);
        formData.append("file", file);

        $http({
            method: 'POST',
            url: base_url.concat('index.php/ProjectElements/SaveElement'),
            data: formData,
            transformRequest: angular.identity,
            headers: {'Content-Type': undefined, 'Process-Data': false}

        }).success(function (data) {
            alert(data.Message);
            location.reload();
        });
    };
    $scope.checkData = function (e, elementData) {
        if ($scope.isValidDataFolder) {
            $scope.selectedElementId = elementData.Id;
            $scope.selectedElementName = elementData.Name;
            return true;
        }
        alert("Sorry,Some data missing to create folder structure");
        e.preventDefault();
        return false;
    };
    $scope.checkValidDataFolder = function (e) {
        console.log("checkValidDataFolder::" + $scope.isValidDataFolder);
        if ($scope.isValidDataFolder) {
            return true;
        }
        alert("Sorry,Some data missing to create folder structure");
        e.preventDefault();
        return false;
    };
    $scope.checkInstallationReportExist = function (e) {
        if ($scope.main.installationReportData.length == 0) {
            alert("Nu s-a detectat un raport de instalare. Devizul nu poate fi generat daca nu exista un raport de instalare");
            e.preventDefault();
            return false;
        }

    };
    $scope.download = function (url) {
        var fullUrl = base_url.concat(url)
        const a = document.createElement('a');
        a.href = fullUrl;
        a.download = fullUrl.split('/').pop();
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    };


});


angular.module('project').controller("ProjectListController", function ($scope, $http) {
    var project = this;
    project.ProjectId = -1;
    project.StatusId = '';


});

$(function () {
    $('#status').on('change', function (e) {
        //console.log('cjhange');return false;
        $.ajax({
            url: base_url.concat('index.php/Projects/getStatusWiseProjects'),
            type: "post",    //request type,
            dataType: 'json',
            data: JSON.stringify({statusId: $('#status').val(), contractor: $('#contractor').val()}),
            headers: {'Content-Type': 'application/json'},
            success: function (response) {
                $("#dataTable2").DataTable().clear().destroy();
                $('#projectData').html(response.html);
                $('#dataTable2').DataTable({
                    initComplete: function () {
                        this.api().columns().every(function () {
                            var column = this;
                            var select = $('<select><option value=""></option></select>')
                                .appendTo($(column.header().empty()))
                                .on('change', function () {
                                    var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                    );

                                    column
                                        .search(val ? '^' + val + '$' : '', true, false)
                                        .draw();
                                });

                            column.data().unique().sort().each(function (d, j) {
                                select.append('<option value="' + d + '">' + d + '</option>')
                            });
                        });
                    }
                });
                /*if(response.projects.length > 0){
                    var row = "";
                    $.each(response.projects, function(index, value) {
                        row += "<tr>";
                            row += "<td>"+value.Code+"</td>";
                            row += "<td>"+value.Name+"</td>";
                            if(value.distictName != null){
                                row += "<td>"+value.distictName+"</td>";
                            }else{
                                row += "<td>Indisponibil</td>";
                            }
                            row += "<td>"+value.Code+"</td>";
                            row += "<td>"+value.Code+"</td>";
                            row += "<td>"+value.Code+"</td>";
                            row += "<td>"+value.Code+"</td>";
                            row += "<td>"+value.Code+"</td>";
                            row += "<td>"+value.StartDate+"</td>";
                            row += "<td>"+value.DueDate+"</td>";
                            row += "<td>"+value.Code+"</td>";
                        row += "</tr>";
                    });
                    $("#dataTable2").DataTable().clear().destroy();
                    $('#projectData').html(row);
                    $("#dataTable2").DataTable();
                    console.log(response.projects);
                }*/
            }
        });
    });

    $('#updateBulkStatus').on('submit', function (e) {
        e.preventDefault();
        var status = $('#statusDrop').val();
        if (status == "") {
            alert("Please select status.");
        } else {
            var projects = [];
            $('.projectsCheck:checked').each(function () {
                projects.push(this.value);
            });
            if (projects.length > 0) {
                $.ajax({
                    url: base_url.concat('index.php/Projects/updateBulkStatus'),
                    type: "post",    //request type,
                    dataType: 'json',
                    data: JSON.stringify({status: status, projects: projects}),
                    headers: {'Content-Type': 'application/json'},
                    success: function (response) {
                        alert(response.message);
                        window.location.reload();
                    }
                });
            }
        }
    });
    $(document).on('ifToggled', '.checkAllProjects', function (event) {
        var table = $(event.target).closest('table');
        if (event.currentTarget.checked) {
            $('.projectsCheck').prop('checked', true).iCheck('update');
        } else {
            $('.projectsCheck').prop('checked', false).iCheck('update');
        }
    });


});
