$(function () {

    var tblPreventivi = $('#dataTable').DataTable({

        "processing": true,
        "serverSide": true,
        "ordering": true,
        'ajax': {
            'url': base_url.concat('index.php/Reports/getData'),
            'type': "post",
            'data': function (data) {
                var projectIds = [0];
                var checkboxes = document.querySelectorAll('input[type=checkbox]:checked')
                for (var i = 0; i < checkboxes.length; i++) {
                    projectIds.push(checkboxes[i].value)
                }
                data.projectIds = projectIds;
                data.pmUser = $('#contractorDrop').val();
                data.status = $('#statusDrop').val();
                data.isReset = $('#isReset').val();
            },
            "dataSrc": function (json) {
                $('#isReset').val(0);
                return json.data;
            },
        },
        'pageLength': 10,
        'bSort': false,
        'order': [[2, 'asc']],

        'columnDefs': [{
            "targets": [8],
            "orderable": false
        },
            {
                "targets": [0],
                "orderable": false
            },
        ]
    });

    $('body').on('change', 'input[type=checkbox]', function (e) {
        console.log($(this).val());
        var dataId = $(this).attr("data-pief-id");
        if ($(this).is(':checked')) {
            var flg = 1;
            var piefId = $(this).attr("data-pief-id");
            if (piefId && piefId != '') {
                var statusId = $(this).attr("data-status-id");
                if (statusId != 8) {
                    alert("Atentie! Acest task nu este inca verificat. Esti sigur ca doresti sa il inchizi? ");
                }
            } else {
                alert("Atentie! acest task nu are devizul intern generat si nu poate fi selectat pentru raport ");
                $(this).prop("checked", false);
                return false;
            }

        } else {
            var flg = 0;
        }
        console.log("ajax");
        $.ajax({
            url: base_url.concat('index.php/Reports/setSessionId'),
            type: "POST",    //request type,
            dataType: 'json',
            // data: JSON.stringify({id: $("#CompanyId").val()}),
            data: ({id: $(this).val(), flg: flg}),
            // headers: {'Content-Type': 'application/json'},
            success: function (response) {

            }
        });

    });

    $(document).on('click', '#generateBtn', function () {
        $('#reportType').val('1');
        $('#contractorInfo').addClass('hide');
        $('#statusInfo').addClass('hide');
        $('#contractorDrop').val('');
        $('#statusDrop').val('');
        $('#isReset').val(1);
        tblPreventivi.ajax.reload();
        $('#dtDiv').show();
        $("#dataTable_wrapper").show();
        $(".box-footer").show();
        $("#generateReportBtn").prop("disabled", false);

    });
    $(document).on('click', '#generateContractorBtn', function () {
        $('#reportType').val('2');
        $('#contractorDrop').val('');
        $('#statusDrop').val('');
        $('#contractorInfo').removeClass('hide');
        $('#statusInfo').removeClass('hide');
        $('#isReset').val(1);
        $("#dataTable_wrapper").hide();
        $(".box-footer").hide();
        tblPreventivi.ajax.reload();
        $('#dtDiv').show();
        $("#generateReportBtn").prop("disabled", true);

    });
    $(document).on('click', '#generateReportBtn', function () {
        $.ajax({
            url: base_url.concat('index.php/Reports/checkSessionId'),
            type: "post",    //request type,
            headers: {'Content-Type': 'application/json'},
            success: function (response) {
                if (response.Success == true) {
                    $("#reportForm").submit();
                    $('input:checkbox').removeAttr('checked');
                } else {
                    alert("select task");
                }
            }
        });
    });

    $("#contractorDrop").change(function () {
        $('#isReset').val(1);
        $("#contractorPm").val(this.value);
        if (this.value) {
            $("#dataTable_wrapper").show();
            $(".box-footer").show();
            $("#generateReportBtn").prop("disabled", false);
        } else {
            $("#dataTable_wrapper").hide();
            $(".box-footer").hide();
            $("#generateReportBtn").prop("disabled", true);
        }
        tblPreventivi.ajax.reload();
    });

    $("#statusDrop").change(function () {
        tblPreventivi.ajax.reload();
    });


});
