﻿angular.module('template', ["xeditable"]);

angular.module('template').controller("CreateTemplateController", function ($scope, $http) {
    var template = this;
    template.Id = 1;
    template.Name = '';
    template.Description = '';
    template.SelectedAreaIndex = 0;
    template.Areas = [];

    //Area
    template.NewArea = {
        //Name: 'Sector nou',
        Name: '',
        Elements: []
    };

    template.addArea = function () {
        template.Areas.push(template.NewArea);
        template.NewArea = {
            //Name: 'Sector nou',
            Name: '',
            Elements: []
        };
    };

    template.deleteArea = function (index) {
        template.Areas.splice(index, 1);
    };

    template.duplicateArea = function (index) {
        template.NewArea.Name = template.Areas[index].Name + "_Duplicat";

        for (var i = 0; i < template.Areas[index].Elements.length; i++) {
            template.NewElement.Name = template.Areas[index].Elements[i].Name;
            template.NewElement.NrOfPhotos = template.Areas[index].Elements[i].NrOfPhotos;

            template.NewArea.Elements.push(template.NewElement);
            template.NewElement = {
                Name: '',
                NrOfPhotos: 1
            };
        }
        template.Areas.push(template.NewArea);
        template.NewArea = {
            Name: '',
            Elements: []
        };
    };

    template.selectArea = function (index) {
        template.SelectedAreaIndex = index;
    };

    //elements
    template.NewElement = {
        //Name: 'Element nou',
        Name: '',
        NrOfPhotos: 1
    }

    template.addElement = function () {
        template.Areas[template.SelectedAreaIndex].Elements.push(template.NewElement);
        template.NewElement = {
            //Name: 'Element nou',
            Name: '',
            NrOfPhotos: 1
        };
    };

    template.deleteElement = function (index) {
        template.Areas[template.SelectedAreaIndex].Elements.splice(index, 1);
    };

    //Post data
    template.saveTemplate = function () {
        if (template.Areas == undefined || template.Areas == null || template.Areas.length <= 0) {
            alert("Sablonul nu contine sectoare/elemente!");
            return;
        }
        if (template.Name == null || template.Name == undefined || template.Name == "") {
            alert("Numele sablonului nu a fost completat!");
            return;
        }

        for (i = 0; i < template.Areas.length; i++) {
            if (template.Areas[i].Name == null || template.Areas[i].Name == undefined || template.Areas[i].Name == "") {
                alert("Sablonul contine sectoare fara nume!");
                return;
            }
        }

        $http({
            method: 'POST',
            url: '../api/ATemplate/Save',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(template)
        }).success(function (data) {
            //console.log(data);
            window.location.href = "View";
        });
    };
});

angular.module('template').controller("EditTemplate", function ($scope, $http) {
    var template = this;
    template.Id = 1;
    template.Name = '';
    template.Description = '';
    template.SelectedAreaIndex = 0;
    template.Areas = [];

    $scope.init = function (templateId) {
        template.Id = templateId;
        //console.log(template);
        GetDataFromServer("../../ws/TemplateService/GetById/" + template.Id, 'Template');       
    }

    function GetDataFromServer(url, attributeName) {
        $http.get(url).success(
            function ($data) {
                //console.log($data);                
                template.Name = $data.Name;
                template.Description = $data.Description;
                template.Areas = $data.Areas;
                
            }
        );
    }

    //Area
    template.NewArea = {
        //Name: 'Sector nou',
        Name: '',
        Elements: []
    };
    //ng-click="main.selectArea(area.Id)"
    template.addArea = function () {
        template.Areas.push(template.NewArea);
        template.NewArea = {
            //Name: 'Sector nou',
            Name: '',
            Elements: []
        };
    };

    template.duplicateArea = function (index) {
        template.NewArea.Name = template.Areas[index].Name + "_Duplicat";

        for (var i = 0; i < template.Areas[index].Elements.length; i++) {
            template.NewElement.Name = template.Areas[index].Elements[i].Name;
            template.NewElement.NrOfPhotos = template.Areas[index].Elements[i].NrOfPhotos;

            template.NewArea.Elements.push(template.NewElement);
            template.NewElement = {
                Name: '',
                NrOfPhotos: 1
            };
        }
        template.Areas.push(template.NewArea);
        template.NewArea = {
            Name: '',
            Elements: []
        };
    };

    template.deleteArea = function (index) {
        template.Areas.splice(index, 1);
    };

    template.selectArea = function (index) {
        template.SelectedAreaIndex = index;
    };

    //elements
    template.NewElement = {
        //Name: 'Element nou',
        Name: '',
        NrOfPhotos: 1
    }

    template.addElement = function () {
        template.Areas[template.SelectedAreaIndex].Elements.push(template.NewElement);
        template.NewElement = {
            //Name: 'Element nou',
            Name: '',
            NrOfPhotos: 1
        };
    };

    template.deleteElement = function (index) {
        template.Areas[template.SelectedAreaIndex].Elements.splice(index, 1);
    };

    //Post data
    template.updateTemplate = function () {

        for (i = 0; i < template.Areas.length; i++) {
            if (template.Areas[i].Name == null || template.Areas[i].Name == undefined || template.Areas[i].Name == "") {
                alert("Sablonul contine sectoare fara nume!");
                return;
            }
        }

        $http({
            method: 'POST',
            url: '../../ws/TemplateService/Update',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(template)
        }).success(function (data) {
            //console.log(data);
            window.location.href = "../View";
        });
    };
});