/*TEMPLATES MODULE*/
angular.module('template', ["xeditable"]);

angular.module('template').controller("CreateTemplateController", function ($scope, $http) {
    var template = this;
    template.Id = 1;
    template.Name = '';
    template.Description = '';
    template.SelectedAreaIndex = 0;
    template.Areas = [];

    //Area

    template.NewArea = {
        Name: 'Sector nou',
        Elements:[]
    };

    template.addArea = function() {
        template.Areas.push(template.NewArea);
        template.NewArea = {
            Name: 'Sector nou',
            Elements: []
        };
    };

    template.deleteArea = function (index) {
        template.Areas.splice(index, 1);
    };

    template.selectArea = function (index) {
        template.SelectedAreaIndex = index;
    };

    //elements
    template.NewElement = {
        Name: 'Element nou',
        NrOfPhotos: 1
    }

    template.addElement = function () {
        template.Areas[template.SelectedAreaIndex].Elements.push(template.NewElement);
        template.NewElement = {
            Name: 'Element nou',
            NrOfPhotos: 1
        };
    };

    template.deleteElement = function (index) {
        template.Areas[template.SelectedAreaIndex].Elements.splice(index, 1);
    };

    //Post data
    template.saveTemplate = function () {
        $http({
            method: 'POST',
            url: 'Save',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(template)
        }).success(function (data) {
            //console.log(data);
            window.location.href = "View";
        });
    };
});

/*PROJECTS MODULE*/
angular.module('project', ["xeditable"]);
angular.module('project').controller("CreateProjectController", function ($scope, $http) {
    var project = this;
    project.Id = -1;
    project.Code = '';
    project.Name = '';
    project.Address = '';
    project.District = {};
    project.DistrictList = [];
    project.StartDate = '';
    project.SiteAccess = 'Da';
    project.Client = {};
    project.ClientList = [];
    project.WorkType = {};
    project.WorkTypeList = [];
    project.ProjectType = {};
    project.ProjectTypeList = [];
    project.ProjectManager = {};
    project.ProjectManagerList = [];
    project.SiteManager = {};
    project.SiteManagerList = [];
    project.Responsable = {};
    project.ResponsableList = [];
    project.Areas = [];

    //Template
    project.TemplateList = [];
    project.SelectedTemplateId = -1;
    project.Template = {};

    project.SelectedAreaId = -1;
    project.selectedArea = {};

    project.templateChanged = function () {
        project.Template = project.TemplateList[project.SelectedTemplateId];
        project.selectedArea = null;
    };

    project.selectArea = function (areaId) {
        project.selectedArea = project.Template.Areas[areaId];
    };

    project.saveProject = function () {
        $http({
            method: 'POST',
            url: 'Save',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(project)
        }).success(function (data) {
            console.log(data);
            window.location.href = "View";
        });
    };

    function GetDataFromServer(url,attributeName) {
        $http.get(url).success(
            function ($data) {
                project[attributeName] = $data;
                //console.log($data);
            }
        );
    }

    function InitData() {
        GetDataFromServer("../api/ADistrict/GetAll", "DistrictList");
        GetDataFromServer("../api/AClient/GetAll", "ClientList");
        GetDataFromServer("../api/AWorkType/GetAll", "WorkTypeList");
        GetDataFromServer("../api/AProjectType/GetAll", "ProjectTypeList");
        GetDataFromServer("../api/AUser/GetProjectManagerList", "ProjectManagerList");
        GetDataFromServer("../api/AUser/GetSiteManagerList", "SiteManagerList");
        GetDataFromServer("../api/ATemplate/GetAll", "TemplateList");
        GetDataFromServer("../api/AResponsable/GetAll", "ResponsableList");
    }

    InitData();

});


/*Devize MODULE*/
angular.module('devize', ["xeditable"]);

angular.module('devize').controller("CreateDeviceController", function ($scope, $http) {
    var devize = this;
    devize.Id = 1;
    devize.Name = '';
    devize.Description = '';
    devize.SelectedAreaIndex = 0;
    devize.Areas = [];

    //Area

    devize.NewArea = {
        Name: 'Sector nou',
        Elements:[]
    };

    devize.addArea = function() {
        devize.Areas.push(devize.NewArea);
        devize.NewArea = {
            Name: 'Sector nou',
            Elements: []
        };
    };

    devize.deleteArea = function (index) {
        devize.Areas.splice(index, 1);
    };

    devize.selectArea = function (index) {
        devize.SelectedAreaIndex = index;
    };

    //elements
    devize.NewElement = {
        Name: 'Element nou',
        NrOfPhotos: 1
    }

    devize.addElement = function () {
        devize.Areas[devize.SelectedAreaIndex].Elements.push(devize.NewElement);
        devize.NewElement = {
            Name: 'Element nou',
            NrOfPhotos: 1
        };
    };

    devize.deleteElement = function (index) {
        devize.Areas[devize.SelectedAreaIndex].Elements.splice(index, 1);
    };

    //Post data
    devize.saveDevize = function () {
        $http({
            method: 'POST',
            url: 'Save',
            headers: { 'Content-Type': 'application/json' },
            data: JSON.stringify(devize)
        }).success(function (data) {
            //console.log(data);
            window.location.href = "View";
        });
    };
});
